/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;
import com.install4j.runtime.beans.actions.misc.PrivilegeRequirement;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.win32.MsiCommunication;
import java.util.Objects;

public class RequestPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean obtainIfAdminWin = true;
    private boolean obtainIfNormalWin = false;
    private boolean failIfNotObtainedWin = true;
    private boolean obtainIfAdminMac = false;
    private boolean obtainIfNormalMac = false;
    private boolean failIfNotObtainedMac = true;
    private PrivilegeRequirement linuxPrivilegeRequirement = PrivilegeRequirement.NONE;
    private boolean failIfNotObtainedLinux = false;
    private boolean failIfNotRootUnix = false;
    private boolean updateInstallationDirectory = true;

    public boolean isObtainIfAdminWin() {
        return this.replaceWithTextOverride("obtainIfAdminWin", this.obtainIfAdminWin);
    }

    public void setObtainIfAdminWin(boolean obtainIfAdminWin) {
        this.obtainIfAdminWin = obtainIfAdminWin;
    }

    public boolean isObtainIfNormalWin() {
        return this.replaceWithTextOverride("obtainIfNormalWin", this.obtainIfNormalWin);
    }

    public void setObtainIfNormalWin(boolean obtainIfNormalWin) {
        this.obtainIfNormalWin = obtainIfNormalWin;
    }

    public boolean isFailIfNotObtainedWin() {
        return this.replaceWithTextOverride("failIfNotObtainedWin", this.failIfNotObtainedWin);
    }

    public void setFailIfNotObtainedWin(boolean failIfNotObtainedWin) {
        this.failIfNotObtainedWin = failIfNotObtainedWin;
    }

    public boolean isObtainIfAdminMac() {
        return this.replaceWithTextOverride("obtainIfAdminMac", this.obtainIfAdminMac);
    }

    public void setObtainIfAdminMac(boolean obtainIfAdminMac) {
        this.obtainIfAdminMac = obtainIfAdminMac;
    }

    public boolean isObtainIfNormalMac() {
        return this.replaceWithTextOverride("obtainIfNormalMac", this.obtainIfNormalMac);
    }

    public void setObtainIfNormalMac(boolean obtainIfNormalMac) {
        this.obtainIfNormalMac = obtainIfNormalMac;
    }

    public boolean isFailIfNotObtainedMac() {
        return this.replaceWithTextOverride("failIfNotObtainedMac", this.failIfNotObtainedMac);
    }

    public void setFailIfNotObtainedMac(boolean failIfNotObtainedMac) {
        this.failIfNotObtainedMac = failIfNotObtainedMac;
    }

    public boolean isFailIfNotRootUnix() {
        return this.replaceWithTextOverride("failIfNotRootUnix", this.failIfNotRootUnix);
    }

    public void setFailIfNotRootUnix(boolean failIfNotRootUnix) {
        this.failIfNotRootUnix = failIfNotRootUnix;
    }

    public PrivilegeRequirement getLinuxPrivilegeRequirement() {
        return this.replaceWithTextOverride("linuxPrivilegeRequirement", this.linuxPrivilegeRequirement, PrivilegeRequirement.class);
    }

    public void setLinuxPrivilegeRequirement(PrivilegeRequirement linuxPrivilegeRequirement) {
        this.linuxPrivilegeRequirement = linuxPrivilegeRequirement;
    }

    public boolean isFailIfNotObtainedLinux() {
        return this.replaceWithTextOverride("failIfNotObtainedLinux", this.failIfNotObtainedLinux);
    }

    public void setFailIfNotObtainedLinux(boolean failIfNotObtainedLinux) {
        this.failIfNotObtainedLinux = failIfNotObtainedLinux;
    }

    public boolean isUpdateInstallationDirectory() {
        return this.replaceWithTextOverride("updateInstallationDirectory", this.updateInstallationDirectory);
    }

    public void setUpdateInstallationDirectory(boolean updateInstallationDirectory) {
        this.updateInstallationDirectory = updateInstallationDirectory;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        boolean success2 = this.requestRights(context2);
        boolean adminRightsSet = this.setAdminRightsVariable();
        if (adminRightsSet && RequestPrivilegesAction.isLinuxPrivilegeHandling()) {
            context2.setVariable("sys.adminRightsUiRootUnix", this.getLinuxPrivilegeRequirement() == PrivilegeRequirement.ROOT);
            InstallerVariables.registerResponseFileVariable("sys.adminRightsUiRootUnix");
        }
        if (context2 instanceof InstallerContext) {
            boolean sufficientRights = HelperCommunication.getInstance().hasElevatedHelper();
            if (!sufficientRights && !(sufficientRights = Util.hasFullAdminRights()) && Util.isMacOS() && !this.isObtainIfAdminMac() && Util.isAdminGroup()) {
                sufficientRights = InstallerConfig.canInstallTo(InstallerConfig.getInstallationDirWithSingleBundle(context2.getInstallationDirectory()));
            }
            if (!sufficientRights && !context2.getBooleanVariable("sys.resolveUserSpecificInstallationDir")) {
                context2.setVariable("sys.resolveUserSpecificInstallationDir", true);
                if (this.isUpdateInstallationDirectory() && !InstallerConfig.canInstallTo(InstallerConfig.getInstallationDirWithSingleBundle(context2.getInstallationDirectory()))) {
                    InstallerContext installerContext = (InstallerContext)context2;
                    installerContext.setInstallationDirectory(context2.getDefaultInstallationDirectory());
                }
            }
        }
        return success2;
    }

    private boolean requestRights(Context context2) throws UserCanceledException {
        if (Util.isWindows()) {
            return this.executeOnWindows(context2);
        }
        if (Util.isMacOS()) {
            return this.executeOnMac(context2);
        }
        if (RequestPrivilegesAction.isLinuxPrivilegeHandling()) {
            return this.executeOnLinux(context2);
        }
        return this.executeOnUnix(context2);
    }

    private boolean executeOnUnix(Context context2) throws UserCanceledException {
        if (this.isFailIfNotRootUnix() && !Util.hasFullAdminRights()) {
            this.showFailureMessage(context2);
            return false;
        }
        return true;
    }

    private boolean executeOnLinux(Context context2) throws UserCanceledException {
        if (!Util.hasFullAdminRights()) {
            switch (this.getLinuxPrivilegeRequirement()) {
                case NONE: {
                    return true;
                }
                case ROOT: {
                    this.showFailureMessage(context2);
                    return false;
                }
                case OBTAIN: {
                    if (!this.startOnLinux(context2) && this.isFailIfNotObtainedLinux()) {
                        this.showFailureMessage(context2);
                        return false;
                    }
                    return true;
                }
            }
        }
        return true;
    }

    private boolean executeOnMac(Context context2) throws UserCanceledException {
        boolean success2 = true;
        if (Util.isAdminGroup()) {
            if (this.isObtainIfAdminMac()) {
                success2 = Util.hasFullAdminRights() || this.startOnMac(context2);
            }
        } else if (this.isObtainIfNormalMac()) {
            success2 = this.startOnMac(context2);
        }
        if (!success2 && this.isFailIfNotObtainedMac()) {
            this.showFailureMessage(context2);
        }
        return success2;
    }

    private boolean executeOnWindows(Context context2) throws UserCanceledException {
        boolean success2 = true;
        if (Util.isAdminGroup()) {
            if (this.isObtainIfAdminWin()) {
                if (Util.hasFullAdminRights()) {
                    if (MsiHelper.isStartedFromMsi() && !context2.isUnattended() && MsiCommunication.isConnected() && MsiCommunication.sendElevationRequested()) {
                        MsiHelper.setMsiAllUsers(true);
                    }
                } else {
                    success2 = this.startOnWindows(context2);
                }
            }
        } else if (this.isObtainIfNormalWin()) {
            success2 = this.startOnWindows(context2);
        }
        if (!success2 && this.isFailIfNotObtainedWin()) {
            this.showFailureMessage(context2);
        }
        return success2;
    }

    public boolean isAllRequested(boolean windowsOnly) {
        return this.isObtainIfAdminWin() && this.isObtainIfNormalWin() && (windowsOnly || this.isObtainIfAdminMac() && this.isObtainIfNormalMac() && this.getLinuxPrivilegeRequirement() != PrivilegeRequirement.NONE);
    }

    public void setAllRequested(boolean windowsOnly) {
        this.setObtainIfAdminWin(true);
        this.setObtainIfNormalWin(true);
        this.setFailIfNotObtainedWin(true);
        if (!windowsOnly) {
            this.setObtainIfAdminMac(true);
            this.setObtainIfNormalMac(true);
            this.setFailIfNotObtainedMac(true);
            if (this.getLinuxPrivilegeRequirement() == PrivilegeRequirement.NONE) {
                this.setLinuxPrivilegeRequirement(PrivilegeRequirement.OBTAIN);
            }
            this.setFailIfNotObtainedLinux(true);
            this.setFailIfNotRootUnix(true);
        }
    }

    static boolean isLinuxPrivilegeHandling() {
        return Util.isLinux() || !Util.isWindows() && !Util.isMacOS() && Objects.equals(Boolean.TRUE, InstallerVariables.getVariable("sys.forcePrivilegeRequest"));
    }
}

