/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.exe4j.runtime.util.ResourceHelper;
import com.exe4j.runtime.util.WinDel;
import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MsiScope;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.platform.macos.MacAuthorization;
import com.install4j.runtime.installer.platform.win32.MsiCommunication;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.launcher.integration.gui.AwtAndFxWindowChecker;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPrivilegesAction
extends SystemInstallOrUninstallAction {
    private static boolean helperStarted = false;

    protected boolean startOnLinux(Context context2) throws UserCanceledException {
        boolean usePkexec;
        boolean bl = usePkexec = context2.isGui() || InstallerUtil.isUnattendedAlerts() || InstallerUtil.isUnattendedWithProgress();
        if (!usePkexec && context2.isUnattended()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            return true;
        }
        if (!new File(moduleName).exists()) {
            Util.showMessage(Messages.format(Messages.getString(".ErrorInternal2"), "Could not start elevated: " + moduleName), 0);
            return false;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        ProcessBuilder.Redirect inputRedirect = ProcessBuilder.Redirect.PIPE;
        ArrayList<String> command2 = new ArrayList<String>();
        if (usePkexec) {
            command2.add("pkexec");
            command2.add("--disable-internal-agent");
            command2.addAll(this.getMainCommand(context2, moduleName, helperCommunication, identifier));
        } else {
            boolean useSudo;
            inputRedirect = ProcessBuilder.Redirect.INHERIT;
            boolean bl2 = useSudo = ConsoleImpl.getInstance().askOption(Messages.getString(".RootAuthorizationMethod"), new String[]{"sudo", "su"}, null, 0) == 0;
            if (useSudo) {
                command2.add("sudo");
                command2.addAll(this.getMainCommand(context2, moduleName, helperCommunication, identifier));
            } else {
                command2.add("su");
                command2.add("-c");
                command2.add(this.getMainCommand(context2, moduleName, helperCommunication, identifier).stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(" ")));
            }
        }
        try {
            Process process2 = new ProcessBuilder(command2).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectInput(inputRedirect).start();
            if (process2.waitFor(10L, TimeUnit.MINUTES)) {
                int exitValue = process2.exitValue();
                if (exitValue != 0) {
                    Logger.getInstance().error(this, "Exit value of helper process is " + exitValue);
                } else {
                    helperStarted = helperCommunication.connect();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.getInstance().log(e);
            return false;
        }
        return helperStarted;
    }

    private List<String> getMainCommand(Context context2, String moduleName, HelperCommunication helperCommunication, String identifier) {
        ArrayList<String> command2 = new ArrayList<String>();
        if (InstallerConfig.isInstaller()) {
            command2.add("/bin/sh");
        }
        command2.add(moduleName);
        command2.add("__i4j_auth_restart");
        command2.add(new File(System.getProperty("user.dir")).getAbsolutePath());
        command2.add(new File(System.getProperty("java.home")).getAbsolutePath());
        if (Installer.getManualTempDir() != null) {
            command2.add("-temp");
            command2.add(Installer.getManualTempDir());
        }
        for (String argument : this.getCommonArguments(context2, identifier, helperCommunication.getHash())) {
            command2.add("-J" + argument);
        }
        return command2;
    }

    protected boolean startOnMac(Context context2) {
        if (!Util.isMacosInstaller()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        List<String> arguments2 = this.getJavaArguments(context2, identifier, helperCommunication.getHash(), !InstallerUtil.isInProcess());
        String prompt = MacAuthorization.getDefaultPrompt(InstallerConfig.getCurrentInstance() == null ? null : InstallerConfig.getCurrentInstance().getApplicationName());
        try {
            MacAuthorization.execute(prompt, this.getJavaPath(), arguments2);
            helperStarted = helperCommunication.connect();
        }
        catch (MacAuthorization.BaseAuthorizationException e) {
            Logger.getInstance().log(e);
        }
        return helperStarted;
    }

    @NotNull
    private String getJavaPath() {
        return new File(System.getProperty("java.home"), "bin/java").getAbsolutePath();
    }

    @NotNull
    private List<String> getJavaArguments(Context context2, String identifier, String hash, boolean useCurrentClassPath) {
        String classPath = useCurrentClassPath ? System.getProperty("java.class.path") : new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath();
        ArrayList<String> arguments2 = new ArrayList<String>();
        arguments2.add("-classpath");
        arguments2.add(classPath);
        arguments2.addAll(this.getCommonArguments(context2, identifier, hash));
        if (System.getProperty("exe4j.moduleName") != null) {
            arguments2.add("-Dexe4j.moduleName=" + System.getProperty("exe4j.moduleName"));
        }
        if (System.getProperty("i4j.jreBundle") != null) {
            arguments2.add("-Di4j.jreBundle=" + System.getProperty("i4j.jreBundle"));
        }
        if (System.getProperty("i4j.tarFile") != null) {
            arguments2.add("-Di4j.tarFile=" + System.getProperty("i4j.tarFile"));
        }
        if (System.getProperty("install4j.debugLaunch") != null) {
            arguments2.add("-Dinstall4j.debugLaunch=" + System.getProperty("install4j.debugLaunch"));
        }
        if (System.getProperty("install4j.noSuid") != null) {
            arguments2.add("-Dinstall4j.noSuid=" + System.getProperty("install4j.noSuid"));
        }
        arguments2.add("-Dapple.awt.UIElement=true");
        arguments2.add(HelperCommunication.class.getName());
        Logger.getInstance().info(null, "args: " + arguments2);
        return arguments2;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startOnWindows(Context context2) {
        Window parentWindow = UiUtil.getParentWindow();
        if (parentWindow != null) {
            parentWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            boolean bl = this.startOnWindowsUnguarded(context2);
            return bl;
        }
        finally {
            if (parentWindow != null) {
                parentWindow.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private boolean startOnWindowsUnguarded(Context context2) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        if (helperStarted) {
            Util.logInfo(this, "Elevated helper process already started");
            return true;
        }
        if (MsiHelper.isStartedFromMsi()) {
            if (!MsiHelper.isMsiAllUsers(context2) && MsiHelper.getMsiScope() == MsiScope.PER_USER) {
                Util.logInfo(this, "Elevation is not available in a per-user MSI scope");
                return false;
            }
            if (context2.isUnattended()) {
                Util.logInfo(this, "Elevation is not available for MSI in unattended mode");
                return false;
            }
        }
        if (Win32UserInfo.isUACDisabled()) {
            return false;
        }
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            return true;
        }
        if (!new File(moduleName).exists()) {
            Util.logError(this, "Executable " + moduleName + " not found");
            Util.showMessage(Messages.format(Messages.getString(".ErrorInternal2"), "Could not start elevated: " + moduleName), 0);
            return false;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        Util.logInfo(this, "Starting elevated helper");
        SplashProgressInterface splashProgressInterface = this.checkSplashScreen(context2);
        InstallerUtil.storeJreInfoForInstaller();
        String arguments2 = "__i4j_lang_restart" + (Installer.getManualTempDir() == null ? "" : " -temp \"" + Installer.getManualTempDir() + "\"") + AbstractPrivilegesAction.joinWithPrefix(this.getCommonArguments(context2, identifier, helperCommunication.getHash())) + " -J-D" + "exe4j.unextractedPositionRestart" + "=" + Integer.getInteger("exe4j.unextractedPositionRestart", Integer.getInteger("exe4j.unextractedPosition", 0)) + " -J-D" + "install4j.dontUninstallServices" + "=" + Boolean.getBoolean("install4j.dontUninstallServices") + (WinDel.SEMAPHORE_NAME == null ? "" : " \"-J-Dexe4j.semaphoreName=" + WinDel.SEMAPHORE_NAME + "\"") + (System.getProperty("windel.logfile") == null ? "" : " \"-J-Dwindel.logfile=" + System.getProperty("windel.logfile") + "\"");
        if (MsiCommunication.isConnected()) {
            if (InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().getMsiScope() == MsiScope.PER_USER) {
                MsiCommunication.sendElevationRequested();
            } else {
                helperStarted = MsiCommunication.executeElevated(MsiHelper.addMsiArguments(arguments2));
                if (helperStarted) {
                    MsiHelper.setMsiAllUsers(true);
                }
            }
        } else {
            helperStarted = Win32UserInfo.executeElevated(moduleName, arguments2, System.getProperty("user.dir"));
        }
        boolean bl = helperStarted = helperStarted && helperCommunication.connect();
        if (helperStarted && !AbstractPrivilegesAction.checkFullAdminRights()) {
            Logger.getInstance().error(this, "The elevated helper does not have full admin rights");
            helperCommunication.terminate();
            helperStarted = false;
        }
        if (splashProgressInterface != null) {
            splashProgressInterface.setVisible(false);
        }
        return helperStarted;
    }

    private static String joinWithPrefix(List<String> arguments2) {
        StringBuilder builder = new StringBuilder();
        for (String argument : arguments2) {
            builder.append(" -J");
            builder.append(argument);
        }
        return builder.toString();
    }

    @NotNull
    private List<String> getCommonArguments(Context context2, String identifier, String hash) {
        ArrayList<String> arguments2 = new ArrayList<String>();
        int debugPort = Integer.getInteger("install4j.helperDebugPort", 0);
        if (debugPort > 0) {
            arguments2.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort);
        }
        arguments2.add(System.getProperty("install4j.helperMaxHeap", "-Xmx128m"));
        arguments2.add("-Duser.language=" + context2.getLanguageId());
        arguments2.add("-Dinstall4j.language=" + context2.getLanguageId());
        arguments2.add("-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage"));
        arguments2.add("-Dinstall4j.commIdentifier=" + identifier);
        arguments2.add("-Dinstall4j.commHash=" + hash);
        arguments2.add("-Dinstall4j.helperAppId=" + InstallerConfig.getCurrentApplicationId());
        arguments2.add("-Dinstall4j.helperLog=" + Boolean.getBoolean("install4j.helperLog"));
        arguments2.add("-Dinstall4j.dontUninstallServices=" + Boolean.getBoolean("install4j.dontUninstallServices"));
        return arguments2;
    }

    protected boolean setAdminRightsVariable() {
        boolean adminRights = Util.isAdminGroup() && Util.hasFullAdminRights() || HelperCommunication.getInstance().hasElevatedHelper();
        InstallerVariables.setAdminRightsFromPrivilegesAction(adminRights);
        return adminRights;
    }

    private static boolean checkFullAdminRights() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context2) throws Exception {
                return Util.hasFullAdminRights();
            }
        });
    }

    @Nullable
    private String getModuleName() {
        String moduleName;
        Application application2 = InstallerConfig.getCurrentApplication();
        if (application2 instanceof CustomApplication && !((CustomApplication)application2).isCreateExecutable()) {
            Util.logError(this, "No elevation can be performed in a custom application without an executable.");
            return null;
        }
        if (InstallerUtil.isInProcess()) {
            File exeFile = com.install4j.runtime.installer.Application.getExeFile((ApplicationWithPath)application2);
            if (exeFile != null) {
                moduleName = exeFile.getAbsolutePath();
            } else {
                moduleName = null;
                Util.logError(this, "Internal error: The executable of the custom application is null.");
            }
        } else {
            moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                Util.showMessage("No elevation can be performed for debug installers. Continuing without elevation.", 1);
            }
        }
        return moduleName;
    }

    private SplashProgressInterface checkSplashScreen(Context context2) {
        SplashProgressInterface ret = null;
        if (!(InstallerConfig.isInstaller() && !((InstallerApplication)InstallerConfig.getCurrentApplication()).isSuppressProgressDialog() || context2.isConsole() || context2.isUnattended() || AwtAndFxWindowChecker.hasVisibleWindows())) {
            SplashProgressInterface splashProgressInterface;
            String title = "install4j";
            if (context2.getWizardContext() instanceof WizardScreenExecutor) {
                title = ((WizardScreenExecutor)context2.getWizardContext()).getWindowTitle();
            }
            ret = splashProgressInterface = new SplashProgressInterface(title, false, false, false, null, false, null);
            splashProgressInterface.setStatusMessage(Messages.getString(".ProcessElevationTitle"));
            try {
                Runnable runnable = () -> {
                    splashProgressInterface.setIndeterminateProgress(true);
                    splashProgressInterface.setVisible(true);
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected void showFailureMessage(Context context2) throws UserCanceledException {
        String message = context2 instanceof InstallerContext ? (InstallerConfig.getCurrentApplication() instanceof InstallerApplication ? (Util.isWindows() ? Messages.getString(".AdminPrivilegesRequired") : Messages.getString(".RootPrivilegesRequired")) : (Util.isWindows() ? Messages.getString(".AdminPrivilegesRequiredExecute") : Messages.getString(".RootPrivilegesRequiredExecute"))) : Messages.getString(".OnlyAdminCanUninstall");
        Util.showMessage(message, 0);
        throw new UserCanceledException("not admin");
    }

    private String getHelperDebugArgument(String prefix, boolean withSpace) {
        int debugPort = Integer.getInteger("install4j.helperDebugPort", 0);
        if (debugPort > 0) {
            return (withSpace ? " " : "") + prefix + "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort;
        }
        return "";
    }
}

