/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.jdbc.AbstractJdbcAction;
import com.install4j.runtime.beans.actions.jdbc.ScriptSource;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.LineIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ExecuteSqlScriptAction
extends AbstractJdbcAction {
    private static final String ENCODED_LINE_BREAK = "\\n";
    private ScriptSource scriptSource = ScriptSource.DIRECT;
    private String script = "";
    private ExternalFile scriptFile;
    private String encoding = "";
    private String delimiter = ";";
    private boolean commitEachStatement = false;
    private boolean ignoreErrors = false;

    public ScriptSource getScriptSource() {
        return this.replaceWithTextOverride("scriptSource", this.scriptSource, ScriptSource.class);
    }

    public void setScriptSource(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public String getScript() {
        return ExecuteSqlScriptAction.replaceVariables(this.script);
    }

    public void setScript(String script) {
        this.script = script;
    }

    public ExternalFile getScriptFile() {
        return this.replaceWithTextOverride("scriptFile", this.scriptFile, ExternalFile.class);
    }

    public void setScriptFile(ExternalFile scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getEncoding() {
        return ExecuteSqlScriptAction.replaceVariables(ExecuteSqlScriptAction.replaceVariables(this.encoding));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ExecuteSqlScriptAction.replaceVariables(ExecuteSqlScriptAction.replaceVariables(this.delimiter));
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isCommitEachStatement() {
        return this.replaceWithTextOverride("commitEachStatement", this.commitEachStatement);
    }

    public void setCommitEachStatement(boolean commitEachStatement) {
        this.commitEachStatement = commitEachStatement;
    }

    public boolean isIgnoreErrors() {
        return this.replaceWithTextOverride("ignoreErrors", this.ignoreErrors);
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    @Override
    protected boolean executeJdbcCall(Context context2) throws UserCanceledException {
        return this.withStatement(statement -> {
            Iterator<String> lineIterator = this.createLineIterator(context2);
            if (lineIterator == null) {
                return false;
            }
            try {
                Connection connection = statement.getConnection();
                if (!this.isCommitEachStatement()) {
                    connection.setAutoCommit(false);
                }
                String delimiterInLine = this.getDelimiterInLine();
                Matcher delimiterMatcher = Pattern.compile(delimiterInLine).matcher("");
                StringBuilder buffer = new StringBuilder();
                while (lineIterator.hasNext()) {
                    String replacedLine = ExecuteSqlScriptAction.replaceVariables(lineIterator.next().trim());
                    for (String line : replacedLine.split("\n")) {
                        buffer.append(line);
                        delimiterMatcher.reset(line);
                        boolean execute = delimiterMatcher.find();
                        if (execute) {
                            if (buffer.length() > 0) {
                                String[] singleStatements;
                                for (String singleStatement : singleStatements = buffer.toString().split(delimiterInLine)) {
                                    if (this.executeLine(statement, connection, singleStatement)) continue;
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            buffer.setLength(0);
                            continue;
                        }
                        buffer.append('\n');
                    }
                }
                if (buffer.length() > 0 && !this.executeLine(statement, connection, buffer.toString())) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.isCommitEachStatement()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (lineIterator instanceof Closeable) {
                    try {
                        ((Closeable)((Object)lineIterator)).close();
                    }
                    catch (IOException e) {
                        Logger.getInstance().log(e);
                    }
                }
            }
        });
    }

    @NotNull
    protected String getDelimiterInLine() {
        String delimiter = this.getDelimiter();
        if (delimiter.endsWith(ENCODED_LINE_BREAK)) {
            return delimiter.substring(0, delimiter.length() - ENCODED_LINE_BREAK.length()) + "$";
        }
        return delimiter;
    }

    private boolean executeLine(Statement statement, Connection connection, String line) throws SQLException {
        block2: {
            try {
                statement.execute(line);
            }
            catch (SQLException e) {
                this.logError("Error executing script line \"" + line + "\", error message: \"" + e.getMessage() + "\"");
                this.logDebug(e);
                if (this.isIgnoreErrors()) break block2;
                connection.rollback();
                return false;
            }
        }
        return true;
    }

    private Iterator<String> createLineIterator(Context context2) {
        switch (this.getScriptSource()) {
            case DIRECT: {
                return Arrays.asList(this.getScript().split("\n")).iterator();
            }
            case FILE: {
                File file = context2.getExternalFile(this.getScriptFile(), false);
                try {
                    return new LineIterator(FileUtil.createTextFileReader(file, this.getEncoding()));
                }
                catch (FileNotFoundException e) {
                    Logger.getInstance().log(this, "The script file " + file + " could not be found", false);
                    return null;
                }
                catch (IOException e) {
                    Logger.getInstance().log(this, "Error reading script file " + file + "", false);
                    Logger.getInstance().log(e);
                    return null;
                }
            }
        }
        throw new RuntimeException(this.getScriptSource().name());
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

