/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.install4j.api.Util;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJdbcAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    private static final boolean DEBUG = Boolean.getBoolean("install4j.debugJdbc");
    protected static final String VARIABLE_CONNECTION = "sys.jdbc.connection";
    protected static final String VARIABLE_ERROR_MESSAGE_VARIABLE_NAME = "sys.jdbc.errorMessagesVariableName";
    private String driverClassName = "";
    private String jdbcUrl = "";
    private String user = "";
    private String password = "";
    private Map<String, String> jdbcProperties = new LinkedHashMap<String, String>();
    private String errorMessagesVariableName = "";
    private boolean logWarnings = false;
    private StringBuilder errorMessageBuffer;
    private Connection containerConnection;

    public String getDriverClassName() {
        return AbstractJdbcAction.replaceVariables(AbstractJdbcAction.replaceVariables(this.driverClassName));
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return AbstractJdbcAction.replaceVariables(AbstractJdbcAction.replaceVariables(this.jdbcUrl));
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return AbstractJdbcAction.replaceVariables(AbstractJdbcAction.replaceVariables(this.user));
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return AbstractJdbcAction.replaceVariables(AbstractJdbcAction.replaceVariables(this.password));
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getJdbcProperties() {
        return this.replaceWithTextOverride("jdbcProperties", this.jdbcProperties, Map.class);
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    public String getErrorMessagesVariableName() {
        return AbstractJdbcAction.replaceVariables(this.errorMessagesVariableName);
    }

    public void setErrorMessagesVariableName(String errorMessagesVariableName) {
        this.errorMessagesVariableName = errorMessagesVariableName;
    }

    public boolean isLogWarnings() {
        return this.replaceWithTextOverride("logWarnings", this.logWarnings);
    }

    public void setLogWarnings(boolean logWarnings) {
        this.logWarnings = logWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        this.errorMessageBuffer = new StringBuilder();
        try {
            this.containerConnection = (Connection)context2.getVariable(VARIABLE_CONNECTION);
            if (this.containerConnection == null) {
                try {
                    Class.forName(this.getDriverClassName(), true, Install4jClassLoader.getInstance());
                }
                catch (ClassNotFoundException e) {
                    this.logError("Driver class " + this.getDriverClassName() + " was not found. Add the JAR file to the \"Installer->Custom code & resources\" step.");
                    boolean bl = false;
                    String variableName = this.getUsedErrorMessagesVariableName(context2);
                    if (variableName != null && !variableName.isEmpty()) {
                        context2.setVariable(this.getErrorMessagesVariableName(), this.errorMessageBuffer.toString());
                    }
                    return bl;
                }
                catch (Throwable t) {
                    this.logError("Error initializing driver");
                    Logger.getInstance().log(t);
                    boolean bl = false;
                    String variableName = this.getUsedErrorMessagesVariableName(context2);
                    if (variableName != null && !variableName.isEmpty()) {
                        context2.setVariable(this.getErrorMessagesVariableName(), this.errorMessageBuffer.toString());
                    }
                    return bl;
                }
            }
            boolean bl = this.executeJdbcCall(context2);
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            String variableName = this.getUsedErrorMessagesVariableName(context2);
            if (variableName != null && !variableName.isEmpty()) {
                context2.setVariable(this.getErrorMessagesVariableName(), this.errorMessageBuffer.toString());
            }
        }
    }

    private String getUsedErrorMessagesVariableName(Context context2) {
        String value = (String)context2.getVariable(VARIABLE_ERROR_MESSAGE_VARIABLE_NAME);
        if (value != null) {
            return value;
        }
        return this.getErrorMessagesVariableName();
    }

    protected abstract boolean executeJdbcCall(Context var1) throws UserCanceledException;

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        if (Objects.equals(propertyName, "password") && !Boolean.getBoolean("install4j.logJdbcPassword")) {
            return "[logging of password is disabled]";
        }
        return propertyValue;
    }

    protected Connection createConnection() throws SQLException {
        if (this.containerConnection != null) {
            return this.containerConnection;
        }
        Properties properties2 = new Properties();
        String user = this.getUser();
        String password = this.getPassword();
        if (!user.isEmpty()) {
            properties2.put("user", user);
        }
        if (!password.isEmpty()) {
            properties2.put("password", password);
        }
        properties2.putAll(this.getJdbcProperties());
        try {
            return (Connection)Install4jClassLoader.invokeInCustomClassLoader(DriverManager.class.getMethod("getConnection", String.class, Properties.class), null, this.getJdbcUrl(), properties2);
        }
        catch (Error | RuntimeException | SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected boolean withResultSet(String sql, ResultSetConsumer resultSetConsumer) throws UserCanceledException {
        return this.withStatement(statement -> {
            boolean bl;
            block8: {
                ResultSet rs = statement.executeQuery(sql);
                try {
                    bl = resultSetConsumer.run(rs);
                    if (rs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logError("Could not execute query: " + e.getMessage());
                        this.logDebug(e);
                        return false;
                    }
                }
                rs.close();
            }
            return bl;
        });
    }

    protected boolean withStatement(StatementConsumer statementConsumer) throws UserCanceledException {
        boolean logWarnings = this.isLogWarnings();
        return this.withConnection(connection -> {
            boolean bl;
            block9: {
                Statement statement = connection.createStatement();
                try {
                    boolean value = statementConsumer.run(statement);
                    if (logWarnings) {
                        this.logWarnings(statement.getWarnings());
                    }
                    bl = value;
                    if (statement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logError("Could not create JDBC statement: " + e.getMessage());
                        this.logDebug(e);
                        return false;
                    }
                }
                statement.close();
            }
            return bl;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean withConnection(ConnectionConsumer connectionConsumer) throws UserCanceledException {
        Connection connection = null;
        try {
            connection = this.createConnection();
            boolean bl = connectionConsumer.run(connection);
            return bl;
        }
        catch (SQLException e) {
            this.logError("Could not create JDBC connection: " + e.getMessage());
            this.logDebug(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null && connection != this.containerConnection) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void logWarnings(@Nullable SQLWarning warnings) {
        while (warnings != null) {
            Util.logInfo(this, "Warning: " + warnings.getMessage());
            warnings = warnings.getNextWarning();
        }
    }

    protected void logError(String message) {
        if (this.errorMessageBuffer.length() > 0) {
            this.errorMessageBuffer.append('\n');
        }
        this.errorMessageBuffer.append(message);
        Logger.getInstance().log(this, message, false);
    }

    protected void logSuccess(String message) {
        Logger.getInstance().log(this, message, true);
    }

    protected void logDebug(SQLException e) {
        if (DEBUG) {
            Logger.getInstance().log(e);
        }
    }

    public static interface ResultSetConsumer {
        public boolean run(ResultSet var1) throws SQLException;
    }

    public static interface StatementConsumer {
        public boolean run(Statement var1) throws SQLException;
    }

    public static interface ConnectionConsumer {
        public boolean run(Connection var1) throws SQLException, UserCanceledException;
    }
}

