/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.finish;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.LauncherSetup;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.InstallerContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import java.io.File;

public class ExecuteLauncherAction
extends SystemInstallOrUninstallAction {
    private String launcherId = "";
    private String[] arguments;

    public String getLauncherId() {
        return ExecuteLauncherAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public String[] getArguments() {
        return this.replaceWithTextOverride("arguments", ExecuteLauncherAction.replaceVariables(this.arguments), String[].class);
    }

    public void setArguments(String[] arguments2) {
        this.arguments = arguments2;
    }

    @Override
    public boolean execute(Context context2) {
        LauncherSetup launcher = context2.getLauncherById(this.getLauncherId());
        if (launcher == null) {
            return false;
        }
        MacSpecificConfig macSpecificConfig = InstallerConfig.getCurrentInstance().getMacSpecificConfig();
        final File launcherFile = Util.isMacosInstaller() && macSpecificConfig.isSingleBundle() ? context2.getDestinationFile(macSpecificConfig.getSingleBundleName()) : context2.getDestinationFile(new File(ExecuteLauncherAction.replaceVariables(launcher.getRelativeFileName())));
        final String[] arguments2 = this.getArguments();
        if (InstallerConfig.isInstaller() && Util.isMacosInstaller() && InstallerConfig.getCurrentInstance().getMacSpecificConfig().isSingleBundle()) {
            Util.logInfo(this, "Deferring execution of launcher for single bundle installer");
            final ExecutionContext executionContext = HelperCommunication.getInstance().isElevatedHelper() ? ExecutionContext.ELEVATED : ExecutionContext.UNELEVATED;
            HelperCommunication.getInstance().executeAction(ContentInstaller.getExecutionContext(), new RunAction(){

                @Override
                protected void run(Context context2) {
                    ExecuteLauncherAction.registerSingleBundleExecutableLauncher(launcherFile, arguments2, executionContext);
                }
            });
            return true;
        }
        return ExecuteLauncherAction.launch(launcherFile, arguments2, ExecutionContext.SAME);
    }

    private static void registerSingleBundleExecutableLauncher(File launcherFile, String[] arguments2, ExecutionContext executionContext) {
        InstallerContextImpl.registerAfterFinishAction(() -> {
            MacFileSystem.notifyBundleChange(launcherFile);
            ExecuteLauncherAction.launch(launcherFile, arguments2, executionContext);
        });
    }

    private static boolean launch(File launcherFile, String[] arguments2, ExecutionContext executionContext) {
        Util.logInfo(null, "Launching " + launcherFile);
        return LaunchHelper.launchFinishExecutable(launcherFile, arguments2, launcherFile.getParentFile(), executionContext);
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

