/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractExtractArchiveAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.FileAttributesHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExtractDmgFileAction
extends AbstractExtractArchiveAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean extract(Context context2, File archiveFile, File destinationDirectory) throws IOException {
        final ProgressAdapter progressInterface = new ProgressAdapter(context2.getProgressInterface(), 0, 100);
        this.initProgress(progressInterface, 0);
        File mountPoint = VolumeInfo.attachDmg(archiveFile, true);
        boolean attachPerformed = true;
        if (mountPoint == null) {
            attachPerformed = false;
            mountPoint = VolumeInfo.findAttachedDmg(archiveFile);
            if (mountPoint == null) {
                return false;
            }
        }
        HashSet<String> excludedEntryNames = new HashSet<String>();
        final long totalLength = this.countTotalLength(context2, excludedEntryNames, mountPoint, mountPoint, "");
        FileUtil.CopyProgressListener copyProgressListener = null;
        if (this.isShowProgress()) {
            copyProgressListener = new FileUtil.CopyProgressListener(){
                long lastProgress = 0L;
                long copiedSoFar = 0L;

                @Override
                public boolean progressPerformed(long val) {
                    this.copiedSoFar += val;
                    long newProgress = this.copiedSoFar * 100L / totalLength;
                    if (newProgress > 100L) {
                        newProgress = 100L;
                    }
                    if (newProgress > this.lastProgress) {
                        this.lastProgress = newProgress;
                        progressInterface.setPercentCompleted((int)newProgress);
                    }
                    return true;
                }
            };
        }
        try {
            this.copyFiles(excludedEntryNames, copyProgressListener, this.isShowProgress() && this.isShowFileNames() ? progressInterface : null, mountPoint, destinationDirectory, "");
        }
        finally {
            if (attachPerformed && !VolumeInfo.detach(mountPoint)) {
                Logger.getInstance().error(null, "could not detach " + archiveFile + " from " + mountPoint);
            }
        }
        return true;
    }

    private void copyFiles(Set<String> excludedEntryNames, FileUtil.CopyProgressListener copyProgressListener, ProgressInterface fileNameProgressInterface, File sourceDir, File destinationDir, String prefix) throws IOException {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String entryName = this.getEntryName(prefix, file);
                if (excludedEntryNames.contains(entryName)) continue;
                if (fileNameProgressInterface != null) {
                    fileNameProgressInterface.setDetailMessage(entryName);
                }
                File destinationFile = new File(destinationDir, file.getName());
                if (Files.isSymbolicLink(file.toPath())) {
                    UnixFileSystem.createLink(Files.readSymbolicLink(file.toPath()).toString(), destinationFile);
                } else if (file.isFile()) {
                    FileUtil.copyFile(file, destinationFile, copyProgressListener);
                } else if (file.isDirectory()) {
                    destinationFile.mkdirs();
                    this.copyFiles(excludedEntryNames, copyProgressListener, fileNameProgressInterface, file, destinationFile, entryName);
                }
                destinationFile.setLastModified(file.lastModified());
                UnixFileSystem.setMode(FileAttributesHelper.getPosixFilePermissions(file), destinationFile);
            }
        }
    }

    private long countTotalLength(Context context2, Set<String> excludedEntryNames, File mountPoint, File sourceDir, String prefix) {
        long length = 0L;
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String entryName = this.getEntryName(prefix, file);
                if (this.matchesFileFilter(context2, entryName, mountPoint)) {
                    if (Files.isSymbolicLink(file.toPath())) continue;
                    if (file.isFile()) {
                        length += file.length();
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    length += this.countTotalLength(context2, excludedEntryNames, mountPoint, file, entryName);
                    continue;
                }
                excludedEntryNames.add(entryName);
            }
        }
        return length;
    }

    @NotNull
    private String getEntryName(String prefix, File file) {
        String newPrefix = prefix.isEmpty() ? file.getName() : prefix + File.separator + file.getName();
        return newPrefix;
    }

    @Override
    protected boolean isAvailable() {
        return Util.isMacOS();
    }

    private boolean matchesFileFilter(Context context2, String entryName, File mountPoint) {
        File entryFile = new File(entryName);
        return ContextImpl.runBooleanScript(context2, this.getFileFilter(), this, entryFile, mountPoint);
    }
}

