/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;

public class CopyFileAction
extends AbstractRecursiveFileAction {
    private File destinationFile;
    private ArchiveFileOperationRoot destinationRoot = ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private String mode = "644";
    private String directoryMode = "755";
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delay = false;
    private boolean triggerReboot = true;
    private transient boolean toSingleFile;

    public boolean isDelay() {
        return this.replaceWithTextOverride("delay", this.delay);
    }

    public void setDelay(boolean delay) {
        this.delay = delay;
    }

    public boolean isTriggerReboot() {
        return this.replaceWithTextOverride("triggerReboot", this.triggerReboot);
    }

    public void setTriggerReboot(boolean triggerReboot) {
        this.triggerReboot = triggerReboot;
    }

    public String getDirectoryMode() {
        return CopyFileAction.replaceVariables(this.directoryMode);
    }

    public void setDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
    }

    public File getDestinationFile() {
        return this.replaceWithTextOverride("destinationFile", CopyFileAction.replaceVariables(this.destinationFile), File.class);
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public ArchiveFileOperationRoot getDestinationRoot() {
        return this.replaceWithTextOverride("destinationRoot", this.destinationRoot, ArchiveFileOperationRoot.class);
    }

    public void setDestinationRoot(ArchiveFileOperationRoot destinationRoot) {
        this.destinationRoot = destinationRoot;
    }

    public OverwriteMode getOverwriteMode() {
        return this.replaceWithTextOverride("overwriteMode", this.overwriteMode, OverwriteMode.class);
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public UninstallMode getUninstallMode() {
        return this.replaceWithTextOverride("uninstallMode", this.uninstallMode, UninstallMode.class);
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    public String getMode() {
        return CopyFileAction.replaceVariables(this.mode);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isShared() {
        return this.replaceWithTextOverride("shared", this.shared);
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    @Override
    protected ArchiveFileOperationRoot getInitialFilesRoot() {
        return ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeForMultipleFilesAction(Context context2, File[] files) throws UserCanceledException {
        File destinationFile = this.getUsedDestinationFile(context2);
        this.toSingleFile = false;
        if (!destinationFile.isDirectory()) {
            if (files.length > 1) {
                Logger.getInstance().log(this, "Destination file " + destinationFile + " is not a directory and there are more than one source files", false);
                return false;
            }
            if (context2.getDestinationFile(files[0]).isFile()) {
                this.toSingleFile = true;
            }
        }
        FileInstaller.getInstance().resetCurrentRebootRequired();
        try {
            boolean bl = super.executeForMultipleFilesAction(context2, files);
            return bl;
        }
        finally {
            if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                context2.triggerReboot(true);
            }
        }
    }

    private File getUsedDestinationFile(Context context2) {
        return this.resolveRelativeFile(this.getDestinationFile(), this.getDestinationRoot(), context2);
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context2, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        File destinationFile = this.getUsedDestinationFile(context2);
        if (file.isDirectory()) {
            File parentDirectory = this.getCanonicalFileNoError(new File(destinationFile, relativeSourceFile.getPath()));
            fileInstaller.createDirectory(parentDirectory, this.getUninstallMode());
            long time = file.lastModified();
            if (time > 0L) {
                parentDirectory.setLastModified(time);
            }
            if (!InstallerUtil.isWindows()) {
                UnixFileSystem.setMode(this.getDirectoryMode(), parentDirectory);
            }
        } else {
            File destFile = this.toSingleFile ? destinationFile : this.getCanonicalFileNoError(new File(destinationFile, relativeSourceFile.getPath()));
            Util.logInfo(null, this.getActionName() + " " + file + " to " + destFile);
            if (this.isInOverriddenTargetDir(destFile)) {
                if (!FileUtil.copyFile(file, destFile, progressAdapter)) {
                    return false;
                }
                destFile.setLastModified(file.lastModified());
            } else if (!fileInstaller.install(file, destFile, new FileOptions(file.lastModified(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode()), progressAdapter)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isAddTopLevelDirectoriesToRelativePath() {
        return false;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    private File getCanonicalFileNoError(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    protected String getActionName() {
        return "Copy";
    }
}

