/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractZipFileAction
extends SystemInstallOrUninstallAction {
    private File zipFile;
    private ArchiveFileOperationRoot zipRoot = ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    private boolean showProgress = true;
    private String fileNameEncoding;

    public boolean isShowProgress() {
        return this.replaceWithTextOverride("showProgress", this.showProgress);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public File getZipFile() {
        return this.replaceWithTextOverride("zipFile", AbstractZipFileAction.replaceVariables(this.zipFile), File.class);
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public ArchiveFileOperationRoot getZipRoot() {
        return this.replaceWithTextOverride("zipRoot", this.zipRoot, ArchiveFileOperationRoot.class);
    }

    public void setZipRoot(ArchiveFileOperationRoot zipRoot) {
        this.zipRoot = zipRoot;
    }

    public String getFileNameEncoding() {
        return AbstractZipFileAction.replaceVariables(AbstractZipFileAction.replaceVariables(this.fileNameEncoding));
    }

    public void setFileNameEncoding(String fileNameEncoding) {
        this.fileNameEncoding = fileNameEncoding;
    }

    protected abstract File getTargetDirectory(Context var1);

    protected abstract boolean passesFileFilter(String var1, Context var2);

    protected void createFile(File destFile, InputStream zipIn, ZipEntry zipEntry, long currentSize, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        this.createDirectory(destFile.getParentFile());
        FileUtil.extractFile(zipIn, destFile, currentSize, progressAdapter, false);
    }

    protected void createDirectory(File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        File usedSourceFile = this.resolveRelativeFile(this.getZipFile(), this.getZipRoot(), context2);
        if (!usedSourceFile.exists()) {
            Logger.getInstance().error(this, usedSourceFile + " does not exist");
            return false;
        }
        try {
            return this.zipActions(context2, usedSourceFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.getInstance().error(this, "exception " + e);
            Logger.getInstance().log(e);
            return false;
        }
    }

    protected boolean zipActions(Context context2, File usedSourceFile) throws IOException, UserCanceledException {
        this.extractZip(context2, usedSourceFile, this.getTargetDirectory(context2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZip(Context context2, File sourceFile, File destDir) throws IOException, UserCanceledException {
        ProgressAdapter progressInterface = new ProgressAdapter(context2.getProgressInterface(), 0, this.getExtractionPercent());
        boolean showProgress = this.isShowProgress();
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        try (ZipFile zipFile = AbstractZipFileAction.openZipFile(sourceFile, this.getFileNameEncoding());){
            long maxProgress;
            if (showProgress) {
                progressInterface.setPercentCompleted(0);
                if (this.isShowFileNames()) {
                    progressInterface.setDetailMessage("");
                }
                maxProgress = this.getMaxProgress(zipFile, fileSizes);
            } else {
                maxProgress = Long.MAX_VALUE;
            }
            long currentProgress = 0L;
            int index2 = 0;
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry zipEntry = entries2.nextElement();
                if (context2.isCancelling()) {
                    throw new UserCanceledException();
                }
                String entryName = AbstractZipFileAction.getEntryName(zipEntry);
                if (!this.passesFileFilter(entryName, context2)) continue;
                if (showProgress && this.isShowFileNames()) {
                    progressInterface.setDetailMessage(InstallerUtil.cleanupName(entryName));
                }
                long nextProgress = currentProgress + 153600L;
                long currentSize = fileSizes.isEmpty() ? 0L : (Long)fileSizes.get(index2++);
                File destFile = this.getDestinationFile(destDir, entryName);
                this.saveInfo(destFile, zipEntry);
                if (zipEntry.isDirectory()) {
                    this.createDirectory(destFile);
                    destFile.setLastModified(zipEntry.getTime());
                    this.directoryCreated(destFile);
                } else {
                    nextProgress += currentSize;
                    ProgressAdapter progressAdapter = null;
                    if (showProgress) {
                        progressAdapter = new ProgressAdapter(progressInterface, (int)(currentProgress * 100L / maxProgress), (int)(nextProgress * 100L / maxProgress));
                    }
                    this.createFile(destFile, zipFile.getInputStream(zipEntry), zipEntry, currentSize, progressAdapter);
                    this.fileCreated(destFile);
                }
                if (context2.isCancelling()) {
                    throw new UserCanceledException();
                }
                currentProgress = nextProgress;
                if (!showProgress) continue;
                progressInterface.setPercentCompleted((int)(currentProgress * 100L / maxProgress));
            }
        }
        finally {
            if (showProgress) {
                progressInterface.setPercentCompleted(100);
                if (this.isShowFileNames()) {
                    progressInterface.setDetailMessage("");
                }
            }
        }
    }

    @NotNull
    private File getDestinationFile(File destDir, String entryName) {
        File destFile = new File(destDir, entryName);
        try {
            return destFile.getCanonicalFile();
        }
        catch (IOException ex) {
            return destFile;
        }
    }

    protected void saveInfo(File destFile, ZipEntry zipEntry) {
    }

    public boolean isShowFileNames() {
        return true;
    }

    protected int getExtractionPercent() {
        return 100;
    }

    protected void directoryCreated(File destFile) {
    }

    protected void fileCreated(File destFile) {
    }

    protected boolean matchesFileFilter(String entryName, Context context2, ScriptProperty fileFilter) {
        File entryFile = new File(entryName);
        return ContextImpl.runBooleanScript(context2, fileFilter, this, entryFile, entryName.endsWith(File.separator));
    }

    private static String getEntryName(ZipEntry zipEntry) {
        String zipName = zipEntry.getName();
        zipName = InstallerUtil.isWindows() ? zipName.replace('/', '\\') : zipName.replace('\\', '/');
        return zipName;
    }

    private long getMaxProgress(ZipFile zipFile, List<Long> fileSizes) throws IOException {
        long maxProgress = 0L;
        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry zipEntry = entries2.nextElement();
            long size2 = zipEntry.isDirectory() ? 0L : zipEntry.getSize();
            fileSizes.add(size2);
            maxProgress += size2 + 153600L;
        }
        return maxProgress;
    }

    private static ZipFile openZipFile(File file, String encoding) throws IOException {
        if (encoding != null && !encoding.isEmpty()) {
            try {
                return new ZipFile(file, Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException e) {
                Logger.getInstance().log(e);
                return new ZipFile(file);
            }
        }
        return new ZipFile(file);
    }
}

