/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public abstract class AbstractRecursiveFileAction
extends AbstractFileAction {
    private boolean recursive;
    private boolean showProgress = false;
    private boolean showFileNames = true;
    private transient long maxProgress;
    private transient long currentProgress;

    public boolean isRecursive() {
        return this.replaceWithTextOverride("recursive", this.recursive);
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isShowProgress() {
        return this.replaceWithTextOverride("showProgress", this.showProgress);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileNames() {
        return this.replaceWithTextOverride("showFileNames", this.showFileNames);
    }

    public void setShowFileNames(boolean showFileNames) {
        this.showFileNames = showFileNames;
    }

    protected abstract boolean executeForSingleRecursiveFile(Context var1, File var2, File var3, ProgressAdapter var4) throws UserCanceledException, IOException;

    protected boolean postProcessDirectory(Context context2, File file) throws UserCanceledException {
        return true;
    }

    protected boolean postProcessTopLevelFile(Context context2, File file) throws UserCanceledException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeForMultipleFilesAction(Context context2, File[] files) throws UserCanceledException {
        ProgressInterface progressInterface = context2.getProgressInterface();
        if (this.isShowProgress()) {
            this.currentProgress = 0L;
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage("");
            this.maxProgress = 0L;
            for (File file : files) {
                File usedFile = context2.getDestinationFile(file);
                if (!usedFile.exists()) continue;
                this.maxProgress += this.getMaxProgressForSingleFile(usedFile, context2);
            }
        }
        try {
            boolean bl = super.executeForMultipleFilesAction(context2, files);
            return bl;
        }
        finally {
            if (this.isShowProgress()) {
                progressInterface.setPercentCompleted(100);
                progressInterface.setDetailMessage("");
            }
        }
    }

    @Override
    protected final boolean executeForSingleFile(Context context2, File file) throws UserCanceledException, IOException {
        File relativeSourceFile = !file.isDirectory() || this.isAddTopLevelDirectoriesToRelativePath() ? new File(file.getName()) : new File(".");
        return this.executeForSingleFile(context2, file, relativeSourceFile) && this.postProcessTopLevelFile(context2, file);
    }

    protected boolean isAddTopLevelDirectoriesToRelativePath() {
        return true;
    }

    private boolean executeForSingleFile(Context context2, File file, File relativeSourceFile) throws UserCanceledException, IOException {
        if (this.passesFileOrDirectoryFilter(file, context2)) {
            ProgressInterface progressInterface = context2.getProgressInterface();
            ProgressAdapter progressAdapter = null;
            long thisProgress = 153600L + (file.isFile() ? file.length() : 0L);
            if (this.isShowProgress()) {
                if (this.isShowFileNames()) {
                    progressInterface.setDetailMessage(file.getName());
                }
                if (file.isFile()) {
                    progressAdapter = new ProgressAdapter(progressInterface, (int)(this.currentProgress * 100L / this.maxProgress), (int)((this.currentProgress + thisProgress) * 100L / this.maxProgress));
                }
            }
            if (!this.executeForSingleRecursiveFile(context2, file, relativeSourceFile, progressAdapter)) {
                return false;
            }
            this.currentProgress += thisProgress;
            if (this.isShowProgress()) {
                progressInterface.setPercentCompleted((int)(this.currentProgress * 100L / this.maxProgress));
            }
            if (file.isDirectory()) {
                if (this.isRecursive() && !this.recurse(context2, file, relativeSourceFile)) {
                    return false;
                }
                if (!this.postProcessDirectory(context2, file)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean recurse(Context context2, File file, File relativeSourceFile) throws IOException, UserCanceledException {
        File[] children2;
        boolean success2 = true;
        if (file.isDirectory() && this.followDir(file) && (children2 = file.listFiles()) != null) {
            for (File child2 : children2) {
                File relativeChildSourceFile;
                if (child2 == null || this.executeForSingleFile(context2, child2, relativeChildSourceFile = new File(relativeSourceFile, child2.getName()))) continue;
                success2 = false;
            }
        }
        return success2;
    }

    private boolean followDir(File usedFile) {
        return !Files.isSymbolicLink(usedFile.toPath());
    }

    private long getMaxProgressForSingleFile(File sourceFile, Context context2) {
        if (!this.passesFileOrDirectoryFilter(sourceFile, context2) || !sourceFile.exists()) {
            return 0L;
        }
        long ret = 153600L;
        if (sourceFile.isDirectory()) {
            File[] children2 = sourceFile.listFiles();
            if (children2 != null) {
                for (File child2 : children2) {
                    ret += this.getMaxProgressForSingleFile(child2, context2);
                }
            }
        } else {
            ret += sourceFile.length();
        }
        return ret;
    }
}

