/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.screens.components.ProgramGroupEntryConfig;
import com.install4j.runtime.beans.screens.components.ProgramGroupFileConfig;
import com.install4j.runtime.beans.screens.components.ProgramGroupUrlConfig;
import com.install4j.runtime.beans.screens.components.ProgramGroupWithIconConfig;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateProgramGroupAction
extends SystemInstallAction {
    private String programGroupName = "${installer:sys.programGroupName}";
    private boolean allUsers = true;
    private boolean addUninstaller = false;
    private String uninstallerMenuName = "";
    private boolean addDefaultLauncherLinks = true;
    private String linkDirectory = "${installer:sys.symlinkDir}";
    private String categories = "Application";
    private boolean unixSymlinks = true;
    private boolean failForSymlinksNotCreated = false;
    private boolean unixMenuEntries = true;
    private List<ProgramGroupEntryConfig> programGroupEntryConfigs = new ArrayList<ProgramGroupEntryConfig>();

    @Override
    public void init(Context context2) {
    }

    @Override
    public boolean install(InstallerContext context2) throws UserCanceledException {
        if (context2.getVariable("sys.programGroupName") == null) {
            context2.setVariable("sys.programGroupName", context2.getCompilerVariable("sys.fullName"));
        }
        if (context2.getVariable("sys.symlinkDir") == null) {
            context2.setVariable("sys.symlinkDir", "/usr/local/bin");
        }
        boolean success2 = true;
        try {
            if (InstallerUtil.isWindows()) {
                this.installWindows(context2);
            } else if (!InstallerUtil.isMacOS()) {
                success2 = this.installUnix(context2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return success2;
    }

    public boolean isAddUninstaller() {
        return this.replaceWithTextOverride("addUninstaller", this.addUninstaller);
    }

    public void setAddUninstaller(boolean addUninstaller) {
        this.addUninstaller = addUninstaller;
    }

    public String getUninstallerMenuName() {
        return CreateProgramGroupAction.replaceVariables(CreateProgramGroupAction.replaceVariables(this.uninstallerMenuName));
    }

    public void setUninstallerMenuName(String uninstallerMenuName) {
        this.uninstallerMenuName = uninstallerMenuName;
    }

    public boolean isAddDefaultLauncherLinks() {
        return this.replaceWithTextOverride("addDefaultLauncherLinks", this.addDefaultLauncherLinks);
    }

    public void setAddDefaultLauncherLinks(boolean addDefaultLauncherLinks) {
        this.addDefaultLauncherLinks = addDefaultLauncherLinks;
    }

    public String getCategories() {
        return CreateProgramGroupAction.replaceVariables(CreateProgramGroupAction.replaceVariables(this.categories));
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public String getProgramGroupName() {
        try {
            return CreateProgramGroupAction.replaceVariables(CreateProgramGroupAction.replaceVariables(this.programGroupName));
        }
        catch (UndefinedVariableException e) {
            return CreateProgramGroupAction.replaceVariables("");
        }
    }

    public void setProgramGroupName(String programGroupName) {
        this.programGroupName = programGroupName;
    }

    public boolean isAllUsers() {
        return this.replaceWithTextOverride("allUsers", this.allUsers);
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }

    public String getLinkDirectory() {
        try {
            return CreateProgramGroupAction.replaceVariables(CreateProgramGroupAction.replaceVariables(this.linkDirectory));
        }
        catch (UndefinedVariableException e) {
            return CreateProgramGroupAction.replaceVariables("");
        }
    }

    public void setLinkDirectory(String linkDirectory) {
        this.linkDirectory = linkDirectory;
    }

    public List<ProgramGroupEntryConfig> getProgramGroupEntryConfigs() {
        return this.replaceWithTextOverride("programGroupEntryConfigs", this.programGroupEntryConfigs, List.class);
    }

    public void setProgramGroupEntryConfigs(List<ProgramGroupEntryConfig> programGroupEntryConfigs) {
        this.programGroupEntryConfigs = programGroupEntryConfigs;
    }

    public boolean isUnixSymlinks() {
        return this.replaceWithTextOverride("unixSymlinks", this.unixSymlinks);
    }

    public void setUnixSymlinks(boolean unixSymlinks) {
        this.unixSymlinks = unixSymlinks;
    }

    public boolean isFailForSymlinksNotCreated() {
        return this.replaceWithTextOverride("failForSymlinksNotCreated", this.failForSymlinksNotCreated);
    }

    public void setFailForSymlinksNotCreated(boolean failForSymlinksNotCreated) {
        this.failForSymlinksNotCreated = failForSymlinksNotCreated;
    }

    public boolean isUnixMenuEntries() {
        return this.replaceWithTextOverride("unixMenuEntries", this.unixMenuEntries);
    }

    public void setUnixMenuEntries(boolean unixMenuEntries) {
        this.unixMenuEntries = unixMenuEntries;
    }

    private boolean installUnix(InstallerContext context2) throws IOException, UserCanceledException {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        boolean success2 = true;
        for (LauncherSetup launcherSetup : context2.getLaunchers()) {
            File linkDir;
            File destFile;
            if (launcherSetup.isUninstaller() || !(destFile = context2.getDestinationFile(launcherSetup.getRelativeFileName())).exists()) continue;
            boolean excludeFromMenu = launcherSetup.isExcludeFromMenu();
            if (this.isUnixMenuEntries() && !excludeFromMenu && (launcherSetup.getType() == LauncherType.GUI || launcherSetup.getType() == LauncherType.EXTERNAL)) {
                MenuHelper.installUnixMenu(context2.getInstallationDirectory(), destFile, ((ContextImpl.LauncherSetupImpl)launcherSetup).getMenuName(), this.getCategories(), null, null, null, MenuHelper.getAdditionalEntries(launcherSetup), true);
            }
            if (!this.isUnixSymlinks() || excludeFromMenu || this.getLinkDirectory() == null || this.getLinkDirectory().trim().length() <= 0 || Objects.equals(linkDir = new File(this.getLinkDirectory()).getCanonicalFile(), destFile.getParentFile().getCanonicalFile())) continue;
            fileInstaller.createDirectory(linkDir);
            File linkFile = new File(linkDir, destFile.getName());
            boolean created = UnixFileSystem.createLink(destFile.getAbsolutePath(), linkFile);
            if (this.isFailForSymlinksNotCreated() && !created) {
                success2 = false;
            }
            if (!created) continue;
            fileInstaller.registerUninstallFile(linkFile);
        }
        try {
            Runtime.getRuntime().exec("kbuildsycoca");
            MenuHelper.updateDesktopDatabase();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success2;
    }

    private void installWindows(InstallerContext context2) throws UserCanceledException, IOException {
        boolean allUsers = this.isAllUsers();
        Object varValue = InstallerVariables.getVariable("sys.programGroupAllUsers");
        if (varValue instanceof Boolean) {
            allUsers = (Boolean)varValue;
        }
        if (allUsers && !InstallerUtil.checkWritable(FolderInfo.getSpecialFolder(3, true))) {
            allUsers = false;
        }
        File groupDir = FolderInfo.getSpecialFolder(3, allUsers);
        if (this.getProgramGroupName().trim().length() > 0) {
            groupDir = new File(groupDir, this.getProgramGroupName());
        }
        ExecutionContext executionContext = allUsers ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED;
        for (LauncherSetup launcherSetup : context2.getLaunchers()) {
            File launcherFile;
            if (launcherSetup.isExcludeFromMenu() || launcherSetup.isUninstaller() && !this.isAddUninstaller() || !(launcherFile = context2.getDestinationFile(CreateProgramGroupAction.replaceVariables(launcherSetup.getRelativeFileName()))).exists()) continue;
            String menuName = launcherSetup.isUninstaller() ? this.getUninstallerMenuName() : ((ContextImpl.LauncherSetupImpl)launcherSetup).getMenuName();
            MenuHelper.installWindowsMenu(executionContext, new File(groupDir, menuName), launcherFile, null);
        }
        for (ProgramGroupEntryConfig programGroupEntryConfig : this.getProgramGroupEntryConfigs()) {
            ProgramGroupFileConfig programGroupFileConfig;
            File targetFile;
            if (!(programGroupEntryConfig instanceof ProgramGroupWithIconConfig)) continue;
            ProgramGroupWithIconConfig programGroupWithIconConfig = (ProgramGroupWithIconConfig)programGroupEntryConfig;
            File iconFile = context2.getExternalFile(programGroupWithIconConfig.getIconFile(), true);
            File menuFile = new File(groupDir, programGroupEntryConfig.getName());
            if (programGroupEntryConfig instanceof ProgramGroupUrlConfig) {
                ProgramGroupUrlConfig programGroupUrlConfig = (ProgramGroupUrlConfig)programGroupEntryConfig;
                String url = CreateProgramGroupAction.replaceVariables(programGroupUrlConfig.getUrl());
                if (!url.contains("://")) {
                    url = "http://" + url;
                }
                MenuHelper.installUrlLink(executionContext, url, menuFile, iconFile, programGroupUrlConfig.isFavicon());
                continue;
            }
            if (!(programGroupEntryConfig instanceof ProgramGroupFileConfig) || !(targetFile = context2.getDestinationFile(CreateProgramGroupAction.replaceVariables((programGroupFileConfig = (ProgramGroupFileConfig)programGroupEntryConfig).getTarget()))).exists()) continue;
            MenuHelper.installWindowsMenu(executionContext, menuFile, targetFile, iconFile, CreateProgramGroupAction.replaceVariables(programGroupFileConfig.getArguments()), programGroupFileConfig.isRunAsAdministrator(), null);
        }
    }
}

