/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.Util;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.InstallerContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;

public class AddToDockAction
extends SystemInstallAction
implements AutoUninstallAction {
    private Properties persistentProperties = new Properties();
    private File executable;
    private static final String PROPNAME_EXECUTABLE = "executable";
    private static final String PLIST_NAME = "com.apple.dock";
    private static final String ARRAY_NAME = "persistent-apps";
    private static final String TILE_DATA_KEY = "tile-data";
    private static final String FILE_DATA_KEY = "file-data";
    private static final String CF_URL_STRING_KEY = "_CFURLString";

    @Override
    public boolean install(InstallerContext context2) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            File destinationFile = context2.getDestinationFile(this.getExecutable());
            final String fileName = destinationFile.getAbsolutePath() + "/";
            AddToDockAction.doRollback(fileName);
            String fileUrl = AddToDockAction.getFileUrl(destinationFile);
            String label = destinationFile.getName();
            if (label.endsWith(".app")) {
                label = label.substring(0, label.length() - 4);
            }
            final Object[][] dict = new Object[][]{{TILE_DATA_KEY, "tile-type"}, {new Object[][]{{"dock-extra", FILE_DATA_KEY, "file-label"}, {Boolean.FALSE, new Object[][]{{CF_URL_STRING_KEY, "_CFURLStringType"}, {fileUrl, 15}}, label}}, "file-tile"}};
            final Properties persistentProperties = this.getPersistentProperties();
            if (Util.isMacosInstaller() && InstallerConfig.getCurrentInstance().getMacSpecificConfig().isSingleBundle()) {
                InstallerContextImpl.registerAfterFinishAction(() -> HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                    @Override
                    protected void run(Context context2) throws Exception {
                        AddToDockAction.addToPlist(fileName, dict, persistentProperties);
                    }
                }));
            } else if (!AddToDockAction.addToPlist(fileName, dict, persistentProperties)) {
                return false;
            }
        }
        return true;
    }

    private static boolean addToPlist(String fileName, Object[][] dict, Properties persistentProperties) {
        if (!PlistHelper.addToPlist(PLIST_NAME, ARRAY_NAME, dict)) {
            return false;
        }
        persistentProperties.setProperty(PROPNAME_EXECUTABLE, fileName);
        AddToDockAction.restartDock();
        return true;
    }

    private static String getFileUrl(File destinationFile) {
        String fileUrl = "";
        try {
            fileUrl = destinationFile.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            Logger.getImpl().log(e);
        }
        return fileUrl;
    }

    private static void restartDock() {
        try {
            Execution.executeAndWait(new String[]{"killall", "Dock"}, null);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
    }

    @Override
    public Properties getPersistentProperties() {
        return this.replaceWithTextOverride("persistentProperties", this.persistentProperties, Properties.class);
    }

    @Override
    public void setPersistentProperties(Properties properties2) {
        this.persistentProperties = properties2;
    }

    @Override
    public void rollback(InstallerContext context2) {
        if (InstallerUtil.isMacOS()) {
            AddToDockAction.doRollback(context2.getDestinationFile(this.getExecutable()).getAbsolutePath() + "/");
            AddToDockAction.restartDock();
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context2) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            AddToDockAction.doRollback(this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
            AddToDockAction.restartDock();
        }
        return true;
    }

    private static void doRollback(final String executable) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context2) throws Exception {
                if (executable != null) {
                    try {
                        String executableUrl = AddToDockAction.getFileUrl(new File(executable)).replaceAll("file:/*", "/");
                        if (PlistHelper.removeElementWithChild(AddToDockAction.PLIST_NAME, AddToDockAction.ARRAY_NAME, new String[]{AddToDockAction.TILE_DATA_KEY, AddToDockAction.FILE_DATA_KEY, AddToDockAction.CF_URL_STRING_KEY}, executableUrl, true) || PlistHelper.removeElementWithChild(AddToDockAction.PLIST_NAME, AddToDockAction.ARRAY_NAME, new String[]{AddToDockAction.TILE_DATA_KEY, AddToDockAction.FILE_DATA_KEY, AddToDockAction.CF_URL_STRING_KEY}, executable, true)) {
                            PlistHelper.flushCache();
                        } else {
                            Logger.getInstance().error(null, "removing not successful: " + executableUrl);
                        }
                    }
                    catch (IOException e) {
                        Logger.getInstance().log(e);
                    }
                }
            }
        });
    }

    public File getExecutable() {
        return this.replaceWithTextOverride(PROPNAME_EXECUTABLE, AddToDockAction.replaceVariables(this.executable), File.class);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }
}

