/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.control;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;

public class SetVariableAction
extends SystemInstallOrUninstallAction {
    private ScriptProperty script;
    private String variableName;
    private boolean onlyIfUndefined = false;
    private boolean failIfNull = false;
    private boolean responseFileVariable = false;

    public ScriptProperty getScript() {
        return this.replaceWithTextOverride("script", this.script, ScriptProperty.class);
    }

    public void setScript(ScriptProperty script) {
        this.script = script;
    }

    public String getVariableName() {
        return SetVariableAction.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isOnlyIfUndefined() {
        return this.replaceWithTextOverride("onlyIfUndefined", this.onlyIfUndefined);
    }

    public void setOnlyIfUndefined(boolean onlyIfUndefined) {
        this.onlyIfUndefined = onlyIfUndefined;
    }

    public boolean isFailIfNull() {
        return this.replaceWithTextOverride("failIfNull", this.failIfNull);
    }

    public void setFailIfNull(boolean failIfNull) {
        this.failIfNull = failIfNull;
    }

    public boolean isResponseFileVariable() {
        return this.replaceWithTextOverride("responseFileVariable", this.responseFileVariable);
    }

    public void setResponseFileVariable(boolean responseFileVariable) {
        this.responseFileVariable = responseFileVariable;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        try {
            String name = this.getVariableName();
            if (!this.isOnlyIfUndefined() || context2.getVariable(name) == null) {
                Object value = context2.runScript(this.getScript(), this, new Object[0]);
                if (value == null && this.isFailIfNull()) {
                    return false;
                }
                context2.setVariable(name, value);
                if (this.isResponseFileVariable()) {
                    context2.registerResponseFileVariable(name);
                }
            }
            return true;
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
            return false;
        }
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

