/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.AutoUninstallNotPerformedException;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.ContextIntProxy;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.content.JreInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UninstallFilesAction
extends SystemInstallOrUninstallAction {
    public static final String PROPNAME_PACKAGE_UNINSTALL = "install4j.packageUninstall";

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        File responseFile;
        boolean uninstallForUpgrade;
        if (!(context2 instanceof UninstallerContext) && !Boolean.getBoolean(PROPNAME_PACKAGE_UNINSTALL)) {
            Logger.getInstance().error(this, "UninstallFilesAction can only be used for uninstaller or for package pre-uninstallation.");
            return false;
        }
        ServiceHandler.stopServices(context2, false);
        String uninstallMessage = Messages.format(context2.getMessage(".StatusUninstalling"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        ProgressInterface progressInterface = context2.getProgressInterface();
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        if (!RunningProcessChecker.checkDefaultRunningLauncher()) {
            throw new UserCanceledException();
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        if (!UninstallFilesAction.executeAutoUninstallActions()) {
            return false;
        }
        boolean bl = uninstallForUpgrade = context2 instanceof UninstallerContext && ((UninstallerContext)context2).isUninstallForUpgrade();
        if (uninstallForUpgrade && (responseFile = context2.getDestinationFile(".install4j" + File.separator + "response.varfile")).isFile()) {
            FileInstaller.getInstance().addRetainedFile(responseFile);
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        InstallerConfig config2 = InstallerConfig.getCurrentInstance();
        UninstallFilesAction.preloadClasses();
        InstallRegistry.unregisterApplication(config2.getApplicationId(), context2.getInstallationDirectory());
        JreInstaller.getInstance().prepareUninstall(context2, uninstallForUpgrade);
        FileInstaller fileInstaller = FileInstaller.getInstance();
        try {
            for (String fileName : config2.getUninstallDeleteEntries()) {
                fileInstaller.deleteFile(context2.getDestinationFile(UninstallFilesAction.replaceVariables(fileName)));
            }
            fileInstaller.uninstall(uninstallForUpgrade, context2.getInstallationDirectory());
        }
        catch (IOException e) {
            context2.handleCriticalException(e);
        }
        if (!InstallerUtil.isWindows() && !InstallerUtil.isMacOS()) {
            try {
                Runtime.getRuntime().exec("kbuildsycoca");
                MenuHelper.updateDesktopDatabase();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (InstallerUtil.isMacOS()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static void preloadClasses() {
        try {
            Install4jClassLoader.getInstance().loadClass("com.install4j.script.I4jScript_Internal_0");
        }
        catch (Throwable e) {
            Logger.getInstance().log(e);
        }
        try {
            new SecureRandom();
        }
        catch (Throwable e) {
            Logger.getInstance().log(e);
        }
    }

    private static boolean executeAutoUninstallActions() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context2) throws Exception {
                try {
                    UninstallerContext uninstallerContext = context2 instanceof UninstallerContext ? (UninstallerContext)context2 : new UninstallerContextSham((ContextInt)context2);
                    if (!UninstallFilesAction.executeAutoUninstallActions(uninstallerContext)) {
                        return false;
                    }
                }
                catch (IOException e) {
                    Logger.getInstance().log(e);
                }
                return true;
            }
        });
    }

    private static boolean executeAutoUninstallActions(UninstallerContext context2, List<AutoUninstallAction> autoUninstallActions, List<AutoUninstallAction> retainedActions) {
        for (AutoUninstallAction autoUninstallAction : autoUninstallActions) {
            Logger.getInstance().info(autoUninstallAction, "executing auto uninstall");
            try {
                if (autoUninstallAction.uninstall(context2)) continue;
                Logger.getInstance().error(autoUninstallAction, "auto-uninstall action failed");
            }
            catch (AutoUninstallNotPerformedException e) {
                retainedActions.add(autoUninstallAction);
            }
            catch (UserCanceledException e) {
                return false;
            }
            catch (Throwable t) {
                Logger.getInstance().error(autoUninstallAction, "auto-uninstall action exception:");
                Logger.getInstance().log(t);
            }
        }
        return true;
    }

    private static boolean executeAutoUninstallActions(UninstallerContext context2) throws IOException {
        File runtimeDirectory = context2.getDestinationFile(".install4j");
        List<Integer> autoUninstallFileNumbers = AutoUninstallHandler.getAutoUninstallFileNumbers(runtimeDirectory);
        Collections.reverse(autoUninstallFileNumbers);
        for (int number : autoUninstallFileNumbers) {
            byte[] retainedBytes;
            ArrayList<AutoUninstallAction> retainedActions;
            File autoUninstallFile = new File(runtimeDirectory, "autoUninstall." + number);
            List<AutoUninstallAction> autoUninstallActions = AutoUninstallHandler.getAutoUninstallActionsFromFile(autoUninstallFile);
            if (!UninstallFilesAction.executeAutoUninstallActions(context2, autoUninstallActions, retainedActions = new ArrayList<AutoUninstallAction>())) {
                return false;
            }
            if (!context2.isUninstallForUpgrade() || (retainedBytes = AutoUninstallHandler.getPropertyFileBytes(retainedActions)) == null) continue;
            FileInstaller.getInstance().addRetainedFile(autoUninstallFile);
            try (FileOutputStream outputStream = new FileOutputStream(autoUninstallFile);){
                outputStream.write(retainedBytes);
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
        return true;
    }

    public static class UninstallerContextSham
    extends ContextIntProxy
    implements UninstallerContext {
        public UninstallerContextSham(ContextInt parentContext) {
            super(parentContext);
        }

        @Override
        public boolean isUninstallForUpgrade() {
            return false;
        }
    }
}

