/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.HtmlTextPane;
import com.install4j.runtime.util.StringUtil;
import com.install4j.runtime.util.ToolTipHelpLabel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextBinder {
    private final Map<String, WeakHashMap<Component, String>> variableRegistry = new HashMap<String, WeakHashMap<Component, String>>();

    public TextBinder() {
        Context context2 = ContextImpl.getCurrentContext();
        if (context2 != null) {
            context2.addInstallerEventListener(event -> {
                if (event.getType() == EventType.VARIABLE_CHANGED) {
                    String variableName = ((InstallerVariableEvent)event).getVariableName();
                    this.processBindings("installer:" + variableName);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String textWithVariables, Component componentWithText) {
        for (WeakHashMap<Component, String> componentToRawText : this.variableRegistry.values()) {
            componentToRawText.remove(componentWithText);
        }
        ArrayList<String> replacementRecording = new ArrayList<String>();
        this.setReplacementRecording(replacementRecording);
        try {
            String replacedText = this.replaceVariables(textWithVariables);
            for (String variableNameWithPrefix : replacementRecording) {
                WeakHashMap componentToRawText = this.variableRegistry.computeIfAbsent(variableNameWithPrefix, k -> new WeakHashMap());
                componentToRawText.put(componentWithText, textWithVariables);
            }
            this.setText(componentWithText, replacedText);
        }
        finally {
            this.setReplacementRecording(null);
        }
    }

    protected String replaceVariables(String text2) {
        return InstallerVariables.replaceVariables(text2, ReplacementMode.PLAIN, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    protected void setReplacementRecording(ArrayList<String> replacementRecording) {
        InstallerVariables.setReplacementRecording(replacementRecording);
    }

    protected void processBindings(String variableNameWithPrefix) {
        WeakHashMap<Component, String> componentToRawText = this.variableRegistry.get(variableNameWithPrefix);
        if (componentToRawText != null) {
            for (Map.Entry<Component, String> entry : componentToRawText.entrySet()) {
                Component component = entry.getKey();
                String replacedText = this.replaceVariables(entry.getValue());
                this.setText(component, replacedText);
            }
        }
    }

    private void setText(Component component, String replacedText) {
        this.setTextNormalized(component, StringUtil.rtrim(replacedText.replace("\r", "")));
    }

    private void setTextNormalized(Component component, String replacedText) {
        GUIHelper.invokeOnEDT(() -> this.setTextEDT(component, replacedText));
    }

    private void setTextEDT(Component component, String replacedText) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            String oldText = textComponent.getText();
            if (!oldText.isEmpty() && replacedText.startsWith(oldText)) {
                try {
                    Document document = textComponent.getDocument();
                    String appendedText = replacedText.substring(oldText.length());
                    document.insertString(document.getLength(), appendedText, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else if (component instanceof HtmlTextPane) {
                HtmlTextPane htmlTextPane = (HtmlTextPane)component;
                htmlTextPane.updateText(replacedText);
            } else {
                textComponent.setText(replacedText);
            }
        } else if (component instanceof ToolTipHelpLabel) {
            ((ToolTipHelpLabel)component).setToolTipText(replacedText);
        } else if (component instanceof JLabel) {
            String textWithoutMnemonics = AbstractFormComponent.getTextWithoutMnemonics(replacedText);
            JLabel label = (JLabel)component;
            label.setText(textWithoutMnemonics);
            int index2 = AbstractFormComponent.getMnemonicCharIndex(replacedText);
            if (index2 > -1) {
                label.setDisplayedMnemonic(textWithoutMnemonics.charAt(index2));
                label.setDisplayedMnemonicIndex(index2);
            }
        } else if (component instanceof JFrame) {
            ((JFrame)component).setTitle(replacedText);
        } else if (component instanceof JDialog) {
            ((JDialog)component).setTitle(replacedText);
        }
    }
}

