/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.runtime.beans.AbstractLightOrDarkColor;
import java.awt.Color;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightOrDarkColor
extends AbstractLightOrDarkColor {
    private Color lightColor;
    private Color darkColor;

    public LightOrDarkColor(@Nullable Color lightColor, @Nullable Color darkColor) {
        this.lightColor = LightOrDarkColor.nullToTransparent(lightColor);
        this.darkColor = LightOrDarkColor.nullToTransparent(darkColor);
    }

    @Override
    @NotNull
    public Color getLightColor() {
        return this.lightColor;
    }

    @Override
    @NotNull
    public Color getDarkColor() {
        return this.darkColor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightOrDarkColor that = (LightOrDarkColor)o;
        return this.lightColor.equals(that.lightColor) && this.darkColor.equals(that.darkColor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lightColor, this.darkColor);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append("{light ");
        LightOrDarkColor.appendColor(buffer, this.lightColor);
        buffer.append(", dark ");
        LightOrDarkColor.appendColor(buffer, this.darkColor);
        buffer.append("}");
        return buffer.toString();
    }

    private static void appendColor(StringBuilder buffer, Color color2) {
        if (color2.equals(TRANSPARENT)) {
            buffer.append("transparent");
        } else {
            buffer.append("[r=").append(color2.getRed()).append(",g=").append(color2.getGreen()).append(",b=").append(color2.getBlue()).append("]");
        }
    }
}

