/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.UiUtil;
import com.install4j.runtime.beans.LazyColor;
import java.awt.Color;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyUiManagerColor
extends LazyColor {
    private static Map<Color, Color> nonUiResourceColors = new WeakHashMap<Color, Color>();

    public LazyUiManagerColor(@NotNull String key) {
        this(key, false, null, null);
    }

    public LazyUiManagerColor(@NotNull String key, boolean nonUiResource) {
        this(key, nonUiResource, null, null);
    }

    public LazyUiManagerColor(@NotNull String key, @Nullable Color lightException, @Nullable Color darkException) {
        this(key, false, lightException, darkException);
    }

    public LazyUiManagerColor(@NotNull String key, boolean nonUiResource, @Nullable Color lightException, @Nullable Color darkException) {
        super(() -> {
            boolean dark = UiUtil.isDarkUi();
            if (dark && darkException != null) {
                return darkException;
            }
            if (!dark && lightException != null) {
                return lightException;
            }
            Color color2 = UIManager.getColor(key);
            if (color2 == null) {
                throw new RuntimeException("Color \"" + key + "\" not registered");
            }
            if (nonUiResource) {
                return nonUiResourceColors.computeIfAbsent(color2, c -> new Color(c.getRGB()));
            }
            return color2;
        });
    }
}

