/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AutoUninstallHandler {
    public static final String AUTO_UNINSTALL_FILE_PREFIX = "autoUninstall.";
    private static final String ELEMENT_ROOT = "autoUninstall";
    private static final String ELEMENT_ACTION = "action";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_CLASS_NAME = "className";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";

    public static byte[] getPropertyFileBytes(List<AutoUninstallAction> autoUninstallActions) throws IOException {
        if (autoUninstallActions.size() == 0) {
            return null;
        }
        Document document = XmlHelper.createDocument();
        Element root2 = document.createElement(ELEMENT_ROOT);
        document.appendChild(root2);
        for (AutoUninstallAction autoUninstallAction : autoUninstallActions) {
            Element child2 = document.createElement(ELEMENT_ACTION);
            child2.setAttribute(ATTRIBUTE_CLASS_NAME, autoUninstallAction.getClass().getName());
            Properties properties2 = autoUninstallAction.getPersistentProperties();
            for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
                Element propElement = document.createElement(ELEMENT_PROPERTY);
                propElement.setAttribute(ATTRIBUTE_NAME, (String)entry.getKey());
                propElement.setAttribute(ATTRIBUTE_VALUE, (String)entry.getValue());
                child2.appendChild(propElement);
            }
            root2.appendChild(child2);
        }
        return XmlHelper.getBytes(document);
    }

    public static void writeFile(byte[] bytes, File runtimeDirectory) throws IOException {
        if (bytes != null) {
            List<Integer> numbers = AutoUninstallHandler.getAutoUninstallFileNumbers(runtimeDirectory);
            int number = numbers.isEmpty() ? 1 : numbers.get(numbers.size() - 1) + 1;
            File autoUninstallFile = new File(runtimeDirectory, AUTO_UNINSTALL_FILE_PREFIX + number);
            FileOutputStream out = new FileOutputStream(autoUninstallFile);
            out.write(bytes);
            out.close();
            FileInstaller.getInstance().registerUninstallFile(autoUninstallFile);
        }
    }

    public static List<AutoUninstallAction> getAutoUninstallActionsFromFile(File autoUninstallFile) throws IOException {
        ArrayList<AutoUninstallAction> actions = new ArrayList<AutoUninstallAction>();
        Element root2 = XmlHelper.parseFile(autoUninstallFile).getDocumentElement();
        for (Element actionElement : XmlHelper.childElements(root2)) {
            AutoUninstallAction autoUninstallAction;
            block4: {
                autoUninstallAction = null;
                try {
                    autoUninstallAction = (AutoUninstallAction)Class.forName(actionElement.getAttribute(ATTRIBUTE_CLASS_NAME), true, Install4jClassLoader.getInstance()).newInstance();
                }
                catch (Throwable t) {
                    if (!Boolean.getBoolean("install4j.debugAutoUninstall")) break block4;
                    t.printStackTrace();
                }
            }
            if (autoUninstallAction == null) continue;
            Properties properties2 = new Properties();
            for (Element propertyElement : XmlHelper.childElements(actionElement)) {
                properties2.setProperty(propertyElement.getAttribute(ATTRIBUTE_NAME), propertyElement.getAttribute(ATTRIBUTE_VALUE));
            }
            autoUninstallAction.setPersistentProperties(properties2);
            actions.add(autoUninstallAction);
        }
        return actions;
    }

    public static List<Integer> getAutoUninstallFileNumbers(File runtimeDirectory) {
        ArrayList<Integer> autoUninstallFileNumbers = new ArrayList<Integer>();
        File[] files = runtimeDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith(AUTO_UNINSTALL_FILE_PREFIX)) continue;
                try {
                    int number = Integer.parseInt(name.substring(AUTO_UNINSTALL_FILE_PREFIX.length()));
                    autoUninstallFileNumbers.add(number);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(autoUninstallFileNumbers);
        return autoUninstallFileNumbers;
    }
}

