/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.alert;

import com.ejt.internal.CommonApplicationServices;
import com.install4j.api.Util;
import com.install4j.runtime.alert.AlertOptionPane;
import com.install4j.runtime.alert.AlertResult;
import com.install4j.runtime.alert.AlertType;
import com.install4j.runtime.alert.DefaultAlert;
import com.install4j.runtime.alert.MacosAlert;
import com.install4j.runtime.alert.SwingAlert;
import com.install4j.runtime.alert.WindowsAlert;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.macos.MacosUiHelper;
import com.install4j.runtime.util.I4jLibraryHelper;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class Alert<E> {
    private static final String PROPERTY_NO_NATIVE_DIALOGS_LEGACY = "ejt.noNativeDialogs";
    public static final Pattern NO_WRAP_PATTERN = Pattern.compile("[^\n ]{50,}");
    private static final Pattern WRAPPING_PATTERN = Pattern.compile("(?<![\n\t])\n(?!\n)");
    public static final String RAW_MODIFIER = "(?raw)";
    private Window parent;
    private String title;
    private String mainMessage;
    protected boolean mainMessageRedundant = true;
    private String contentMessage;
    private boolean rawMode;
    private List<E> buttons = new ArrayList();
    private E defaultButton;
    private E cancelButton;
    private AlertType alertType = AlertType.INFORMATION;
    private boolean suppressionShown;
    protected boolean useSecondaryLoop = true;

    public static <E> Alert<E> create(Component parent2, @Nls String title, @Nls String mainMessage, @Nls String contentMessage) {
        if (mainMessage == null) {
            throw new IllegalArgumentException("main message must not be null");
        }
        Alert alert = Alert.isNoNativeDialogs() ? new SwingAlert() : (Util.isMacOS() ? new MacosAlert() : (Util.isAtLeastWindowsVista() && Boolean.getBoolean("ejt.nativeWindowsAlert") && I4jLibraryHelper.isI4jLibraryAvailable() ? new WindowsAlert() : (Alert.isFrameworkParentWindow(parent2) && !Boolean.getBoolean("ejt.forceSwingAlert") ? new DefaultAlert() : new SwingAlert())));
        alert.parent(parent2).title(title).mainMessage(mainMessage).contentMessage(contentMessage);
        alert.messagesSet();
        return alert;
    }

    public static String replaceTabs(String text2) {
        if (text2 == null) {
            return null;
        }
        return text2.replaceAll("\t\n", "\n").replaceAll("\t", "\u00a0\u00a0\u00a0\u00a0");
    }

    public static boolean isNoNativeDialogs() {
        return Boolean.getBoolean("install4j.noNativeDialogs") || Boolean.getBoolean(PROPERTY_NO_NATIVE_DIALOGS_LEGACY);
    }

    public static void prepareNonEdtError() {
        if (!Alert.isNoNativeDialogs() && Util.isMacOS()) {
            MacosUiHelper.prepareNonEdtError();
        }
    }

    protected void messagesSet() {
    }

    public void initDependencies() {
        new InternalAlertResult(0, true);
        new AlertResult<Object>(new Object(), 0, true);
        AlertOptionPane.isDontShowAgain();
    }

    public static String conserveSingleLineBreaks(String contentMessage) {
        return contentMessage.replaceAll("\n", "\t\n");
    }

    private static boolean isFrameworkParentWindow(Component parent2) {
        CommonApplicationServices applicationServices = CommonApplicationServices.getInstance();
        if (applicationServices == null) {
            return true;
        }
        Window window = Alert.getWindow(parent2);
        return window == null || applicationServices.isFrameworkWindow(window);
    }

    protected static Window getWindow(Component parent2) {
        if (parent2 == null) {
            return null;
        }
        if (parent2 instanceof Window) {
            return (Window)parent2;
        }
        return SwingUtilities.getWindowAncestor(parent2);
    }

    protected abstract InternalAlertResult showInternal(List<String> var1, String var2, String var3);

    public AlertResult<E> show() {
        if (this.parent != null) {
            this.parent.toFront();
        }
        List<String> buttonTitles = this.getButtonsTitles();
        InternalAlertResult internalAlertResult = this.showInternal(buttonTitles, this.getDefaultButtonTitle(), this.getCancelButtonTitle());
        AlertOptionPane.disposeTempFrame(this.parent);
        int answer = internalAlertResult.answer;
        E selectedButton = answer >= 0 && answer < this.buttons.size() ? this.buttons.get(answer) : this.cancelButton;
        return new AlertResult<E>(selectedButton, answer, internalAlertResult.suppressionSelected);
    }

    public Window getParent() {
        return this.parent;
    }

    public Alert<E> parent(Component parent2) {
        this.parent = Alert.getWindow(parent2);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Alert<E> title(@Nls String title) {
        this.title = title;
        return this;
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    public Alert<E> mainMessage(@Nls String mainMessage) {
        this.mainMessage = this.maybeTransformMessageText(mainMessage);
        return this;
    }

    public boolean isMainMessageRedundant() {
        return this.mainMessageRedundant;
    }

    public Alert<E> mainMessageRedundant(boolean mainMessageRedundant) {
        this.mainMessageRedundant = mainMessageRedundant;
        return this;
    }

    public String getContentMessage() {
        return this.contentMessage;
    }

    public Alert<E> contentMessage(@Nls String contentMessage) {
        this.contentMessage = this.maybeTransformMessageText(contentMessage);
        return this;
    }

    public boolean isRawMode() {
        return this.rawMode;
    }

    public Alert<E> rawMode(boolean rawMode) {
        this.rawMode = rawMode;
        return this;
    }

    private String maybeTransformMessageText(String messageText) {
        if (this.rawMode) {
            return messageText;
        }
        if (messageText != null && messageText.startsWith(RAW_MODIFIER)) {
            this.rawMode = true;
            return messageText.substring(RAW_MODIFIER.length());
        }
        return this.transformMessageText(messageText);
    }

    public List<E> getButtons() {
        return this.buttons;
    }

    public Alert<E> buttons(List<E> buttons) {
        this.buttons = buttons;
        return this;
    }

    public Alert<E> addButton(E button) {
        this.buttons.add(button);
        return this;
    }

    public Alert<E> addButtons(E[] buttonArray) {
        this.buttons.addAll(Arrays.asList(buttonArray));
        return this;
    }

    public Alert<E> addEnumButtons(E enumValue) {
        this.addButtons(enumValue.getClass().getEnumConstants());
        return this;
    }

    public Alert<E> addDefaultButton(E button) {
        this.buttons.add(button);
        return this.defaultButton(button);
    }

    public Alert<E> addCancelButton(E button) {
        this.buttons.add(button);
        return this.cancelButton(button);
    }

    public E getDefaultButton() {
        return this.defaultButton;
    }

    public Alert<E> defaultButton(E defaultButton) {
        this.defaultButton = defaultButton;
        return this;
    }

    public E getCancelButton() {
        return this.cancelButton;
    }

    public Alert<E> cancelButton(E cancelButton) {
        this.cancelButton = cancelButton;
        return this;
    }

    public AlertType getAlertType() {
        return this.alertType;
    }

    public Alert<E> alertType(@NotNull AlertType alertType) {
        this.alertType = alertType;
        return this;
    }

    public boolean isSuppressionShown() {
        return this.suppressionShown;
    }

    public Alert<E> suppressionShown(boolean suppressionShown) {
        this.suppressionShown = suppressionShown;
        return this;
    }

    public Alert<E> useSecondaryLoop(boolean useSecondaryLoop) {
        this.useSecondaryLoop = useSecondaryLoop;
        return this;
    }

    private List<String> getButtonsTitles() {
        ArrayList<String> buttonTitles = new ArrayList<String>();
        for (E button : this.buttons) {
            buttonTitles.add(button.toString());
        }
        if (buttonTitles.isEmpty()) {
            buttonTitles.add(Messages.getString(".ButtonOK"));
        }
        return buttonTitles;
    }

    private String getDefaultButtonTitle() {
        if (this.defaultButton != null) {
            return this.defaultButton.toString();
        }
        return null;
    }

    private String getCancelButtonTitle() {
        if (this.cancelButton != null) {
            return this.cancelButton.toString();
        }
        return null;
    }

    protected String transformMessageText(String text2) {
        return this.removeHtml(text2);
    }

    protected String removeHtml(String text2) {
        if (text2 != null && text2.startsWith("<html>")) {
            text2 = text2.replace("<html>|<\\?b>", "");
            text2 = text2.replace("<br\\?>", "\n");
        }
        return text2;
    }

    protected String toWrappingText(String text2) {
        if (text2 == null) {
            return null;
        }
        return Alert.replaceTabs(WRAPPING_PATTERN.matcher(text2.replace("\r\n", "\n")).replaceAll(" "));
    }

    public static void main(String[] args2) {
        Alert.create(null, "Title", "Main message", "This is the content message").addButtons(new Object[]{"OK", "Cancel"}).suppressionShown(true).show();
    }

    protected static class InternalAlertResult {
        private int answer;
        private boolean suppressionSelected;

        public InternalAlertResult(int answer, boolean suppressionSelected) {
            this.answer = answer;
            this.suppressionSelected = suppressionSelected;
        }

        public int getAnswer() {
            return this.answer;
        }

        public boolean isSuppressionSelected() {
            return this.suppressionSelected;
        }
    }
}

