/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.Util;
import com.install4j.api.windows.WinProcesses;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class WindowInfo {
    private final long hwnd;
    private final int style;
    private final String className;
    private final String windowTitle;
    private static final int WS_MAXIMIZEBOX = 65536;

    private WindowInfo(long hwnd, int style, String className, String windowTitle) {
        this.hwnd = hwnd;
        this.style = style;
        this.className = className;
        this.windowTitle = windowTitle;
    }

    public static Collection<WindowInfo> getTopLevelWindows(long processId) {
        return Misc.getTopLevelWindows((int)processId);
    }

    public static boolean isTabletMode() {
        return Misc.isTabletMode();
    }

    public static boolean waitForMaximizableWindow(File executablePath, long timeout, TimeUnit unit) {
        if (!Util.isWindows()) {
            return false;
        }
        try {
            long timeoutNanos = unit.toNanos(timeout);
            long startTime = System.nanoTime();
            File canonicalPath = executablePath.getCanonicalFile();
            List<Integer> pids = WindowInfo.getPids(canonicalPath, startTime, timeoutNanos);
            if (pids.isEmpty()) {
                return false;
            }
            while (true) {
                for (Integer pid : pids) {
                    for (WindowInfo windowInfo : WindowInfo.getTopLevelWindows(pid.intValue())) {
                        if ((windowInfo.getStyle() & 0x10000) <= 0) continue;
                        return true;
                    }
                }
                if (WindowInfo.isTimeout(startTime, timeoutNanos)) {
                    return false;
                }
                LockSupport.parkNanos(100000000L);
            }
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    private static List<Integer> getPids(File canonicalPath, long startTime, long timeoutNanos) {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        while (true) {
            for (WinProcesses.Info info2 : WinProcesses.getRunningProcesses()) {
                try {
                    if (!new File(info2.getModuleName()).getCanonicalFile().equals(canonicalPath)) continue;
                    pids.add(info2.getProcessId());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!pids.isEmpty() || WindowInfo.isTimeout(startTime, timeoutNanos)) {
                return pids;
            }
            LockSupport.parkNanos(100000000L);
        }
    }

    private static boolean isTimeout(long startTime, long timeoutNanos) {
        return timeoutNanos > 0L && System.nanoTime() - startTime > timeoutNanos;
    }

    public long getHwnd() {
        return this.hwnd;
    }

    public int getStyle() {
        return this.style;
    }

    public String getClassName() {
        return this.className;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public String toString() {
        return "WindowInfo{hwnd=" + this.hwnd + ", style=0x" + Integer.toHexString(this.style) + ", className='" + this.className + '\'' + ", windowTitle='" + this.windowTitle + '\'' + '}';
    }
}

