/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.context.Context;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.Serializable;

public class WinRegistry {
    public static boolean keyExists(RegistryRoot root2, String keyName) {
        return WinRegistry.keyExists(root2, keyName, RegistryView.DEFAULT);
    }

    public static boolean createKey(RegistryRoot root2, String keyName) {
        return WinRegistry.createKey(root2, keyName, RegistryView.DEFAULT);
    }

    public static Object getValue(RegistryRoot root2, String keyName, String valueName) {
        return WinRegistry.getValue(root2, keyName, valueName, RegistryView.DEFAULT);
    }

    public static boolean setValue(RegistryRoot root2, String keyName, String valueName, Object value) {
        return WinRegistry.setValue(root2, keyName, valueName, value, RegistryView.DEFAULT);
    }

    public static void deleteValue(RegistryRoot root2, String keyName, String valueName) {
        WinRegistry.deleteValue(root2, keyName, valueName, RegistryView.DEFAULT);
    }

    public static void deleteKey(RegistryRoot root2, String keyName, boolean onlyIfEmpty) {
        WinRegistry.deleteKey(root2, keyName, onlyIfEmpty, RegistryView.DEFAULT);
    }

    public static String[] getSubKeyNames(RegistryRoot root2, String keyName) {
        return WinRegistry.getSubKeyNames(root2, keyName, RegistryView.DEFAULT);
    }

    public static String[] getValueNames(RegistryRoot root2, String keyName) {
        return WinRegistry.getValueNames(root2, keyName, RegistryView.DEFAULT);
    }

    public static boolean saveKey(RegistryRoot root2, String keyName, String fileName) {
        return WinRegistry.saveKey(root2, keyName, fileName, RegistryView.DEFAULT);
    }

    public static boolean restoreKey(RegistryRoot root2, String keyName, String fileName) {
        return WinRegistry.restoreKey(root2, keyName, fileName, RegistryView.DEFAULT);
    }

    public static boolean keyExists(final RegistryRoot root2, final String keyName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context2) throws Exception {
                    return WinRegistry.keyExists(root2, keyName, registryView);
                }
            });
        }
        return Registry.keyExists(root2.getType(), keyName, registryView.getUsedType());
    }

    public static boolean createKey(final RegistryRoot root2, final String keyName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context2) throws Exception {
                    return WinRegistry.createKey(root2, keyName, registryView);
                }
            });
        }
        return Registry.createKey(root2.getType(), keyName, registryView.getUsedType());
    }

    public static Object getValue(final RegistryRoot root2, final String keyName, final String valueName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<Object>(){

                @Override
                protected Object fetchValue(Context context2) throws Exception {
                    return WinRegistry.getValue(root2, keyName, valueName, registryView);
                }
            });
        }
        return Registry.getValue(root2.getType(), keyName, valueName, registryView.getUsedType());
    }

    public static boolean setValue(final RegistryRoot root2, final String keyName, final String valueName, final Object value, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context2) throws Exception {
                    return WinRegistry.setValue(root2, keyName, valueName, value, registryView);
                }
            });
        }
        Object usedValue = value instanceof ExpandString ? new Registry.ExpandStringImpl(((ExpandString)value).getValue()) : value;
        return Registry.setValue(root2.getType(), keyName, valueName, usedValue, registryView.getUsedType());
    }

    public static void deleteValue(final RegistryRoot root2, final String keyName, final String valueName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context2) throws Exception {
                    WinRegistry.deleteValue(root2, keyName, valueName, registryView);
                }
            });
        } else {
            Registry.deleteValue(root2.getType(), keyName, valueName, registryView.getUsedType());
        }
    }

    public static void deleteKey(final RegistryRoot root2, final String keyName, final boolean onlyIfEmpty, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context2) throws Exception {
                    WinRegistry.deleteKey(root2, keyName, onlyIfEmpty, registryView);
                }
            });
        } else {
            Registry.deleteKey(root2.getType(), keyName, onlyIfEmpty, registryView.getUsedType());
        }
    }

    public static String[] getSubKeyNames(final RegistryRoot root2, final String keyName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<String[]>(){

                @Override
                protected String[] fetchValue(Context context2) throws Exception {
                    return WinRegistry.getSubKeyNames(root2, keyName, registryView);
                }
            });
        }
        return Registry.enumSubKeys(root2.getType(), keyName, registryView.getUsedType());
    }

    public static String[] getValueNames(final RegistryRoot root2, final String keyName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<String[]>(){

                @Override
                protected String[] fetchValue(Context context2) throws Exception {
                    return WinRegistry.getValueNames(root2, keyName, registryView);
                }
            });
        }
        return Registry.enumValues(root2.getType(), keyName, registryView.getUsedType());
    }

    public static boolean saveKey(final RegistryRoot root2, final String keyName, final String fileName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context2) throws Exception {
                    return WinRegistry.saveKey(root2, keyName, fileName, registryView);
                }
            });
        }
        return Registry.saveKey(root2.getType(), keyName, fileName, registryView.getUsedType());
    }

    public static boolean restoreKey(final RegistryRoot root2, final String keyName, final String fileName, final RegistryView registryView) {
        if (WinRegistry.isUnelevate(root2)) {
            return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

                @Override
                protected boolean fetchValue(Context context2) throws Exception {
                    return WinRegistry.restoreKey(root2, keyName, fileName, registryView);
                }
            });
        }
        return Registry.restoreKey(root2.getType(), keyName, fileName, registryView.getUsedType());
    }

    private static boolean isUnelevate(RegistryRoot root2) {
        return HelperCommunication.getInstance().isElevatedHelper() && root2 == RegistryRoot.HKEY_CURRENT_USER;
    }

    private WinRegistry() {
    }

    public static class ExpandString
    implements Serializable {
        private String value;

        public ExpandString(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

