/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.runtime.installer.platform.win32.Win32Firewall;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WinFirewall {
    private WinFirewall() {
    }

    public static boolean addRule(Rule rule) throws AccessDeniedException, FirewallException {
        int profiles = Win32Firewall.getProfiles(rule.profileTypes, rule.onlyActiveProfiles, rule.avoidPublicProfile);
        return Win32Firewall.addRule(rule.executablePath, rule.ruleName, rule.groupName, rule.ruleDirection, rule.networkProtocol, rule.description, rule.localPorts, rule.localAddresses, rule.remotePorts, rule.remoteAddresses, profiles, rule.enabled);
    }

    public static int deleteRulesByExecutable(String executablePath) throws AccessDeniedException, FirewallException {
        return Win32Firewall.deleteRules(executablePath, null, null, null, null, null, null, null, null, null);
    }

    public static int deleteRulesByName(String ruleName) throws AccessDeniedException, FirewallException {
        return Win32Firewall.deleteRules(null, ruleName, null, null, null, null, null, null, null, null);
    }

    public static int deleteRulesByGroup(String groupName) throws AccessDeniedException, FirewallException {
        return Win32Firewall.deleteRules(null, null, groupName, null, null, null, null, null, null, null);
    }

    public static int deleteRules(Rule template) throws AccessDeniedException, FirewallException {
        return Win32Firewall.deleteRules(template.executablePath, template.ruleName, template.groupName, template.ruleDirection, template.networkProtocol, template.description, template.localPorts, template.localAddresses, template.remotePorts, template.remoteAddresses);
    }

    public static Set<ProfileType> getCurrentProfileTypes() throws AccessDeniedException, FirewallException {
        return Win32Firewall.translate(Win32Firewall.getCurrentProfileTypes());
    }

    public static class FirewallException
    extends Exception {
        public FirewallException(String message) {
            super(message);
        }
    }

    public static class AccessDeniedException
    extends Exception {
    }

    public static enum ProfileType {
        DOMAIN,
        PRIVATE,
        PUBLIC;

    }

    public static enum RuleDirection {
        INCOMING,
        OUTGOING;

    }

    public static enum NetworkProtocol {
        TCP,
        UDP;

    }

    public static class Rule {
        @NotNull
        private final String executablePath;
        @NotNull
        private final String ruleName;
        @NotNull
        private final RuleDirection ruleDirection;
        @NotNull
        private final NetworkProtocol networkProtocol;
        private String groupName;
        private String description;
        private String localPorts;
        private String localAddresses;
        private String remotePorts;
        private String remoteAddresses;
        private EnumSet<ProfileType> profileTypes = EnumSet.of(ProfileType.DOMAIN, ProfileType.PRIVATE);
        private boolean onlyActiveProfiles;
        private boolean avoidPublicProfile;
        private boolean enabled = true;

        public Rule(@NotNull String executablePath, @NotNull String ruleName, @NotNull RuleDirection ruleDirection, @NotNull NetworkProtocol networkProtocol) {
            this.executablePath = executablePath;
            this.ruleName = ruleName;
            this.ruleDirection = ruleDirection;
            this.networkProtocol = networkProtocol;
        }

        public Rule setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Rule setDescription(String description2) {
            this.description = description2;
            return this;
        }

        public Rule setLocalPorts(String localPorts) {
            this.localPorts = localPorts;
            return this;
        }

        public Rule setLocalAddresses(String localAddresses) {
            this.localAddresses = localAddresses;
            return this;
        }

        public Rule setRemotePorts(String remotePorts) {
            this.remotePorts = remotePorts;
            return this;
        }

        public Rule setRemoteAddresses(String remoteAddresses) {
            this.remoteAddresses = remoteAddresses;
            return this;
        }

        public Rule setProfileTypes(Collection<ProfileType> profileTypes) {
            this.profileTypes = profileTypes == null || profileTypes.isEmpty() ? EnumSet.noneOf(ProfileType.class) : EnumSet.copyOf(profileTypes);
            return this;
        }

        public Rule setOnlyActiveProfiles(boolean onlyActiveProfiles) {
            this.onlyActiveProfiles = onlyActiveProfiles;
            return this;
        }

        public Rule setAvoidPublicProfile(boolean avoidPublicProfile) {
            this.avoidPublicProfile = avoidPublicProfile;
            return this;
        }

        public Rule setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }
    }
}

