/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.events;

import com.install4j.api.context.Context;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import java.io.File;

public class InstallerFileEvent
extends InstallerEvent {
    private File destinationFile;
    private long fileSize;

    public InstallerFileEvent(Object source, Context context2, EventType type2, boolean success2, File destinationFile, long fileSize) {
        super(source, context2, type2, success2);
        this.destinationFile = destinationFile;
        this.fileSize = fileSize;
    }

    public InstallerFileEvent(Object source, Context context2, EventType type2, File destinationFile, long fileSize) {
        super(source, context2, type2);
        this.destinationFile = destinationFile;
        this.fileSize = fileSize;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public String toString() {
        return super.toString() + " [file " + this.destinationFile + ", size " + this.fileSize + "]";
    }

    @Override
    public String getVerbose() {
        String ret = super.getVerbose() + ": " + this.destinationFile;
        if (this.getType() == EventType.BEFORE_INSTALL_FILE) {
            ret = ret + "; size: " + this.fileSize + " bytes; exists: " + this.destinationFile.exists();
        }
        return ret;
    }
}

