/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.events;

import com.install4j.api.context.Context;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;

public class InstallerDownloadEvent
extends InstallerEvent {
    private URL url;
    private File downloadFile;
    private long downloadSize;
    private Set<DownloadProgressListener> downloadProgressListeners = new LinkedHashSet<DownloadProgressListener>();

    public InstallerDownloadEvent(Object source, Context context2, EventType type2, boolean success2, URL url, File downloadFile, long downloadSize) {
        super(source, context2, type2, success2);
        this.init(url, downloadFile, downloadSize);
    }

    public InstallerDownloadEvent(Object source, Context context2, EventType type2, URL url, File downloadFile, long downloadSize) {
        super(source, context2, type2);
        this.init(url, downloadFile, downloadSize);
    }

    private void init(URL url, File destinationFile, long downloadSize) {
        this.url = url;
        this.downloadFile = destinationFile;
        this.downloadSize = downloadSize;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getDownloadFile() {
        return this.downloadFile;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public void addDownloadProgressListener(DownloadProgressListener listener) {
        this.downloadProgressListeners.add(listener);
    }

    public Set<DownloadProgressListener> getDownloadProgressListeners() {
        return this.downloadProgressListeners;
    }

    @Override
    public String toString() {
        return super.toString() + " [url " + this.url + ", file " + this.downloadFile + ", size " + this.downloadSize + "]";
    }

    @Override
    public String getVerbose() {
        String ret = super.getVerbose() + ": " + this.url + " to " + this.downloadFile;
        if (this.getType() == EventType.BEFORE_DOWNLOAD) {
            ret = ret + "; size: " + this.downloadSize + " bytes";
        }
        return ret;
    }

    public static interface DownloadProgressListener {
        public void downloadCompleted(long var1);
    }
}

