/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.context;

import com.install4j.api.beans.Anchor;
import java.awt.Color;
import java.io.File;

public class WizardIndex {
    private String[] stepNames;
    private String[] keys;
    private boolean partiallyDefined;
    private int maxWidth = 300;
    private int minWidth = 120;
    private boolean numbered = true;
    private Color background;
    private Color foreground;
    private File backgroundImage;
    private Anchor backgroundImageAnchor = Anchor.SOUTHWEST;
    private String initialKey;

    public WizardIndex(String[] stepNames) {
        this(stepNames, null);
    }

    public WizardIndex(String[] stepNames, String[] keys2) {
        if (stepNames == null || stepNames.length == 0) {
            throw new IllegalArgumentException("step names must have a length > 0");
        }
        this.stepNames = stepNames;
        if (keys2 == null) {
            keys2 = this.createKeys(stepNames);
        }
        if (keys2.length != stepNames.length) {
            throw new IllegalArgumentException("step names and keys must have the same lengths");
        }
        this.keys = keys2;
    }

    public String[] getStepNames() {
        return this.stepNames;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public boolean isPartiallyDefined() {
        return this.partiallyDefined;
    }

    public WizardIndex partiallyDefined(boolean partiallyDefined) {
        this.partiallyDefined = partiallyDefined;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public WizardIndex maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public WizardIndex minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public WizardIndex numbered(boolean numbered) {
        this.numbered = numbered;
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public WizardIndex background(Color background2) {
        this.background = background2;
        return this;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public WizardIndex foreground(Color foreground) {
        this.foreground = foreground;
        return this;
    }

    public File getBackgroundImage() {
        return this.backgroundImage;
    }

    public WizardIndex backgroundImage(File backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public Anchor getBackgroundImageAnchor() {
        return this.backgroundImageAnchor;
    }

    public WizardIndex backgroundImageAnchor(Anchor anchor) {
        this.backgroundImageAnchor = anchor;
        return this;
    }

    public String getInitialKey() {
        return this.initialKey == null ? this.keys[0] : this.initialKey;
    }

    public WizardIndex initialKey(String initialKey) {
        this.initialKey = initialKey;
        return this;
    }

    private String[] createKeys(String[] stepNames) {
        String[] keys2 = new String[stepNames.length];
        for (int i = 0; i < stepNames.length; ++i) {
            keys2[i] = String.valueOf(i + 1);
        }
        return keys2;
    }
}

