/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import com.install4j.api.UiUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.LoggerImpl;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchIntAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.platform.UserInfo;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.Nls;

public class Util {
    public static String getUserHome() {
        String userHome = InstallerVariables.getStringVariable("sys.userHome");
        if (userHome == null) {
            return System.getProperty("user.home");
        }
        return userHome;
    }

    public static boolean isSolaris() {
        return InstallerUtil.isSolaris();
    }

    public static boolean isLinux() {
        return InstallerUtil.isLinux();
    }

    public static boolean isWindows() {
        return InstallerUtil.isWindows();
    }

    @Deprecated
    public static boolean isWindows9X() {
        return false;
    }

    @Deprecated
    public static boolean isWindowsNT() {
        return InstallerUtil.isWindowsNT();
    }

    public static boolean isAtLeastWindowsVista() {
        return InstallerUtil.isAtLeastWindowsVista();
    }

    public static boolean isAtLeastWindows7() {
        return InstallerUtil.isAtLeastWindows7();
    }

    @Deprecated
    public static boolean isAtLeastWindowsXP() {
        return Util.isWindows();
    }

    public static boolean isWindowsVista() {
        return InstallerUtil.isWindowsVista();
    }

    public static boolean isWindows7() {
        return InstallerUtil.isWindows7();
    }

    public static boolean isWindows8() {
        return InstallerUtil.isWindows8();
    }

    public static boolean isWindows10() {
        return InstallerUtil.isWindows10();
    }

    public static boolean isAtLeastWindows10() {
        return InstallerUtil.isAtLeastWindows10();
    }

    public static boolean isWindowsXP() {
        return InstallerUtil.isWindowsXP();
    }

    public static boolean isWindows2000() {
        return InstallerUtil.isWindows2000();
    }

    public static boolean isWindows2003() {
        return InstallerUtil.isWindows2003();
    }

    public static boolean isWindows2008() {
        return InstallerUtil.isWindows2008();
    }

    public static boolean isWindows2012() {
        return InstallerUtil.isWindows2012();
    }

    public static boolean isWindows2016() {
        return InstallerUtil.isWindows2016();
    }

    public static boolean is64BitWindows() {
        return Util.isWindows() && (!InstallerUtil.is32BitJVM() || InstallerUtil.is64BitWindows());
    }

    public static boolean isMacOS() {
        return InstallerUtil.isMacOS();
    }

    public static boolean isHpux() {
        return InstallerUtil.isHpux();
    }

    public static boolean isAix() {
        return InstallerUtil.isAix();
    }

    public static boolean isWindowsInstaller() {
        return Objects.equals(InstallerUtil.getInstallerType(), "windows");
    }

    public static boolean isUnixInstaller() {
        return Objects.equals(InstallerUtil.getInstallerType(), "unix");
    }

    public static boolean isMacosInstaller() {
        return Objects.equals(InstallerUtil.getInstallerType(), "macos");
    }

    public static String getStandardApplicationsDirectory() {
        return InstallerUtil.getStandardApplicationsDirectory(false);
    }

    public static boolean isArchive() {
        return InstallerUtil.isArchive();
    }

    public static void showUrl(final URL url) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context2) {
                GUIHelper.showURL(url.toExternalForm());
            }
        });
    }

    public static void showMessage(final @Nls String message, final int messageType) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context2) {
                GUIHelper.showMessage(null, message, messageType);
            }
        });
    }

    public static void showMessage(@Nls String message) {
        Util.showMessage(message, 1);
    }

    public static void showErrorMessage(@Nls String message) {
        Util.showMessage(message, 0);
    }

    public static void showWarningMessage(@Nls String message) {
        Util.showMessage(message, 2);
    }

    public static int showOptionDialog(final @Nls String message, final @Nls String[] options, final int messageType) throws UserCanceledException {
        try {
            return HelperCommunication.getInstance().fetchIntChecked(ExecutionContext.UNELEVATED, new FetchIntAction(){

                @Override
                protected int fetchValue(Context context2) throws UserCanceledException {
                    return GUIHelper.showOptionDialog(null, message, null, options, messageType);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fatalError(final Throwable t) {
        try {
            HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context2) throws Exception {
                    InstallerUtil.reportException(t);
                    InstallerUtil.exit(1);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Deprecated
    public static Window getParentWindow() {
        return UiUtil.getParentWindow();
    }

    public static void logInfo(Object source, String message) {
        Logger.getInstance().info(source, message);
    }

    public static void logError(Object source, String message) {
        Logger.getInstance().error(source, message);
    }

    public static void log(Throwable t) {
        Logger.getInstance().log(t);
    }

    public static void dumpVariables(Context context2) {
        System.err.println();
        System.err.println("Defined installer variables:");
        System.err.println("----------------------------");
        for (String variableName : context2.getVariableNames()) {
            Object value = context2.getVariable(variableName);
            System.err.println(InstallerUtil.getVerboseVariableDefinition(variableName, value));
        }
        System.err.println("----------------------------");
        System.err.println();
    }

    @Deprecated
    public static boolean isAdminUser() {
        return UserInfo.isAdminUser();
    }

    public static boolean isAdminGroup() {
        return UserInfo.isAdminGroup();
    }

    public static boolean hasFullAdminRights() {
        return UserInfo.hasFullAdminRights();
    }

    public static String getAnnotatedStackTrace(Throwable t) {
        return InstallerUtil.getAnnotatedStackTrace(t);
    }

    public static void printAnnotatedStackTrace(Throwable t) {
        System.err.print(Util.getAnnotatedStackTrace(t));
    }

    public static void showPath(final String path) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context2) {
                GUIHelper.showPath(path);
            }
        });
    }

    public static boolean isDirectoryWritable(final File directory) {
        return HelperCommunication.getInstance().fetchBoolean(ContentInstaller.getExecutionContext(), new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context2) throws UserCanceledException {
                return InstallerUtil.checkWritable(directory);
            }
        });
    }

    public static File getLogFile() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<File>(){

            @Override
            protected File fetchValue(Context context2) {
                return ((LoggerImpl)LoggerImpl.getInstance()).getLogFile();
            }
        });
    }

    public static void moveLogFile(final File newLogFile) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context2) throws Exception {
                ((LoggerImpl)LoggerImpl.getInstance()).moveLogFile(newLogFile, true);
            }
        });
    }

    public static void loadNativeFromResources(String fileName) {
        String absoluteFileName = InstallerVariables.getStringVariable("sys.resourceDir") + File.separator + fileName;
        try {
            Install4jClassLoader.invokeInCustomClassLoader(System.class.getMethod("load", String.class), null, absoluteFileName);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

