/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class SerializableEnum
implements Serializable {
    private static Map<Identifier, Object> identifierToInstance = Collections.synchronizedMap(new HashMap());
    private static Map<String, MutableInt> classNameToLastId = Collections.synchronizedMap(new HashMap());
    private int id;

    protected SerializableEnum() {
        String className = this.getClass().getName();
        MutableInt mutableInt = classNameToLastId.get(className);
        if (mutableInt == null) {
            mutableInt = new MutableInt();
            classNameToLastId.put(className, mutableInt);
        }
        this.id = ++mutableInt.val;
        identifierToInstance.put(new Identifier(className, this.id), this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.id);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
    }

    protected Object readResolve() throws ObjectStreamException {
        Object singleInstance = identifierToInstance.get(new Identifier(this.getClass().getName(), this.id));
        if (singleInstance == null) {
            throw new InvalidObjectException("unknown id " + this.id + " for class " + this.getClass().getName());
        }
        return singleInstance;
    }

    private static class MutableInt {
        int val;

        private MutableInt() {
        }
    }

    private static class Identifier {
        private String className;
        private int id;

        private Identifier(String className, int id) {
            this.className = className;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            if (this.id != that.id) {
                return false;
            }
            return Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            int result2 = this.className.hashCode();
            result2 = 31 * result2 + this.id;
            return result2;
        }
    }
}

