/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.splash;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.util.ArgumentStack;
import java.util.StringTokenizer;

public class TextLineConfig {
    private String text;
    private int fontSize;
    private int fontWeight;
    private int fontColorR;
    private int fontColorG;
    private int fontColorB;
    private int positionX;
    private int positionY;

    TextLineConfig(ArgumentStack argStack) {
        this.text = argStack.popString();
        this.positionX = argStack.popInt();
        this.positionY = argStack.popInt();
        argStack.popString();
        this.parseColor(argStack.popString());
        this.fontSize = argStack.popInt();
        this.fontWeight = argStack.popInt();
    }

    public TextLineConfig(int base) {
        this.text = LauncherEngine.getProperty(base + 2);
        this.positionX = LauncherEngine.getIntProperty(base + 0);
        this.positionY = LauncherEngine.getIntProperty(base + 1);
        this.parseColor(LauncherEngine.getProperty(base + 5));
        this.fontSize = LauncherEngine.getIntProperty(base + 4);
        this.fontWeight = LauncherEngine.getIntProperty(base + 6);
    }

    public TextLineConfig(String text2, int positionX, int positionY, String color2, int fontSize, int fontWeight) {
        this.text = text2;
        this.positionX = positionX;
        this.positionY = positionY;
        this.parseColor(color2);
        this.fontSize = fontSize;
        this.fontWeight = fontWeight;
    }

    public int getFontColorR() {
        return this.fontColorR;
    }

    public int getFontColorG() {
        return this.fontColorG;
    }

    public int getFontColorB() {
        return this.fontColorB;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public String getText() {
        return this.text;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    private void parseColor(String color2) {
        if (color2 != null) {
            StringTokenizer colorTokenizer = new StringTokenizer(color2, ",");
            this.fontColorR = Integer.parseInt(colorTokenizer.nextToken());
            this.fontColorG = Integer.parseInt(colorTokenizer.nextToken());
            this.fontColorB = Integer.parseInt(colorTokenizer.nextToken());
        }
    }
}

