/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.util;

import java.io.File;
import org.jetbrains.annotations.NotNull;

public class LoadingDescriptor {
    public static final String URL_FILE_PREFIX = "file:";
    public static final String URL_JAR_PREFIX = "jar:file:";
    private File baseDir;
    private File classpathDir;
    private boolean loadedFromJAR;

    @NotNull
    public static LoadingDescriptor getInstance(Class clazz) {
        String classPathName;
        boolean loadedFromJAR;
        String className = clazz.getName().replace('.', '/') + ".class";
        String simpleName2 = className.substring(className.lastIndexOf(47) + 1);
        String classLocation = clazz.getResource(simpleName2).toString();
        String baseName = classLocation.substring(0, classLocation.lastIndexOf(className) - 1);
        if ((baseName = LoadingDescriptor.decodePath(baseName)).startsWith(URL_JAR_PREFIX)) {
            loadedFromJAR = true;
            classPathName = baseName.substring(URL_JAR_PREFIX.length(), baseName.length() - 1);
            int lastIndex = baseName.lastIndexOf(47);
            if (lastIndex == -1) {
                lastIndex = baseName.lastIndexOf(92);
            }
            if (lastIndex == -1) {
                throw new RuntimeException("Base URL " + baseName + " is invalid");
            }
            baseName = baseName.substring(URL_JAR_PREFIX.length(), lastIndex);
        } else if (baseName.startsWith(URL_FILE_PREFIX)) {
            loadedFromJAR = false;
            classPathName = baseName = baseName.substring(URL_FILE_PREFIX.length());
        } else {
            throw new RuntimeException("Base URL " + baseName + " is invalid");
        }
        return new LoadingDescriptor(new File(baseName), new File(classPathName), loadedFromJAR);
    }

    public static File getJarParentDir(Class clazz) {
        String className = clazz.getName().replace('.', '/') + ".class";
        String simpleName2 = className.substring(className.lastIndexOf(47) + 1);
        String classLocation = clazz.getResource(simpleName2).toString();
        String baseName = classLocation.substring(0, classLocation.lastIndexOf(className) - 1);
        if (baseName.startsWith(URL_JAR_PREFIX)) {
            int lastIndex = baseName.lastIndexOf(47);
            if (lastIndex == -1) {
                lastIndex = baseName.lastIndexOf(92);
            }
            if (lastIndex == -1) {
                throw new RuntimeException("Base URL " + baseName + " is invalid");
            }
            baseName = baseName.substring(URL_JAR_PREFIX.length(), lastIndex);
            return new File(baseName);
        }
        throw new RuntimeException("Base URL " + baseName + " is invalid");
    }

    public static String decodePath(String path) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c != '%') {
                ++i;
            } else {
                try {
                    c = LoadingDescriptor.unescape(path, i);
                    i += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c1 = LoadingDescriptor.unescape(path, i);
                                i += 3;
                                c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = LoadingDescriptor.unescape(path, i);
                                char c3 = LoadingDescriptor.unescape(path, i += 3);
                                i += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException();
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    private LoadingDescriptor(File baseDir, File classpathDir, boolean loadedFromJAR) {
        this.baseDir = baseDir;
        this.classpathDir = classpathDir;
        this.loadedFromJAR = loadedFromJAR;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public boolean isLoadedFromJAR() {
        return this.loadedFromJAR;
    }

    public String toString() {
        return "base dir: " + this.baseDir + ", class path dir: " + this.classpathDir + ", loadedFromJar: " + this.loadedFromJAR;
    }
}

