/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.io;

import com.ejt.internal.io.CommonFileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class StreamConsumerThread
extends Thread {
    private InputStream stream;
    private StringBuffer buffer;
    private boolean utf8;

    public static void consumeOutput(Process process2, StringBuffer outputBuffer, boolean utf8) {
        StreamConsumerThread.consumeOutput(process2, outputBuffer, outputBuffer, utf8);
    }

    public static void consumeOutput(Process process2, StringBuffer outputBuffer, StringBuffer errorBuffer, boolean utf8) {
        if (process2 != null) {
            StreamConsumerThread inputThread = new StreamConsumerThread(process2.getInputStream(), outputBuffer, utf8);
            inputThread.start();
            StreamConsumerThread errorThread = new StreamConsumerThread(process2.getErrorStream(), errorBuffer, utf8);
            errorThread.start();
            if (outputBuffer != null) {
                try {
                    inputThread.join();
                    errorThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void consumeOutput(Process process2) {
        StreamConsumerThread.consumeOutput(process2, null, false);
    }

    public StreamConsumerThread(InputStream stream, StringBuffer buffer, boolean utf8) {
        this.stream = stream;
        this.buffer = buffer;
        this.utf8 = utf8;
    }

    @Override
    public void run() {
        try {
            StringWriter writer = null;
            if (this.buffer != null) {
                writer = new StringWriter(this.buffer);
            }
            InputStreamReader reader = this.utf8 ? new InputStreamReader(this.stream, "UTF-8") : new InputStreamReader(this.stream);
            CommonFileUtil.pumpCharStream(reader, writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class StringWriter
    extends Writer {
        private StringBuffer buf;

        public StringWriter(StringBuffer buffer) {
            this.buf = buffer;
            this.lock = this.buf;
        }

        @Override
        public void write(int c) {
            this.buf.append((char)c);
        }

        @Override
        public void write(@NotNull char[] buffer, int off, int len) {
            if (off < 0 || off > buffer.length || len < 0 || off + len > buffer.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.buf.append(buffer, off, len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

