/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.gui;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

public class ScreenSizeUtil {
    private static final boolean DEBUG_SCREEN_SIZE = Boolean.getBoolean("ejt.debugScreenSize");
    private static GraphicsDevice overrideGraphicsDevice;

    private ScreenSizeUtil() {
    }

    @NotNull
    public static Rectangle getFrameBounds(Dimension size2, Window parentWindow) {
        return ScreenSizeUtil.getFrameBounds(size2.width, size2.height, parentWindow);
    }

    @NotNull
    public static Rectangle getFrameBounds(int width2, int height2, Window parentWindow) {
        Rectangle bounds2 = parentWindow != null && parentWindow.isVisible() ? parentWindow.getBounds() : new Rectangle(ScreenSizeUtil.getScreenDevice().getDefaultConfiguration().getBounds());
        int deltaX = bounds2.width - width2;
        int deltaY = bounds2.height - height2;
        bounds2.x += deltaX / 2;
        bounds2.width -= deltaX;
        bounds2.y += deltaY / 2;
        bounds2.height -= deltaY;
        ScreenSizeUtil.adjustBoundsToScreenSize(bounds2);
        return bounds2;
    }

    public static void adjustBoundsToScreenSize(Rectangle bounds2) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration = ScreenSizeUtil.getGraphicsConfiguration(bounds2);
        Rectangle screenBounds = ScreenSizeUtil.getScreenBoundsWithInsets(graphicsConfiguration);
        if (DEBUG_SCREEN_SIZE) {
            System.err.println("original bounds = " + bounds2);
            System.err.println("screen bounds for original bounds = " + screenBounds);
        }
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (bounds2.x < screenBounds.x) {
            bounds2.translate(screenBounds.x - bounds2.x, 0);
        }
        if (bounds2.y < screenBounds.y) {
            bounds2.translate(0, screenBounds.y - bounds2.y);
        }
        if (bounds2.x + bounds2.width > screenBounds.x + screenBounds.width) {
            bounds2.translate(screenBounds.x + screenBounds.width - (bounds2.x + bounds2.width), 0);
        }
        if (bounds2.y + bounds2.height > screenBounds.y + screenBounds.height) {
            bounds2.translate(0, screenBounds.y + screenBounds.height - (bounds2.y + bounds2.height));
        }
        if (bounds2.x < screenBounds.x) {
            bounds2.x = screenBounds.x;
            bounds2.width = screenBounds.width;
        }
        if (bounds2.y < screenBounds.y) {
            bounds2.y = screenBounds.y;
            bounds2.height = screenBounds.height;
        }
        if (DEBUG_SCREEN_SIZE) {
            System.err.println("corrected bounds = " + bounds2);
        }
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Rectangle bounds2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        GraphicsConfiguration maxAreaConfiguration = null;
        int maxArea = 0;
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            GraphicsConfiguration[] graphicsConfigurations;
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurations = graphicsDevice.getConfigurations()) {
                Rectangle graphicsConfigurationBounds = graphicsConfiguration.getBounds();
                if (graphicsConfigurationBounds.contains(bounds2.getLocation())) {
                    return graphicsConfiguration;
                }
                Rectangle intersection = graphicsConfigurationBounds.intersects(bounds2) ? graphicsConfigurationBounds.intersection(bounds2) : new Rectangle();
                int area = intersection.width * intersection.height;
                if (area <= maxArea) continue;
                maxArea = area;
                maxAreaConfiguration = graphicsConfiguration;
            }
        }
        return maxAreaConfiguration != null ? maxAreaConfiguration : ScreenSizeUtil.getScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getScreenBoundsWithInsets(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.bottom + screenInsets.top;
        if (DEBUG_SCREEN_SIZE) {
            System.err.println("screen bounds = " + screenBounds);
            System.err.println("screen insets = " + screenInsets);
        }
        screenBounds.width = Math.max(screenBounds.width, 1000);
        screenBounds.height = Math.max(screenBounds.height, 800);
        return screenBounds;
    }

    public static GraphicsDevice getScreenDevice() {
        if (overrideGraphicsDevice != null) {
            return overrideGraphicsDevice;
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    public static GraphicsDevice getOverrideGraphicsDevice() {
        return overrideGraphicsDevice;
    }

    public static void checkOverrideScreenDevice() {
        String testDisplay = System.getenv().get("TEST_DISPLAY");
        if (testDisplay != null) {
            for (GraphicsDevice screenDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!screenDevice.getIDstring().equals(testDisplay)) continue;
                overrideGraphicsDevice = screenDevice;
                return;
            }
        }
    }
}

