/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.gui;

import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class LookAndFeelChangeUtil {
    private static WeakHashMap<Object, LookAndFeelChangeHandler<?>> lookAndFeelChangeHandlers = new WeakHashMap();
    private static WeakHashMap<Window, Object> windows = new WeakHashMap();
    private static boolean nextChangeIsExplicit;

    public static void nextChangeIsExplicit() {
        nextChangeIsExplicit = true;
    }

    public static void fireChangeHandlers() {
        nextChangeIsExplicit = false;
        for (Window window : windows.keySet()) {
            if (window == null) continue;
            try {
                SwingUtilities.updateComponentTreeUI(window);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : lookAndFeelChangeHandlers.entrySet()) {
            if (entry == null) continue;
            Object parent2 = entry.getKey();
            LookAndFeelChangeHandler handler = (LookAndFeelChangeHandler)entry.getValue();
            if (handler == null) continue;
            LookAndFeelChangeUtil.invokeLookAndFeelHandler(parent2, handler);
        }
    }

    private static void invokeLookAndFeelHandler(Object parent2, LookAndFeelChangeHandler handler) {
        try {
            handler.lookAndFeelChanged(parent2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void onLookAndFeelChange(@NotNull T parent2, @NotNull LookAndFeelChangeHandler<T> handler) {
        lookAndFeelChangeHandlers.put(parent2, handler);
    }

    public static <T> void onLookAndFeelChangeAndNow(@NotNull T parent2, @NotNull LookAndFeelChangeHandler<T> handler) {
        LookAndFeelChangeUtil.invokeLookAndFeelHandler(parent2, handler);
        LookAndFeelChangeUtil.onLookAndFeelChange(parent2, handler);
    }

    public static void updateOnLookAndFeelChange(JComponent component) {
        LookAndFeelChangeUtil.onLookAndFeelChange(component, new LookAndFeelChangeHandler<JComponent>(){

            @Override
            public void lookAndFeelChanged(JComponent parent2) {
                SwingUtilities.updateComponentTreeUI(parent2);
            }
        });
    }

    public static void registerWindow(Window window) {
        windows.put(window, null);
    }

    static {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel") && !nextChangeIsExplicit) {
                    LookAndFeelChangeUtil.fireChangeHandlers();
                }
            }
        });
    }

    public static interface LookAndFeelChangeHandler<T> {
        public void lookAndFeelChanged(T var1);
    }
}

