/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.gui;

import com.ejt.internal.util.CommonPlatformUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.lang.reflect.Field;
import org.jetbrains.annotations.Nullable;

public class HiDPIUtil {
    public static final RenderingHints.Key KEY_HIDPI = new RenderingHints.Key(0){

        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Boolean;
        }
    };
    private static final boolean JETBRAINS_JRE = System.getProperty("java.vendor").toLowerCase().contains("jetbrains");
    private static Double cachedScaleFactor;

    public static boolean isIntegerScaleFactor(Graphics2D g) {
        double scaleFactor = HiDPIUtil.getScaleFactor(g);
        return Math.floor(scaleFactor) == scaleFactor;
    }

    public static double getScaleFactor(Graphics2D g) {
        if (g == null) {
            throw new NullPointerException("graphics is null");
        }
        GraphicsConfiguration deviceConfiguration = g.getDeviceConfiguration();
        if (deviceConfiguration == null) {
            throw new NullPointerException("deviceConfiguration is null");
        }
        return HiDPIUtil.getScaleFactor(deviceConfiguration);
    }

    public static double getDefaultDeviceScaleFactor() {
        return HiDPIUtil.getScaleFactor(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public static double getScaleFactor(GraphicsConfiguration deviceConfiguration) {
        double scale2 = deviceConfiguration.getDefaultTransform().getScaleX();
        if (CommonPlatformUtil.isMacOS() && scale2 == 1.0 && !JETBRAINS_JRE) {
            if (cachedScaleFactor == null) {
                HiDPIUtil.initCachedScaleFactor();
            }
            return cachedScaleFactor;
        }
        return scale2;
    }

    private static void initCachedScaleFactor() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        cachedScaleFactor = 1.0;
        try {
            GraphicsDevice device2 = graphicsEnvironment.getDefaultScreenDevice();
            Field field = device2.getClass().getDeclaredField("scale");
            field.setAccessible(true);
            Object scaleValue = field.get(device2);
            if (scaleValue instanceof Integer && (Integer)scaleValue == 2) {
                cachedScaleFactor = 2.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isHiDPI(Graphics2D g) {
        return Boolean.TRUE.equals(g.getRenderingHint(KEY_HIDPI)) || HiDPIUtil.getScaleFactor(g) > 1.0;
    }

    public static void paintScaledIcon(Image iconImage, @Nullable ImageObserver observer2, Component c, Graphics g, int x2, int y2) {
        if (observer2 == null) {
            observer2 = c;
        }
        int width2 = iconImage.getWidth(observer2);
        int height2 = iconImage.getHeight(observer2);
        Graphics2D g2d = (Graphics2D)g.create(x2, y2, width2, height2);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.scale(0.5, 0.5);
        g2d.drawImage(iconImage, 0, 0, observer2);
        g2d.scale(1.0, 1.0);
        g2d.dispose();
    }
}

