/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.util;

import com.atr.jme.font.TrueTypeFont;
import com.atr.jme.font.glyph.Glyph;
import com.jme3.font.Rectangle;
import com.jme3.math.Vector2f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class StringContainer {
    private String text;
    private Glyph[][] lines;
    private float[] lineWidths;
    private Vector2f[] lineHeights;
    private Rectangle textBox;
    private Align align = Align.Left;
    private VAlign valign = VAlign.Top;
    private WrapMode wrap = WrapMode.WordClip;
    private Glyph[] ellipsis;
    private TrueTypeFont font;
    private int kerning = 0;
    private float width = 0.0f;
    private float height = 0.0f;
    private int numNonSpaceChars = 0;
    private int offset = 0;

    public StringContainer(TrueTypeFont font) {
        this(font, "");
    }

    public StringContainer(TrueTypeFont font, String text2) {
        this(font, text2, 0);
    }

    public StringContainer(TrueTypeFont font, String text2, int kerning) {
        this(font, text2, kerning, null);
    }

    public StringContainer(TrueTypeFont font, String text2, int kerning, Rectangle textBox) {
        this(font, text2, kerning, textBox, Align.Left);
    }

    public StringContainer(TrueTypeFont font, String text2, int kerning, Rectangle textBox, Align hAlign) {
        this(font, text2, kerning, textBox, hAlign, VAlign.Top, WrapMode.NoWrap, null);
    }

    public StringContainer(TrueTypeFont font, String text2, int kerning, Rectangle textBox, Align hAlign, VAlign vAlign, WrapMode wrapMode, String ellipsis) {
        this.font = font;
        this.text = text2 == null ? "" : text2;
        this.kerning = kerning;
        this.textBox = textBox == null ? new Rectangle(0.0f, 0.0f, 0.0f, 0.0f) : textBox;
        this.align = hAlign;
        this.valign = vAlign;
        this.wrap = wrapMode;
        this.ellipsis = ellipsis == null ? font.getGlyphs("\u2026") : font.getGlyphs(ellipsis);
    }

    public StringContainer clone() {
        StringContainer newContainer = new StringContainer(this.font, this.text, this.kerning, this.textBox.clone(), this.align, this.valign, this.wrap, null);
        newContainer.ellipsis = Arrays.copyOf(this.ellipsis, this.ellipsis.length);
        if (this.lines != null) {
            newContainer.lines = new Glyph[this.lines.length][];
            for (int i = 0; i < this.lines.length; ++i) {
                newContainer.lines[i] = Arrays.copyOf(this.lines[i], this.lines[i].length);
            }
        }
        return newContainer;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text2) {
        this.text = text2 == null ? "" : text2;
        this.lines = null;
    }

    public Rectangle getTextBox() {
        return this.textBox;
    }

    public void setTextBox(Rectangle textBox) {
        this.textBox = textBox == null ? new Rectangle(0.0f, 0.0f, 0.0f, 0.0f) : textBox;
        this.lines = null;
    }

    public void setOffset(int offset2) {
        this.offset = offset2 >= 0 ? offset2 : 0;
        this.lines = null;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setMaxLines(int maxLines) {
        if (maxLines <= 0) {
            this.textBox = new Rectangle(this.textBox.x, this.textBox.y, this.textBox.width, 0.0f);
            this.lines = null;
            return;
        }
        this.textBox = new Rectangle(this.textBox.x, this.textBox.y, this.textBox.width, this.font.getScaledLineHeight() * (float)maxLines - this.font.getScaledLineGap());
        this.lines = null;
    }

    public Align getAlignment() {
        return this.align;
    }

    public VAlign getVerticalAlignment() {
        return this.valign;
    }

    public void setAlignment(Align hAlign) {
        this.align = hAlign;
        this.lines = null;
    }

    public void setVerticalAlignment(VAlign vAlign) {
        this.valign = vAlign;
        this.lines = null;
    }

    public int getLineCount() {
        return this.lines != null ? this.lines.length : 0;
    }

    public WrapMode getWrapMode() {
        return this.wrap;
    }

    public void setWrapMode(WrapMode wrapMode) {
        this.wrap = wrapMode;
        this.lines = null;
    }

    public void setElipsis(String ellipsis) {
        this.ellipsis = ellipsis == null ? this.font.getGlyphs("\u2026") : this.font.getGlyphs(ellipsis);
        this.lines = null;
    }

    public TrueTypeFont getFont() {
        return this.font;
    }

    public void setFont(TrueTypeFont font) {
        this.font = font;
        this.lines = null;
    }

    public int getKerning() {
        return this.kerning;
    }

    public void setKerning(int kerning) {
        this.kerning = kerning;
        this.lines = null;
    }

    public float getTextWidth() {
        return this.width;
    }

    public float getTextHeight() {
        return this.height;
    }

    public int getNumNonSpaceCharacters() {
        return this.numNonSpaceChars;
    }

    public float[] getLineWidths() {
        return this.lineWidths;
    }

    public Vector2f[] getLineHeights() {
        return this.lineHeights;
    }

    public Glyph[][] getLines() {
        Glyph[] glyphs3;
        int i;
        if (this.lines != null) {
            return this.lines;
        }
        String text2 = this.text;
        if (this.offset > 0) {
            text2 = this.offset < this.text.length() ? this.text.substring(this.offset) : "";
        }
        if (text2.isEmpty()) {
            this.width = 0.0f;
            this.height = 0.0f;
            this.numNonSpaceChars = 0;
            this.lines = new Glyph[0][];
            this.lineWidths = new float[0];
            this.lineHeights = new Vector2f[0];
            return this.lines;
        }
        Object[] stringLines = text2.split("\n");
        int numTrailingBreaks = 0;
        for (i = text2.length() - 1; i >= 0 && text2.charAt(i) == '\n'; --i) {
            ++numTrailingBreaks;
        }
        if (numTrailingBreaks > 0) {
            if (stringLines.length > 0) {
                stringLines = Arrays.copyOf(stringLines, stringLines.length + numTrailingBreaks);
                for (i = stringLines.length - 1; i >= stringLines.length - numTrailingBreaks; --i) {
                    stringLines[i] = "";
                }
            } else {
                stringLines = new String[numTrailingBreaks + 1];
                Arrays.fill(stringLines, "");
            }
        }
        Glyph[][] tmpLines = new Glyph[stringLines.length][];
        for (int i2 = 0; i2 < tmpLines.length; ++i2) {
            tmpLines[i2] = this.font.getGlyphs((String)stringLines[i2]);
        }
        if (this.lines != null) {
            return this.lines;
        }
        this.width = 0.0f;
        this.height = 0.0f;
        this.numNonSpaceChars = 0;
        ArrayList<Float> lineWidthsArray = new ArrayList<Float>();
        LinkedList<Vector2f> lineHeightsArray = new LinkedList<Vector2f>();
        if (this.wrap == WrapMode.NoWrap) {
            this.lines = tmpLines;
            int line = 0;
            for (Glyph[] glyphs2 : this.lines) {
                Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
                float lWidth = 0.0f;
                int pos = 0;
                for (Glyph glyph : glyphs2) {
                    if ((float)glyph.getAscender() > lineHeight.x) {
                        lineHeight.x = glyph.getAscender();
                    }
                    if ((float)glyph.getDescender() < lineHeight.y) {
                        lineHeight.y = glyph.getDescender();
                    }
                    if (glyph.codePoint != 32) {
                        ++this.numNonSpaceChars;
                    }
                    lWidth += (float)(glyph.getXAdvance() + (pos < glyphs2.length - 1 ? this.kerning : 0));
                    ++pos;
                }
                lineWidthsArray.add(Float.valueOf((lWidth *= this.font.getScale()) + 2.0f));
                lineHeightsArray.add(lineHeight.multLocal(this.font.getScale()));
                if (lWidth > this.width) {
                    this.width = lWidth + 2.0f;
                }
                ++line;
            }
            this.height = (float)this.lines.length * this.font.getScaledLineHeight() - this.font.getScaledLineGap();
            this.lineWidths = new float[this.lines.length];
            for (int i3 = 0; i3 < this.lineWidths.length; ++i3) {
                this.lineWidths[i3] = ((Float)lineWidthsArray.get(i3)).floatValue();
            }
            this.lineHeights = new Vector2f[this.lines.length];
            this.lineHeights = lineHeightsArray.toArray(this.lineHeights);
            return this.lines;
        }
        float eWidth = this.font.getLineWidth(this.ellipsis, this.kerning);
        if (this.wrap == WrapMode.Clip) {
            this.lines = new Glyph[1][];
            this.lines[0] = this.getCharClippedLine(0, tmpLines[0], eWidth, lineWidthsArray, lineHeightsArray);
            this.height = this.font.getScaledLineHeight() - this.font.getScaledLineGap();
            this.lineWidths = new float[this.lines.length];
            if (!lineWidthsArray.isEmpty()) {
                for (int i4 = 0; i4 < this.lineWidths.length; ++i4) {
                    this.lineWidths[i4] = ((Float)lineWidthsArray.get(i4)).floatValue();
                }
            } else {
                for (int i5 = 0; i5 < this.lineWidths.length; ++i5) {
                    this.lineWidths[i5] = 0.0f;
                }
            }
            this.lineHeights = new Vector2f[this.lines.length];
            this.lineHeights = lineHeightsArray.toArray(this.lineHeights);
            return this.lines;
        }
        LinkedList<Glyph[]> newLines = new LinkedList<Glyph[]>();
        block0 : switch (this.wrap) {
            case Char: {
                int pos;
                Glyph[] newLine;
                int i6;
                block13: for (i6 = 0; i6 < tmpLines.length; ++i6) {
                    glyphs3 = tmpLines[i6];
                    if (glyphs3.length == 0) {
                        newLines.add(glyphs3);
                        lineWidthsArray.add(new Float(0.0f));
                        lineHeightsArray.add(new Vector2f());
                        continue;
                    }
                    for (pos = 0; pos < glyphs3.length; pos += newLine.length) {
                        newLine = this.getCharLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                        newLines.add(newLine);
                        if (newLine.length == 0) continue block13;
                    }
                }
                break;
            }
            case Word: {
                int pos;
                Glyph[] newLine;
                int i6;
                block15: for (i6 = 0; i6 < tmpLines.length; ++i6) {
                    pos = 0;
                    glyphs3 = tmpLines[i6];
                    if (glyphs3.length == 0) {
                        newLines.add(glyphs3);
                        lineWidthsArray.add(new Float(0.0f));
                        lineHeightsArray.add(new Vector2f());
                        continue;
                    }
                    while (pos < glyphs3.length) {
                        newLine = this.getWordLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                        if (newLine.length == 0) {
                            lineWidthsArray.remove(lineWidthsArray.size() - 1);
                            lineHeightsArray.removeLast();
                            newLine = this.getCharLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                            pos += newLine.length;
                        } else if (pos + newLine.length < glyphs3.length) {
                            if ((pos += newLine.length + 1) == glyphs3.length) {
                                --pos;
                            }
                        } else if (newLine.length == 1 && newLine[0].codePoint == 32 && pos > 0 && glyphs3[pos - 1].codePoint != 32) {
                            newLine = new Glyph[]{};
                            ++pos;
                        } else {
                            pos += newLine.length;
                        }
                        newLines.add(newLine);
                        if (newLine.length != 0 && pos != glyphs3.length) continue;
                        continue block15;
                    }
                }
                break;
            }
            case CharClip: {
                int pos;
                Glyph[] newLine;
                int i6;
                block17: for (i6 = 0; i6 < tmpLines.length && !((float)(newLines.size() + 1) * this.font.getScaledLineHeight() - this.font.getScaledLineGap() > this.textBox.height); ++i6) {
                    glyphs3 = tmpLines[i6];
                    if (glyphs3.length == 0) {
                        newLines.add(glyphs3);
                        this.height += this.font.getScaledLineHeight();
                        lineWidthsArray.add(new Float(0.0f));
                        lineHeightsArray.add(new Vector2f());
                        if (!(this.height + this.font.getScaledLineHeight() - this.font.getScaledLineGap() > this.textBox.height)) continue;
                        break block0;
                    }
                    for (pos = 0; pos < glyphs3.length; pos += newLine.length) {
                        if (this.height + this.font.getScaledLineHeight() * 2.0f - this.font.getScaledLineGap() <= this.textBox.height) {
                            newLine = this.getCharLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                            newLines.add(newLine);
                            this.height += this.font.getScaledLineHeight();
                            if (newLine.length == 0) continue block17;
                            continue;
                        }
                        newLines.add(this.getCharClippedLine(pos, glyphs3, eWidth, lineWidthsArray, lineHeightsArray));
                        this.height += this.font.getScaledLineHeight();
                        break block0;
                    }
                }
                break;
            }
            default: {
                int pos;
                Glyph[] newLine;
                int i6;
                block19: for (i6 = 0; i6 < tmpLines.length && !((float)(newLines.size() + 1) * this.font.getScaledLineHeight() - this.font.getScaledLineGap() > this.textBox.height); ++i6) {
                    pos = 0;
                    glyphs3 = tmpLines[i6];
                    if (glyphs3.length == 0) {
                        newLines.add(glyphs3);
                        this.height += this.font.getScaledLineHeight();
                        lineWidthsArray.add(new Float(0.0f));
                        lineHeightsArray.add(new Vector2f());
                        if (!(this.height + this.font.getScaledLineHeight() - this.font.getScaledLineGap() > this.textBox.height)) continue;
                        break block0;
                    }
                    while (pos < glyphs3.length) {
                        if (this.height + this.font.getScaledLineHeight() * 2.0f - this.font.getScaledLineGap() <= this.textBox.height) {
                            newLine = this.getWordLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                            if (newLine.length == 0) {
                                lineWidthsArray.remove(lineWidthsArray.size() - 1);
                                lineHeightsArray.removeLast();
                                newLine = this.getCharLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                                pos += newLine.length;
                            } else if (pos + newLine.length < glyphs3.length) {
                                if ((pos += newLine.length + 1) == glyphs3.length) {
                                    --pos;
                                }
                            } else if (newLine.length == 1 && newLine[0].codePoint == 32 && pos > 0 && glyphs3[pos - 1].codePoint != 32) {
                                newLine = new Glyph[]{};
                                ++pos;
                            } else {
                                pos += newLine.length;
                            }
                            newLines.add(newLine);
                            this.height += this.font.getScaledLineHeight();
                            if (newLine.length != 0 && pos != glyphs3.length) continue;
                            continue block19;
                        }
                        newLine = this.getWordClippedLine(pos, glyphs3, eWidth, lineWidthsArray, lineHeightsArray);
                        if (newLine.length == 0) {
                            lineWidthsArray.remove(lineWidthsArray.size() - 1);
                            lineHeightsArray.removeLast();
                            newLine = this.getCharLine(pos, glyphs3, lineWidthsArray, lineHeightsArray);
                        }
                        newLines.add(newLine);
                        this.height += this.font.getScaledLineHeight();
                        break block0;
                    }
                }
            }
        }
        this.lines = new Glyph[newLines.size()][];
        this.lineWidths = new float[this.lines.length];
        int pos = 0;
        for (Glyph[] glyphs3 : newLines) {
            this.lines[pos] = glyphs3;
            this.lineWidths[pos] = ((Float)lineWidthsArray.get(pos)).floatValue();
            ++pos;
        }
        this.lineHeights = new Vector2f[this.lines.length];
        this.lineHeights = lineHeightsArray.toArray(this.lineHeights);
        this.height = (float)this.lines.length * this.font.getScaledLineHeight() - this.font.getScaledLineGap();
        if (this.height < 0.0f) {
            this.height = 0.0f;
        }
        return this.lines;
    }

    private Glyph[] getCharLine(int start2, Glyph[] glyphs, List<Float> lineWidths, List<Vector2f> lineHeights) {
        Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
        float newWidth = 0.0f;
        int pos = start2 - 1;
        do {
            int newPos = pos + 1;
            float gWidth = glyphs[newPos].getXAdvance() + (newPos < glyphs.length - 1 ? this.kerning : 0);
            if (newWidth + (gWidth *= this.font.getScale()) > this.textBox.width) break;
            if (glyphs[newPos].codePoint != 32) {
                ++this.numNonSpaceChars;
            }
            if ((float)glyphs[newPos].getAscender() > lineHeight.x) {
                lineHeight.x = glyphs[newPos].getAscender();
            }
            if ((float)glyphs[newPos].getDescender() < lineHeight.y) {
                lineHeight.y = glyphs[newPos].getDescender();
            }
            pos = newPos;
            newWidth += gWidth;
        } while (pos < glyphs.length - 1);
        if (pos >= start2) {
            if (newWidth > this.width) {
                this.width = newWidth + 2.0f;
            }
            lineWidths.add(Float.valueOf(newWidth + 2.0f));
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
            return Arrays.copyOfRange(glyphs, start2, pos + 1);
        }
        lineWidths.add(Float.valueOf(0.0f));
        lineHeights.add(lineHeight.set(0.0f, 0.0f));
        return new Glyph[0];
    }

    private Glyph[] getCharClippedLine(int start2, Glyph[] glyphs, float ellipsisWidth, List<Float> lineWidths, List<Vector2f> lineHeights) {
        Glyph[] lineGlyphs;
        int newPos;
        if (ellipsisWidth > this.textBox.width) {
            lineWidths.add(new Float(0.0f));
            lineHeights.add(new Vector2f(0.0f, 0.0f));
            return new Glyph[0];
        }
        int pos = start2 - 1;
        float w = 0.0f;
        Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
        do {
            newPos = pos + 1;
            float gWidth = glyphs[newPos].getXAdvance() + (newPos < glyphs.length - 1 ? this.kerning : 0);
            if (w + (gWidth *= this.font.getScale()) > this.textBox.width) break;
            if (glyphs[newPos].codePoint != 32) {
                ++this.numNonSpaceChars;
            }
            w += gWidth;
            if ((float)glyphs[newPos].getAscender() > lineHeight.x) {
                lineHeight.x = glyphs[newPos].getAscender();
            }
            if (!((float)glyphs[newPos].getDescender() < lineHeight.y)) continue;
            lineHeight.y = glyphs[newPos].getDescender();
        } while ((pos = newPos) < glyphs.length - 1);
        if (pos == glyphs.length - 1) {
            if (w > this.width) {
                this.width = w + 2.0f;
            }
            lineWidths.add(Float.valueOf(w + 2.0f));
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
            return Arrays.copyOfRange(glyphs, start2, glyphs.length);
        }
        if (pos < start2) {
            lineWidths.add(Float.valueOf(0.0f));
            lineHeights.add(lineHeight.set(0.0f, 0.0f));
            return new Glyph[0];
        }
        while (!(w + ellipsisWidth <= this.textBox.width) || glyphs[pos].codePoint == 32) {
            w -= (float)(glyphs[pos].getXAdvance() + this.kerning) * this.font.getScale();
            if (glyphs[pos].codePoint != 32) {
                --this.numNonSpaceChars;
            }
            if (--pos >= start2) continue;
        }
        lineHeight.set(Float.MIN_VALUE, Float.MAX_VALUE);
        if (pos >= start2) {
            lineGlyphs = new Glyph[pos + 1 + this.ellipsis.length - start2];
            newPos = start2;
            do {
                lineGlyphs[newPos - start2] = glyphs[newPos];
                if ((float)glyphs[newPos].getAscender() > lineHeight.x) {
                    lineHeight.x = glyphs[newPos].getAscender();
                }
                if (!((float)glyphs[newPos].getDescender() < lineHeight.y)) continue;
                lineHeight.y = glyphs[newPos].getDescender();
            } while (++newPos <= pos);
            pos = 0;
            newPos -= start2;
            while (newPos < lineGlyphs.length) {
                lineGlyphs[newPos] = this.ellipsis[pos];
                if (this.ellipsis[pos].codePoint != 32) {
                    ++this.numNonSpaceChars;
                }
                if ((float)this.ellipsis[pos].getAscender() > lineHeight.x) {
                    lineHeight.x = this.ellipsis[pos].getAscender();
                }
                if ((float)this.ellipsis[pos].getDescender() < lineHeight.y) {
                    lineHeight.y = this.ellipsis[pos].getDescender();
                }
                ++newPos;
                ++pos;
            }
            if (w + ellipsisWidth > this.width) {
                this.width = w + ellipsisWidth + 2.0f;
            }
            lineWidths.add(Float.valueOf(w + ellipsisWidth + 2.0f));
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
        } else {
            for (Glyph glyph : lineGlyphs = Arrays.copyOf(this.ellipsis, this.ellipsis.length)) {
                if (glyph.codePoint != 32) {
                    ++this.numNonSpaceChars;
                }
                if ((float)glyph.getAscender() > lineHeight.x) {
                    lineHeight.x = glyph.getAscender();
                }
                if (!((float)glyph.getDescender() < lineHeight.y)) continue;
                lineHeight.y = glyph.getDescender();
            }
            if (ellipsisWidth > this.width) {
                this.width = ellipsisWidth + 2.0f;
            }
            lineWidths.add(Float.valueOf(ellipsisWidth + 2.0f));
            lineHeights.add(this.ellipsis.length >= 1 ? lineHeight.multLocal(this.font.getScale()) : lineHeight.set(0.0f, 0.0f));
        }
        return lineGlyphs;
    }

    private Glyph[] getWordLine(int start2, Glyph[] glyphs, List<Float> lineWidths, List<Vector2f> lineHeights) {
        WordBound wBound;
        int pos = start2;
        float w = 0.0f;
        Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
        block0: do {
            wBound = this.getWord(pos, glyphs);
            float newWidth = 0.0f;
            float newAscent = lineHeight.x;
            float newDescent = lineHeight.y;
            if (wBound == null) {
                int count2 = 0;
                while (pos < glyphs.length) {
                    float nw = (float)(glyphs[pos].getXAdvance() + (pos < glyphs.length - 1 ? this.kerning : 0)) * this.font.getScale();
                    if (newWidth + nw + w > this.textBox.width) {
                        if (count2 <= 0) break;
                        newWidth -= (float)(glyphs[--pos - 1].getXAdvance() + this.kerning) * this.font.getScale();
                        break;
                    }
                    ++count2;
                    newWidth += nw;
                    newAscent = (float)glyphs[pos].getAscender() > newAscent ? (float)glyphs[pos].getAscender() : newAscent;
                    newDescent = (float)glyphs[pos].getDescender() < newDescent ? (float)glyphs[pos].getDescender() : newDescent;
                    ++pos;
                }
                w += newWidth;
                lineHeight.x = newAscent > lineHeight.x ? newAscent : lineHeight.x;
                lineHeight.y = newDescent < lineHeight.y ? newDescent : lineHeight.y;
                break;
            }
            int numSpaces = 0;
            float spaceWidth = 0.0f;
            for (int i = pos; i < wBound.end; ++i) {
                if (w + (newWidth += (float)(glyphs[i].getXAdvance() + (i < glyphs.length - 1 ? this.kerning : 0)) * this.font.getScale()) > this.textBox.width) {
                    pos += numSpaces > 0 ? numSpaces - 1 : 0;
                    w += spaceWidth;
                    lineHeight.x = newAscent > lineHeight.x ? newAscent : lineHeight.x;
                    lineHeight.y = newDescent < lineHeight.y ? newDescent : lineHeight.y;
                    break block0;
                }
                newAscent = (float)glyphs[i].getAscender() > newAscent ? (float)glyphs[i].getAscender() : newAscent;
                float f = newDescent = (float)glyphs[i].getDescender() < newDescent ? (float)glyphs[i].getDescender() : newDescent;
                if (glyphs[i].codePoint != 32) continue;
                spaceWidth += numSpaces >= 1 ? (float)(glyphs[i].getXAdvance() + (i < glyphs.length - 1 ? this.kerning : 0)) * this.font.getScale() : 0.0f;
                ++numSpaces;
            }
            this.numNonSpaceChars += wBound.end - wBound.start;
            w += newWidth;
            lineHeight.x = newAscent > lineHeight.x ? newAscent : lineHeight.x;
            float f = lineHeight.y = newDescent < lineHeight.y ? newDescent : lineHeight.y;
        } while ((pos = wBound.end) < glyphs.length);
        if (pos == glyphs.length) {
            if (w > this.width) {
                this.width = w + 2.0f;
            }
            lineWidths.add(Float.valueOf(w + 2.0f));
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
            return Arrays.copyOfRange(glyphs, start2, glyphs.length);
        }
        if (pos == start2) {
            lineWidths.add(Float.valueOf(0.0f));
            lineHeights.add(lineHeight.set(0.0f, 0.0f));
            return new Glyph[0];
        }
        w -= (float)(glyphs[pos - 1].getXAdvance() + this.kerning) * this.font.getScale();
        if ((w += (float)glyphs[pos - 1].getXAdvance() * this.font.getScale()) > this.width) {
            this.width = w + 2.0f;
        }
        lineWidths.add(Float.valueOf(w + 2.0f));
        lineHeights.add(lineHeight.multLocal(this.font.getScale()));
        return Arrays.copyOfRange(glyphs, start2, pos);
    }

    private Glyph[] getWordClippedLine(int start2, Glyph[] glyphs, float ellipsisWidth, List<Float> lineWidths, List<Vector2f> lineHeights) {
        WordBound wBound;
        if (ellipsisWidth > this.textBox.width) {
            lineWidths.add(new Float(0.0f));
            lineHeights.add(new Vector2f(0.0f, 0.0f));
            return new Glyph[0];
        }
        int pos = start2;
        float w = 0.0f;
        Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
        block0: do {
            wBound = this.getWord(pos, glyphs);
            float newWidth = 0.0f;
            float newAscent = lineHeight.x;
            float newDescent = lineHeight.y;
            if (wBound == null) {
                int count2 = 0;
                while (pos < glyphs.length) {
                    float nw = (float)(glyphs[pos].getXAdvance() + (pos < glyphs.length - 1 ? this.kerning : 0)) * this.font.getScale();
                    if (newWidth + nw + w > this.textBox.width) {
                        if (count2 <= 0) break;
                        newWidth -= (float)(glyphs[--pos - 1].getXAdvance() + this.kerning) * this.font.getScale();
                        break;
                    }
                    ++count2;
                    newWidth += nw;
                    newAscent = (float)glyphs[pos].getAscender() > newAscent ? (float)glyphs[pos].getAscender() : newAscent;
                    newDescent = (float)glyphs[pos].getDescender() < newDescent ? (float)glyphs[pos].getDescender() : newDescent;
                    ++pos;
                }
                w += newWidth;
                lineHeight.x = newAscent > lineHeight.x ? newAscent : lineHeight.x;
                lineHeight.y = newDescent < lineHeight.y ? newDescent : lineHeight.y;
                break;
            }
            int numSpaces = 0;
            float spaceWidth = 0.0f;
            for (int i = pos; i < wBound.end; ++i) {
                if (w + (newWidth += (float)(glyphs[i].getXAdvance() + (i < glyphs.length - 1 ? this.kerning : 0)) * this.font.getScale()) > this.textBox.width) {
                    pos += numSpaces > 0 ? numSpaces - 1 : 0;
                    w += spaceWidth;
                    lineHeight.x = newAscent > lineHeight.x ? newAscent : lineHeight.x;
                    lineHeight.y = newDescent < lineHeight.y ? newDescent : lineHeight.y;
                    break block0;
                }
                newAscent = (float)glyphs[i].getAscender() > newAscent ? (float)glyphs[i].getAscender() : newAscent;
                float f = newDescent = (float)glyphs[i].getDescender() < newDescent ? (float)glyphs[i].getDescender() : newDescent;
                if (glyphs[i].codePoint != 32) continue;
                spaceWidth += numSpaces >= 1 ? (float)(glyphs[i].getXAdvance() + (i < glyphs.length - 1 ? this.kerning : 0)) * this.font.getScale() : 0.0f;
                ++numSpaces;
            }
            this.numNonSpaceChars += wBound.end - wBound.start;
            w += newWidth;
            lineHeight.x = newAscent > lineHeight.x ? newAscent : lineHeight.x;
            float f = lineHeight.y = newDescent < lineHeight.y ? newDescent : lineHeight.y;
        } while ((pos = wBound.end) < glyphs.length);
        if (pos == glyphs.length) {
            if (w + 2.0f > this.width) {
                this.width = w + 2.0f;
            }
            lineWidths.add(Float.valueOf(w + 2.0f));
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
            return Arrays.copyOfRange(glyphs, start2, glyphs.length);
        }
        if (pos == start2) {
            if (this.ellipsis.length > 0) {
                lineHeight.set(Float.MIN_VALUE, Float.MAX_VALUE);
            } else {
                lineHeight.set(0.0f, 0.0f);
            }
            for (int i = 0; i < this.ellipsis.length; ++i) {
                lineHeight.x = (float)this.ellipsis[i].getAscender() > lineHeight.x ? (float)this.ellipsis[i].getAscender() : lineHeight.x;
                float f = lineHeight.y = (float)this.ellipsis[i].getDescender() < lineHeight.y ? (float)this.ellipsis[i].getDescender() : lineHeight.y;
                if (this.ellipsis[i].codePoint == 32) continue;
                ++this.numNonSpaceChars;
            }
            lineWidths.add(Float.valueOf(ellipsisWidth + 2.0f));
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
            if (ellipsisWidth + 2.0f > this.width) {
                this.width = ellipsisWidth + 2.0f;
            }
            return Arrays.copyOf(this.ellipsis, this.ellipsis.length);
        }
        if (this.ellipsis.length != 0) {
            if (w + ellipsisWidth > this.textBox.width || glyphs[pos - 1].codePoint == 32) {
                int n;
                int n2;
                int backPos = pos - 1;
                boolean spaceFound = false;
                do {
                    if (glyphs[backPos].codePoint == 32) {
                        spaceFound = true;
                    }
                    n2 = glyphs[backPos].getXAdvance();
                    n = backPos < glyphs.length - 1 ? this.kerning : 0;
                } while (--backPos >= start2 && ((w -= (float)(n2 + n) * this.font.getScale()) + ellipsisWidth > this.textBox.width || glyphs[backPos].codePoint == 32 || !spaceFound));
                pos = backPos + 1;
            }
            if (pos == start2) {
                lineHeight.set(Float.MIN_VALUE, Float.MAX_VALUE);
                for (int i = 0; i < this.ellipsis.length; ++i) {
                    lineHeight.x = (float)this.ellipsis[i].getAscender() > lineHeight.x ? (float)this.ellipsis[i].getAscender() : lineHeight.x;
                    float f = lineHeight.y = (float)this.ellipsis[i].getDescender() < lineHeight.y ? (float)this.ellipsis[i].getDescender() : lineHeight.y;
                    if (this.ellipsis[i].codePoint == 32) continue;
                    ++this.numNonSpaceChars;
                }
                lineWidths.add(Float.valueOf(ellipsisWidth + 2.0f));
                lineHeights.add(lineHeight.multLocal(this.font.getScale()));
                if (ellipsisWidth + 2.0f > this.width) {
                    this.width = ellipsisWidth + 2.0f;
                }
                return Arrays.copyOf(this.ellipsis, this.ellipsis.length);
            }
            if (w + ellipsisWidth + 2.0f > this.width) {
                this.width = w + ellipsisWidth + 2.0f;
            }
            lineWidths.add(Float.valueOf(w + ellipsisWidth + 2.0f));
            lineHeight.set(Float.MIN_VALUE, Float.MAX_VALUE);
            Glyph[] lineGlyphs = new Glyph[pos + this.ellipsis.length - start2];
            int newPos = start2;
            do {
                lineGlyphs[newPos - start2] = glyphs[newPos];
                lineHeight.x = (float)glyphs[newPos].getAscender() > lineHeight.x ? (float)glyphs[newPos].getAscender() : lineHeight.x;
                float f = lineHeight.y = (float)glyphs[newPos].getDescender() < lineHeight.y ? (float)glyphs[newPos].getDescender() : lineHeight.y;
            } while (++newPos < pos);
            pos = 0;
            newPos -= start2;
            while (newPos < lineGlyphs.length) {
                lineHeight.x = (float)this.ellipsis[pos].getAscender() > lineHeight.x ? (float)this.ellipsis[pos].getAscender() : lineHeight.x;
                lineHeight.y = (float)this.ellipsis[pos].getDescender() < lineHeight.y ? (float)this.ellipsis[pos].getDescender() : lineHeight.y;
                lineGlyphs[newPos] = this.ellipsis[pos];
                if (this.ellipsis[pos].codePoint != 32) {
                    ++this.numNonSpaceChars;
                }
                ++newPos;
                ++pos;
            }
            lineHeights.add(lineHeight.multLocal(this.font.getScale()));
            return lineGlyphs;
        }
        lineWidths.add(Float.valueOf(w + 2.0f));
        if (w + 2.0f > this.width) {
            this.width = w + 2.0f;
        }
        lineHeights.add(lineHeight.multLocal(this.font.getScale()));
        return Arrays.copyOfRange(glyphs, start2, pos);
    }

    private WordBound getWord(int start2, Glyph[] glyphs) {
        int end2;
        while (start2 != glyphs.length && glyphs[start2].codePoint == 32) {
            ++start2;
        }
        if (start2 == glyphs.length) {
            return null;
        }
        for (end2 = start2 + 1; end2 != glyphs.length && glyphs[end2].codePoint != 32; ++end2) {
        }
        return new WordBound(start2, end2);
    }

    private class WordBound {
        public final int start;
        public final int end;

        private WordBound(int start2, int end2) {
            this.start = start2;
            this.end = end2;
        }
    }

    public static enum WrapMode {
        NoWrap,
        Char,
        Word,
        CharClip,
        WordClip,
        Clip;

    }

    public static enum VAlign {
        Top,
        Center,
        Bottom;

    }

    public static enum Align {
        Left,
        Center,
        Right;

    }
}

