/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.util;

import com.atr.jme.font.shape.TrueTypeContainer;
import com.atr.jme.font.util.StringContainer;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.nio.ByteBuffer;

public class BlurText {
    private final RenderManager rm;
    private final Renderer renderer;
    private FrameBuffer vBuf;
    private FrameBuffer hBuf;
    private Texture2D vTex;
    private Texture2D hTex;
    private Material vBlur;
    private Material hBlur;
    private Material glow;
    protected StringContainer sc;
    private int passes;
    private float offset;
    private float intensity;
    private final Camera cam;
    private final Picture quad;
    protected TrueTypeContainer geom;
    private float containerW;
    private float containerH;
    protected ColorRGBA color;

    public BlurText(AssetManager assetManager2, RenderManager renderManager, StringContainer text2, float intensity, ColorRGBA color2) {
        this(assetManager2, renderManager, text2, 1, intensity, color2);
    }

    public BlurText(AssetManager assetManager2, RenderManager renderManager, StringContainer text2, int passes, float intensity, ColorRGBA color2) {
        this(assetManager2, renderManager, text2, passes, 1.0f, intensity, color2);
    }

    public BlurText(AssetManager assetManager2, RenderManager renderManager, StringContainer text2, int passes, float offset2, float intensity, ColorRGBA color2) {
        this.rm = renderManager;
        this.renderer = this.rm.getRenderer();
        this.sc = text2;
        this.passes = passes < 1 ? 1 : passes;
        this.offset = offset2 < 1.0f ? 1.0f : offset2;
        this.intensity = intensity;
        this.color = color2;
        this.vBlur = new Material(assetManager2, "Common/MatDefs/TTF/Blur/VGaussianBlur.j3md");
        this.hBlur = new Material(assetManager2, "Common/MatDefs/TTF/Blur/HGaussianBlur.j3md");
        this.glow = new Material(assetManager2, "Common/MatDefs/TTF/Blur/blurFinal.j3md");
        this.glow.setColor("Color", new ColorRGBA(color2.r, color2.g, color2.b, color2.a * intensity));
        this.cam = new Camera(1, 1);
        this.quad = new Picture("BlurText");
        this.init();
    }

    public Vector3f getTextOffset() {
        return new Vector3f((float)this.vBuf.getWidth() / 2.0f - this.containerW / 2.0f, (float)this.vBuf.getHeight() / 2.0f - this.containerH / 2.0f, 0.02f);
    }

    public void setPasses(int passes) {
        this.passes = passes < 1 ? 1 : passes;
    }

    public int getPasses() {
        return this.passes;
    }

    public void setOffset(float offset2) {
        this.offset = offset2 < 1.0f ? 1.0f : offset2;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        this.glow.setColor("Color", new ColorRGBA(this.color.r, this.color.g, this.color.b, this.color.a * intensity));
    }

    public float getIntenisty() {
        return this.intensity;
    }

    public void setColor(ColorRGBA color2) {
        this.color.set(color2);
        this.glow.setColor("Color", new ColorRGBA(color2.r, color2.g, color2.b, color2.a * this.intensity));
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setText(StringContainer text2) {
        this.sc = text2;
        this.dispose();
        this.init();
    }

    public StringContainer getText() {
        return this.sc;
    }

    public boolean isDisposed() {
        return this.hTex == null && this.vTex == null;
    }

    protected void init() {
        this.geom = this.sc.getFont().getFormattedText(this.sc, ColorRGBA.White);
        this.containerW = this.sc.getTextBox().width;
        this.containerH = this.sc.getTextBox().height;
        int width2 = (int)Math.ceil(FastMath.sqrt(FastMath.sqr(this.offset * 4.0f) * (float)this.passes) * 2.0f + this.containerW);
        int height2 = (int)Math.ceil(FastMath.sqrt(FastMath.sqr(this.offset * 4.0f) * (float)this.passes) * 2.0f + this.containerH);
        this.vBuf = new FrameBuffer(width2, height2, 1);
        this.hBuf = new FrameBuffer(width2, height2, 1);
        this.vTex = new Texture2D(width2, height2, Image.Format.RGBA8);
        this.vTex.setWrap(Texture.WrapMode.EdgeClamp);
        this.vBuf.setColorTexture(this.vTex);
        this.hTex = new Texture2D(width2, height2, Image.Format.RGBA8);
        this.hTex.setWrap(Texture.WrapMode.EdgeClamp);
        this.hBuf.setColorTexture(this.hTex);
        this.vBlur.setTexture("Texture", this.hTex);
        this.vBlur.setFloat("Scale", this.offset);
        this.vBlur.setFloat("Size", height2);
        this.hBlur.setTexture("Texture", this.vTex);
        this.hBlur.setFloat("Scale", this.offset);
        this.hBlur.setFloat("Size", width2);
        this.cam.resize(width2, height2, true);
        this.quad.setWidth(width2);
        this.quad.setHeight(height2);
    }

    public Texture2D render() {
        if (this.containerW != this.sc.getTextBox().width || this.containerH != this.sc.getTextBox().height || this.isDisposed()) {
            this.dispose();
            this.init();
        } else if (this.hTex == null) {
            int width2 = (int)Math.ceil(FastMath.sqrt(FastMath.sqr(this.offset * 4.0f) * (float)this.passes) * 2.0f + this.containerW);
            int height2 = (int)Math.ceil(FastMath.sqrt(FastMath.sqr(this.offset * 4.0f) * (float)this.passes) * 2.0f + this.containerH);
            this.vBuf = new FrameBuffer(width2, height2, 1);
            this.hBuf = new FrameBuffer(width2, height2, 1);
            this.vBuf.setColorTexture(this.vTex);
            this.hTex = new Texture2D(width2, height2, Image.Format.RGBA8);
            this.hTex.setWrap(Texture.WrapMode.EdgeClamp);
            this.hBuf.setColorTexture(this.hTex);
            this.vBlur.setTexture("Texture", this.hTex);
        }
        if (this.sc.getNumNonSpaceCharacters() == 0) {
            this.rm.setCamera(this.cam, true);
            this.renderer.setBackgroundColor(new ColorRGBA(this.color.r, this.color.g, this.color.b, 0.0f));
            this.renderer.setFrameBuffer(this.hBuf);
            this.renderer.clearBuffers(true, false, false);
            return this.hTex;
        }
        this.geom.setLocalTranslation((float)this.vBuf.getWidth() / 2.0f - this.containerW / 2.0f, (float)this.vBuf.getHeight() / 2.0f + this.containerH / 2.0f, 0.0f);
        this.geom.updateGeometricState();
        this.rm.setCamera(this.cam, true);
        this.renderer.setBackgroundColor(ColorRGBA.Black);
        this.renderer.setFrameBuffer(this.hBuf);
        this.renderer.clearBuffers(true, false, false);
        for (Spatial s : this.geom.getChildren()) {
            if (!(s instanceof Geometry)) continue;
            this.rm.renderGeometry((Geometry)s);
        }
        for (int i = 0; i < this.passes; ++i) {
            this.renderer.setFrameBuffer(this.vBuf);
            this.quad.setMaterial(this.vBlur);
            this.rm.renderGeometry(this.quad);
            this.renderer.setFrameBuffer(this.hBuf);
            this.quad.setMaterial(this.hBlur);
            this.rm.renderGeometry(this.quad);
        }
        this.renderer.setBackgroundColor(new ColorRGBA(this.color.r, this.color.g, this.color.b, 0.0f));
        this.geom.getMaterial().setColor("Color", this.color);
        this.renderer.setFrameBuffer(this.vBuf);
        this.renderer.clearBuffers(true, false, false);
        this.glow.setTexture("Texture", this.hTex);
        this.quad.setMaterial(this.glow);
        this.rm.renderGeometry(this.quad);
        return this.vTex;
    }

    public void disposeLight() {
        if (this.hBuf == null) {
            return;
        }
        String vendor = System.getProperty("java.vendor.url");
        if (vendor != null && vendor.toLowerCase().contains("android")) {
            this.hBuf = null;
            this.hTex = null;
            return;
        }
        this.hBuf.deleteObject(this.renderer);
        this.hTex.getImage().dispose();
        if (!NativeObjectManager.UNSAFE) {
            for (ByteBuffer buf : this.hTex.getImage().getData()) {
                BufferUtils.destroyDirectBuffer(buf);
            }
        }
        this.hBuf = null;
        this.hTex = null;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        String vendor = System.getProperty("java.vendor.url");
        if (vendor != null && vendor.toLowerCase().contains("android")) {
            this.hBuf = null;
            this.hTex = null;
            this.vBuf = null;
            this.vTex = null;
            return;
        }
        this.disposeLight();
        this.vBuf.deleteObject(this.renderer);
        this.vTex.getImage().dispose();
        if (!NativeObjectManager.UNSAFE) {
            for (ByteBuffer buf : this.vTex.getImage().getData()) {
                BufferUtils.destroyDirectBuffer(buf);
            }
        }
        this.vBuf = null;
        this.vTex = null;
    }
}

