/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.shape;

import com.atr.jme.font.glyph.Glyph;
import com.atr.jme.font.util.StringContainer;
import com.jme3.material.Material;
import com.jme3.scene.Node;

public abstract class TrueTypeNode<T extends Glyph>
extends Node {
    protected T[][] glyphs;
    protected int kerning;
    protected StringContainer.Align hAlign;
    protected StringContainer.VAlign vAlign;
    protected Material mat;
    protected float width;
    protected float height;

    public TrueTypeNode(T[][] glyphs, int kerning, StringContainer.Align hAlign, StringContainer.VAlign vAlign, Material material) {
        super("TrueTypeNode");
        this.glyphs = glyphs;
        this.kerning = kerning;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        this.mat = material;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @Override
    public void setMaterial(Material material) {
        super.setMaterial(material);
        this.mat = material;
    }

    public Material getMaterial() {
        return this.mat;
    }

    public void setHorizontalAlignment(StringContainer.Align hAlign) {
        this.hAlign = hAlign;
    }

    public StringContainer.Align getHorizontalAlignment() {
        return this.hAlign;
    }

    public StringContainer.VAlign getVerticalAlignment() {
        return this.vAlign;
    }

    public void setVerticalAlignment(StringContainer.VAlign vAlign) {
        this.vAlign = vAlign;
    }

    public void setKerning(int kerning) {
        this.kerning = kerning;
    }

    public int getKerning() {
        return this.kerning;
    }

    public void setGlyphs(T[][] glyphs) {
        this.glyphs = glyphs;
    }

    public T[][] getGlyphs() {
        return this.glyphs;
    }

    public abstract void setText(String var1);

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphs[i].length == 0) {
                sb.append("\n");
                continue;
            }
            for (T glyph : this.glyphs[i]) {
                sb.appendCodePoint(((Glyph)glyph).codePoint);
            }
            if (i >= this.glyphs.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public abstract void updateGeometry();
}

