/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.shape;

import com.atr.jme.font.TrueTypeMesh;
import com.atr.jme.font.glyph.Glyph;
import com.atr.jme.font.glyph.GlyphMesh;
import com.atr.jme.font.shape.TrueTypeNode;
import com.atr.jme.font.util.StringContainer;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;

public class TrueTypeMeshText
extends TrueTypeNode<GlyphMesh> {
    private final TrueTypeMesh ttm;

    public TrueTypeMeshText(TrueTypeMesh ttm, GlyphMesh[][] glyphs, int kerning, StringContainer.Align hAlign, StringContainer.VAlign vAlign, Material material) {
        super((Glyph[][])glyphs, kerning, hAlign, vAlign, material);
        this.ttm = ttm;
        this.updateGeometry();
    }

    public void setAA(boolean aa) {
        if (this.mat.getParam("useAA") == null) {
            return;
        }
        this.mat.setBoolean("useAA", aa);
    }

    @Override
    public void setText(String text2) {
        this.setGlyphs(this.ttm.getGlyphMatrix(text2));
    }

    @Override
    public void updateGeometry() {
        this.detachAllChildren();
        float[] widths = new float[((GlyphMesh[][])this.glyphs).length];
        Vector2f[] lineHeights = new Vector2f[((GlyphMesh[][])this.glyphs).length];
        this.height = this.ttm.getScaledAscender() + this.ttm.getScaledDescender();
        if (((GlyphMesh[][])this.glyphs).length > 1) {
            this.height += (float)(((GlyphMesh[][])this.glyphs).length - 1) * this.ttm.getScaledLineHeight();
        }
        this.width = 0.0f;
        int startIndex = 0;
        int startLine = 0;
        int numVerts = 0;
        int totalVerts = 0;
        int count2 = 0;
        int lineNum = 0;
        int index2 = 0;
        LinkedList<TextSnippet> snippets = new LinkedList<TextSnippet>();
        for (GlyphMesh[] line : (GlyphMesh[][])this.glyphs) {
            if (line.length == 0) {
                widths[count2++] = 0.0f;
                ++lineNum;
                index2 = 0;
                continue;
            }
            index2 = 0;
            float w = 0.0f;
            Vector2f lineHeight = new Vector2f(Float.MIN_VALUE, Float.MAX_VALUE);
            for (GlyphMesh glyph : line) {
                w += (float)(glyph.getXAdvance() + this.kerning) * this.ttm.getScale();
                if ((float)glyph.getAscender() > lineHeight.x) {
                    lineHeight.x = glyph.getAscender();
                }
                if ((float)glyph.getDescender() < lineHeight.y) {
                    lineHeight.y = glyph.getDescender();
                }
                if (glyph.codePoint != 32) {
                    if (numVerts + glyph.getMesh().getVertexCount() < Short.MAX_VALUE) {
                        numVerts += glyph.getMesh().getVertexCount();
                    } else {
                        snippets.add(new TextSnippet(startLine, lineNum, startIndex, index2, numVerts, totalVerts));
                        totalVerts += numVerts;
                        numVerts = glyph.getMesh().getVertexCount();
                        startLine = lineNum;
                        startIndex = index2;
                    }
                }
                ++index2;
            }
            ++lineNum;
            w -= (float)(line[line.length - 1].getXAdvance() + this.kerning) * this.ttm.getScale();
            lineHeights[count2] = lineHeight.multLocal(this.ttm.getScale());
            widths[count2++] = w += (float)line[line.length - 1].getRight() * this.ttm.getScale();
            if (!(w > this.width)) continue;
            this.width = w;
        }
        snippets.add(new TextSnippet(startLine, ((GlyphMesh[][])this.glyphs).length - 1, startIndex, index2, numVerts, totalVerts));
        Vector2f xyOffset = new Vector2f(0.0f, this.ttm.getScaledAscender());
        float yOffset = 0.0f;
        switch (this.vAlign) {
            case Center: {
                yOffset = this.height / 2.0f;
                break;
            }
            case Bottom: {
                yOffset = this.height;
            }
        }
        for (TextSnippet snippet : snippets) {
            TextMesh mesh = new TextMesh();
            mesh.createMesh((GlyphMesh[][])this.glyphs, snippet, widths, lineHeights, this.width, this.height, yOffset, xyOffset);
            Geometry g = new Geometry("TrueTypeMeshText", mesh);
            g.setMaterial(this.mat);
            this.attachChild(g);
        }
    }

    private class TextMesh
    extends Mesh {
        private TextMesh() {
        }

        public Vector2f createMesh(GlyphMesh[][] lines, TextSnippet snippet, float[] lineWidths, Vector2f[] lineHeights, float width2, float height2, float yOffset, Vector2f currentXY) {
            FloatBuffer verts = BufferUtils.createFloatBuffer(snippet.numVerts * 3);
            FloatBuffer tex1 = BufferUtils.createFloatBuffer(snippet.numVerts * 2);
            FloatBuffer tex2 = BufferUtils.createFloatBuffer(tex1.capacity());
            FloatBuffer tex3 = BufferUtils.createFloatBuffer(tex2.capacity());
            FloatBuffer tex4 = BufferUtils.createFloatBuffer(tex3.capacity());
            FloatBuffer tex5 = BufferUtils.createFloatBuffer(tex4.capacity());
            ShortBuffer indices = BufferUtils.createShortBuffer(snippet.numVerts);
            float startX = currentXY.x;
            float currentY = currentXY.y;
            int currentIndex = 0;
            int startIndex = snippet.startIndex;
            block4: for (int i = snippet.startLine; i <= snippet.endLine; ++i) {
                float currentX = startX;
                startX = 0.0f;
                float xOffset = 0.0f;
                switch (TrueTypeMeshText.this.hAlign) {
                    case Center: {
                        xOffset = -lineWidths[i] / 2.0f;
                        break;
                    }
                    case Right: {
                        xOffset = width2 - lineWidths[i];
                    }
                }
                Vector2f lineY = lineHeights[i];
                float lineHeight = lineY == null ? 0.0f : lineY.x - lineY.y;
                for (int n = startIndex; n < lines[i].length; ++n) {
                    startIndex = 0;
                    if (i == snippet.endLine && n == snippet.endIndex) {
                        if (snippet.endIndex == lines[i].length) {
                            currentXY.set(0.0f, currentY + TrueTypeMeshText.this.ttm.getScaledLineHeight());
                            break block4;
                        }
                        currentXY.set(currentX, currentY);
                        break block4;
                    }
                    GlyphMesh glyph = lines[i][n];
                    if (glyph.codePoint == 32) {
                        currentX += (float)(glyph.getXAdvance() + TrueTypeMeshText.this.kerning);
                        continue;
                    }
                    FloatBuffer gverts = glyph.getMesh().getFloatBuffer(VertexBuffer.Type.Position);
                    gverts.clear();
                    FloatBuffer gtex1 = glyph.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord);
                    gtex1.clear();
                    FloatBuffer gtex2 = glyph.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord2);
                    gtex2.clear();
                    ShortBuffer gindices = glyph.getMesh().getShortBuffer(VertexBuffer.Type.Index);
                    gindices.clear();
                    int w = glyph.getWidth();
                    int h = glyph.getHeight();
                    while (gverts.hasRemaining()) {
                        float x2 = gverts.get();
                        float y2 = gverts.get();
                        float x22 = x2 + currentX * TrueTypeMeshText.this.ttm.getScale();
                        float y22 = y2 - currentY;
                        verts.put(x22 + xOffset);
                        verts.put(y22 + yOffset);
                        verts.put(gverts.get());
                        tex1.put(gtex1.get());
                        tex1.put(gtex1.get());
                        tex2.put(gtex2.get());
                        tex2.put(gtex2.get());
                        tex3.put((x2 - (float)glyph.getLeft() * TrueTypeMeshText.this.ttm.getScale()) / (float)w);
                        tex3.put((y2 - (float)glyph.getDescender() * TrueTypeMeshText.this.ttm.getScale()) / (float)h);
                        tex4.put(x22 / lineWidths[i]);
                        tex4.put((y2 - lineY.y) / lineHeight);
                        if (TrueTypeMeshText.this.hAlign == StringContainer.Align.Center) {
                            tex5.put((x22 + (width2 / 2.0f - lineWidths[i] / 2.0f)) / width2);
                        } else {
                            tex5.put((x22 + xOffset) / width2);
                        }
                        tex5.put(1.0f - y22 / -height2);
                        indices.put((short)(gindices.get() + currentIndex));
                    }
                    currentX += (float)(glyph.getXAdvance() + TrueTypeMeshText.this.kerning);
                    currentIndex = (short)(currentIndex + glyph.getMesh().getVertexCount());
                }
                if (i == snippet.endLine) {
                    currentXY.set(0.0f, currentY + TrueTypeMeshText.this.ttm.getScaledLineHeight());
                    break;
                }
                currentY += TrueTypeMeshText.this.ttm.getScaledLineHeight();
            }
            this.setBuffer(VertexBuffer.Type.Position, 3, verts);
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, tex1);
            this.setBuffer(VertexBuffer.Type.TexCoord2, 2, tex2);
            this.setBuffer(VertexBuffer.Type.TexCoord3, 2, tex3);
            this.setBuffer(VertexBuffer.Type.TexCoord4, 2, tex4);
            this.setBuffer(VertexBuffer.Type.TexCoord5, 2, tex5);
            this.setBuffer(VertexBuffer.Type.Index, 3, indices);
            this.clearCollisionData();
            this.updateBound();
            return currentXY;
        }
    }

    private class TextSnippet {
        public final int startLine;
        public final int endLine;
        public final int startIndex;
        public final int endIndex;
        public final int numVerts;

        private TextSnippet(int startLine, int endLine, int startIndex, int endIndex, int numVerts, int indexOffset) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.numVerts = numVerts;
        }
    }
}

