/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.shape;

import com.atr.jme.font.TrueTypeBMP;
import com.atr.jme.font.glyph.Glyph;
import com.atr.jme.font.glyph.GlyphBMP;
import com.atr.jme.font.shape.TrueTypeContainer;
import com.atr.jme.font.util.StringContainer;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class TrueTypeBMPContainer
extends TrueTypeContainer {
    public TrueTypeBMPContainer(StringContainer stringContainer, Material material) {
        super(stringContainer, material);
        this.attachChild(new Geometry("TrueTypeContainerBMP", new BMPMesh()));
        this.setMaterial(material);
    }

    @Override
    public void updateGeometry() {
        ((BMPMesh)((Geometry)this.getChild(0)).getMesh()).updateMesh();
    }

    private class BMPMesh
    extends Mesh {
        private BMPMesh() {
            this.updateMesh();
        }

        public void updateMesh() {
            Glyph[][] lines = TrueTypeBMPContainer.this.stringContainer.getLines();
            TrueTypeBMP ttb = (TrueTypeBMP)TrueTypeBMPContainer.this.stringContainer.getFont();
            float heightOffset = 0.0f;
            switch (TrueTypeBMPContainer.this.stringContainer.getVerticalAlignment()) {
                case Bottom: {
                    heightOffset = TrueTypeBMPContainer.this.stringContainer.getTextBox().height - TrueTypeBMPContainer.this.stringContainer.getTextHeight();
                    break;
                }
                case Center: {
                    float halfBox = TrueTypeBMPContainer.this.stringContainer.getTextBox().height / 2.0f;
                    float halfHeight = TrueTypeBMPContainer.this.stringContainer.getTextHeight() / 2.0f;
                    heightOffset = halfBox - halfHeight;
                }
            }
            FloatBuffer verts = BufferUtils.createFloatBuffer(TrueTypeBMPContainer.this.stringContainer.getNumNonSpaceCharacters() * 12);
            FloatBuffer tex1 = BufferUtils.createFloatBuffer(TrueTypeBMPContainer.this.stringContainer.getNumNonSpaceCharacters() * 8);
            FloatBuffer tex2 = BufferUtils.createFloatBuffer(tex1.capacity());
            FloatBuffer tex3 = BufferUtils.createFloatBuffer(tex2.capacity());
            FloatBuffer tex4 = BufferUtils.createFloatBuffer(tex3.capacity());
            ShortBuffer indices = BufferUtils.createShortBuffer(TrueTypeBMPContainer.this.stringContainer.getNumNonSpaceCharacters() * 6);
            float[] widths = TrueTypeBMPContainer.this.stringContainer.getLineWidths();
            int padding2 = ttb.padding / 2;
            float currentLineHeight = TrueTypeBMPContainer.this.stringContainer.getFont().getActualAscender();
            short currentIndex = 0;
            int lineNum = 0;
            for (Glyph[] line : lines) {
                if (line.length == 0) {
                    currentLineHeight += (float)TrueTypeBMPContainer.this.stringContainer.getFont().getActualLineHeight();
                    ++lineNum;
                    continue;
                }
                int currentX = 0;
                Vector2f lineY = TrueTypeBMPContainer.this.stringContainer.getLineHeights()[lineNum];
                float lineHeight = lineY.x - lineY.y;
                for (Glyph glyf : line) {
                    GlyphBMP glyph = (GlyphBMP)glyf;
                    if (glyph.codePoint == 32) {
                        currentX += glyph.getXAdvance() + TrueTypeBMPContainer.this.stringContainer.getKerning();
                        continue;
                    }
                    float widthOffset = 0.0f;
                    switch (TrueTypeBMPContainer.this.stringContainer.getAlignment()) {
                        case Right: {
                            widthOffset = TrueTypeBMPContainer.this.stringContainer.getTextBox().width - widths[lineNum];
                            break;
                        }
                        case Center: {
                            float halfBox = TrueTypeBMPContainer.this.stringContainer.getTextBox().width / 2.0f;
                            float halfWidth = widths[lineNum] / 2.0f;
                            widthOffset = halfBox - halfWidth;
                        }
                    }
                    float x2 = currentX + glyph.getXOffset();
                    float y2 = glyph.getYOffset();
                    verts.put((x2 - (float)padding2) * ttb.getScale() + widthOffset);
                    verts.put((y2 - (float)padding2 - currentLineHeight) * ttb.getScale() - heightOffset);
                    verts.put(0.0f);
                    x2 *= ttb.getScale();
                    y2 *= ttb.getScale();
                    tex1.put(glyph.getLeftU());
                    tex1.put(glyph.getBottomV());
                    tex2.put(0.0f);
                    tex2.put(0.0f);
                    tex3.put(x2 / widths[lineNum]);
                    tex3.put((y2 - lineY.y) / lineHeight);
                    if (TrueTypeBMPContainer.this.stringContainer.getAlignment() == StringContainer.Align.Center) {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() / 2.0f - widths[lineNum] / 2.0f)) / TrueTypeBMPContainer.this.getWidth());
                    } else {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() - widths[lineNum])) / TrueTypeBMPContainer.this.getWidth());
                    }
                    tex4.put(1.0f - (y2 - currentLineHeight) / -TrueTypeBMPContainer.this.getHeight());
                    x2 = currentX + glyph.getXOffset() + glyph.atlasWidth;
                    y2 = glyph.getYOffset();
                    verts.put(x2 * ttb.getScale() + widthOffset);
                    verts.put((y2 - (float)padding2 - currentLineHeight) * ttb.getScale() - heightOffset);
                    verts.put(0.0f);
                    x2 *= ttb.getScale();
                    y2 *= ttb.getScale();
                    tex1.put(glyph.getRightU());
                    tex1.put(glyph.getBottomV());
                    tex2.put(1.0f);
                    tex2.put(0.0f);
                    tex3.put(x2 / widths[lineNum]);
                    tex3.put((y2 - lineY.y) / lineHeight);
                    if (TrueTypeBMPContainer.this.stringContainer.getAlignment() == StringContainer.Align.Center) {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() / 2.0f - widths[lineNum] / 2.0f)) / TrueTypeBMPContainer.this.getWidth());
                    } else {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() - widths[lineNum])) / TrueTypeBMPContainer.this.getWidth());
                    }
                    tex4.put(1.0f - (y2 - currentLineHeight) / -TrueTypeBMPContainer.this.getHeight());
                    x2 = currentX + glyph.getXOffset();
                    y2 = glyph.getYOffset() + glyph.atlasHeight;
                    verts.put((x2 - (float)padding2) * ttb.getScale() + widthOffset);
                    verts.put((y2 - currentLineHeight) * ttb.getScale() - heightOffset);
                    verts.put(0.0f);
                    x2 *= ttb.getScale();
                    y2 *= ttb.getScale();
                    tex1.put(glyph.getLeftU());
                    tex1.put(glyph.getTopV());
                    tex2.put(0.0f);
                    tex2.put(1.0f);
                    tex3.put(x2 / widths[lineNum]);
                    tex3.put((y2 - lineY.y) / lineHeight);
                    if (TrueTypeBMPContainer.this.stringContainer.getAlignment() == StringContainer.Align.Center) {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() / 2.0f - widths[lineNum] / 2.0f)) / TrueTypeBMPContainer.this.getWidth());
                    } else {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() - widths[lineNum])) / TrueTypeBMPContainer.this.getWidth());
                    }
                    tex4.put(1.0f - (y2 - currentLineHeight) / -TrueTypeBMPContainer.this.getHeight());
                    x2 = currentX + glyph.getXOffset() + glyph.atlasWidth;
                    y2 = glyph.getYOffset() + glyph.atlasHeight;
                    verts.put(x2 * ttb.getScale() + widthOffset);
                    verts.put((y2 - currentLineHeight) * ttb.getScale() - heightOffset);
                    verts.put(0.0f);
                    x2 *= ttb.getScale();
                    y2 *= ttb.getScale();
                    tex1.put(glyph.getRightU());
                    tex1.put(glyph.getTopV());
                    tex2.put(1.0f);
                    tex2.put(1.0f);
                    tex3.put(x2 / widths[lineNum]);
                    tex3.put((y2 - lineY.y) / lineHeight);
                    if (TrueTypeBMPContainer.this.stringContainer.getAlignment() == StringContainer.Align.Center) {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() / 2.0f - widths[lineNum] / 2.0f)) / TrueTypeBMPContainer.this.getWidth());
                    } else {
                        tex4.put((x2 + (TrueTypeBMPContainer.this.getWidth() - widths[lineNum])) / TrueTypeBMPContainer.this.getWidth());
                    }
                    tex4.put(1.0f - (y2 - currentLineHeight) / -TrueTypeBMPContainer.this.getHeight());
                    indices.put(currentIndex);
                    indices.put((short)(currentIndex + 1));
                    indices.put((short)(currentIndex + 2));
                    indices.put((short)(currentIndex + 2));
                    indices.put((short)(currentIndex + 1));
                    indices.put((short)(currentIndex + 3));
                    currentX += glyph.getXAdvance() + TrueTypeBMPContainer.this.stringContainer.getKerning();
                    currentIndex = (short)(currentIndex + 4);
                }
                currentLineHeight += (float)TrueTypeBMPContainer.this.stringContainer.getFont().getActualLineHeight();
                ++lineNum;
            }
            this.setBuffer(VertexBuffer.Type.Position, 3, verts);
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, tex1);
            this.setBuffer(VertexBuffer.Type.TexCoord2, 2, tex2);
            this.setBuffer(VertexBuffer.Type.TexCoord3, 2, tex3);
            this.setBuffer(VertexBuffer.Type.TexCoord4, 2, tex4);
            this.setBuffer(VertexBuffer.Type.Index, 3, indices);
            this.clearCollisionData();
            this.updateBound();
        }
    }
}

