/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.sfntly;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;

public class AnchorTable
extends Table {
    public final int version;
    public final int flags;
    public final int lookupOffset;
    public final int glyphDataOffset;

    public AnchorTable(Table table) {
        this(table.header(), table.readFontData());
    }

    public AnchorTable(Header header, ReadableFontData data2) {
        super(header, data2);
        if (header != null && data2 != null) {
            this.version = this.data.readUShort(0);
            this.flags = this.data.readUShort(FontData.DataSize.USHORT.size());
            this.lookupOffset = this.data.readULongAsInt(FontData.DataSize.USHORT.size() * 2);
            this.glyphDataOffset = this.data.readULongAsInt(FontData.DataSize.USHORT.size() * 2 + FontData.DataSize.ULONG.size());
        } else {
            this.version = 0;
            this.flags = 0;
            this.lookupOffset = 0;
            this.glyphDataOffset = 0;
        }
    }

    public int getNumAnchors(int glyphId) {
        if (glyphId < 0) {
            return 0;
        }
        int index2 = 2 * glyphId + this.lookupOffset;
        if (index2 > this.glyphDataOffset) {
            return 0;
        }
        index2 = this.data.readUShort(index2);
        return this.data.readULongAsInt(index2 + this.glyphDataOffset);
    }

    public int[] getAnchor(int glyphId, int pointNumber) {
        if (pointNumber < 0 || glyphId < 0) {
            return new int[]{0, 0};
        }
        int index2 = 2 * glyphId + this.lookupOffset;
        if (index2 > this.glyphDataOffset) {
            return new int[]{0, 0};
        }
        index2 = this.data.readUShort(index2) + this.glyphDataOffset;
        int numPoints = this.data.readULongAsInt(index2);
        index2 += FontData.DataSize.ULONG.size() + FontData.DataSize.LONG.size() * pointNumber;
        if (pointNumber >= numPoints) {
            return new int[]{0, 0};
        }
        int x2 = this.data.readShort(index2);
        int y2 = this.data.readShort(index2 + FontData.DataSize.SHORT.size());
        return new int[]{x2, y2};
    }

    public int[] getAnchors(int glyphId) {
        if (glyphId < 0) {
            return new int[]{0, 0};
        }
        int index2 = 2 * glyphId + this.lookupOffset;
        if (index2 > this.glyphDataOffset) {
            return new int[]{0, 0};
        }
        int[] points = new int[this.data.readULongAsInt(index2 = this.data.readUShort(index2) + this.glyphDataOffset) * 2];
        if (points.length == 0) {
            return new int[]{0, 0};
        }
        index2 += FontData.DataSize.ULONG.size();
        int i = 0;
        while (i < points.length) {
            points[i++] = this.data.readShort(index2);
            points[i++] = this.data.readShort(index2 += FontData.DataSize.SHORT.size());
            index2 += FontData.DataSize.SHORT.size();
        }
        return points;
    }
}

