/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.glyph;

import com.atr.jme.font.TrueTypeBMP;
import com.atr.jme.font.glyph.Glyph;

public abstract class GlyphBMP
extends Glyph {
    public final TrueTypeBMP ttb;
    public final int x;
    public final int y;
    public final int atlasWidth;
    public final int atlasHeight;
    protected int hMod;
    protected int xMod;

    public GlyphBMP(TrueTypeBMP ttb, int codePoint, int x2, int y2, int atlasWidth, int atlasHeight) {
        super(codePoint);
        this.ttb = ttb;
        this.x = x2;
        this.y = y2;
        if (codePoint == 32) {
            this.atlasWidth = ttb.padding;
            this.atlasHeight = ttb.padding;
        } else {
            this.atlasWidth = atlasWidth;
            this.atlasHeight = atlasHeight;
        }
    }

    public int getYOffset() {
        return this.hMod;
    }

    public int getXOffset() {
        return this.xMod;
    }

    public float getLeftU() {
        return (float)this.x / (float)this.ttb.getAtlas().getImage().getWidth();
    }

    public float getRightU() {
        return (float)(this.x + this.atlasWidth) / (float)this.ttb.getAtlas().getImage().getWidth();
    }

    public float getBottomV() {
        return (float)this.y / (float)this.ttb.getAtlas().getImage().getHeight();
    }

    public float getTopV() {
        return (float)(this.y + this.atlasHeight) / (float)this.ttb.getAtlas().getImage().getHeight();
    }
}

