/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font.asset;

import com.atr.jme.font.util.Style;
import com.jme3.asset.AssetKey;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.SimpleAssetCache;
import com.jme3.asset.cache.WeakRefAssetCache;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;

public abstract class TrueTypeKey
extends AssetKey {
    private Style style;
    private int pointSize;
    private int dpi;
    private boolean weakCache = false;
    private String preload;

    protected TrueTypeKey(String name, Style style, int pointSize, int dpi, boolean useWeakCache) {
        this(name, style, pointSize, dpi, useWeakCache, "");
    }

    protected TrueTypeKey(String name, Style style, int pointSize, int dpi, boolean useWeakCache, String preloadCharacters) {
        super(name);
        this.style = style;
        this.pointSize = pointSize;
        this.dpi = dpi;
        this.weakCache = useWeakCache;
        this.preload = preloadCharacters;
    }

    @Override
    public Class<? extends AssetCache> getCacheType() {
        return !this.weakCache ? SimpleAssetCache.class : WeakRefAssetCache.class;
    }

    public Style getStyle() {
        return this.style;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public int getScreenDensity() {
        return this.dpi;
    }

    public boolean isWeakCache() {
        return this.weakCache;
    }

    public String getPreloadCharacters() {
        return this.preload;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TrueTypeKey)) {
            return false;
        }
        TrueTypeKey key = (TrueTypeKey)other;
        return this.name.equals(key.getName()) && this.style == key.getStyle() && this.pointSize == key.getPointSize() && this.dpi == key.getScreenDensity() && this.weakCache == key.isWeakCache() && this.preload.equals(key.preload);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.name + "_Style:" + this.style.toString() + "_PointSize:" + Integer.toString(this.pointSize) + "_ScreenDensity:" + Integer.toString(this.dpi) + "_Cache:" + (this.weakCache ? "Weak" : "Strong") + "_Preload:" + this.preload;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        oc.write(this.style.toString(), "style", "Plain");
        oc.write(this.pointSize, "pointSize", 5);
        oc.write(this.dpi, "density", 72);
        oc.write(this.weakCache, "weakCache", false);
        oc.write(this.preload, "preload", "");
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        String styl;
        InputCapsule ic = im.getCapsule(this);
        this.name = TrueTypeKey.reducePath(ic.readString("name", null));
        this.extension = TrueTypeKey.getExtension(this.name);
        switch (styl = ic.readString("style", "Plain")) {
            case "Plain": {
                this.style = Style.Plain;
                break;
            }
            case "Bold": {
                this.style = Style.Bold;
                break;
            }
            case "Italic": {
                this.style = Style.Italic;
                break;
            }
            case "BoldItalic": {
                this.style = Style.BoldItalic;
                break;
            }
            default: {
                this.style = Style.Plain;
            }
        }
        this.pointSize = ic.readInt("pointSize", 5);
        this.dpi = ic.readInt("density", 72);
        this.weakCache = ic.readBoolean("weakCache", false);
        this.preload = ic.readString("preload", "");
    }
}

