/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.atr.jme.font.TrueTypeBMP;
import com.atr.jme.font.TrueTypeFont;
import com.atr.jme.font.glyph.GlyphSfntly;
import com.atr.jme.font.sfntly.AnchorTable;
import com.atr.jme.font.sfntly.NullAnchorTable;
import com.atr.jme.font.util.AtlasListener;
import com.atr.jme.font.util.Glyf;
import com.atr.jme.font.util.Style;
import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import com.jme3.asset.AssetManager;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TrueTypeSfntly
extends TrueTypeBMP<GlyphSfntly> {
    private final Font font;
    private final CMap characterMap;
    private final LocaTable loca;
    private final GlyphTable glyphs;
    private final HorizontalMetricsTable hmtx;
    private final AnchorTable ankr;
    private final float pointScale;
    private final float italic;
    private float italicRef;
    public final int bold;

    public TrueTypeSfntly(AssetManager assetManager2, Font font, Style style, int pointSize, int outline, int screenDensity, int maxAtlasResolution, String preload2, boolean fixedResolution) {
        super(assetManager2, style, pointSize, outline, screenDensity, maxAtlasResolution, fixedResolution);
        this.font = font;
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        CMap cmap = cmapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        this.characterMap = cmap == null ? cmapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value()) : cmap;
        this.loca = (LocaTable)font.getTable(Tag.loca);
        this.glyphs = (GlyphTable)font.getTable(Tag.glyf);
        this.hmtx = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        FontHeaderTable head = (FontHeaderTable)font.getTable(Tag.head);
        int maxX = head.xMax();
        int minX = head.xMin();
        int maxY = head.yMax();
        int minY = head.yMin();
        this.pointScale = (float)(pointSize * this.dpi) / (72.0f * (float)head.unitsPerEm());
        this.italicRef = (float)maxY * this.pointScale;
        switch (style) {
            case Italic: {
                this.italic = -((float)Math.sin(-0.25)) * this.italicRef;
                this.italicRef = (float)Math.cos(-0.25) * this.italicRef;
                this.bold = 0;
                break;
            }
            case Bold: {
                this.italic = 0.0f;
                this.bold = Math.round((float)this.dpi / 72.0f * 0.03f * (float)pointSize);
                break;
            }
            case BoldItalic: {
                this.italic = -((float)Math.sin(-0.25)) * this.italicRef;
                this.italicRef = (float)Math.cos(-0.25) * this.italicRef;
                this.bold = Math.round((float)this.dpi / 72.0f * 0.03f * (float)pointSize);
                break;
            }
            default: {
                this.italic = 0.0f;
                this.bold = 0;
            }
        }
        this.resizeWidth = (int)Math.ceil((float)(maxX - minX) * this.pointScale) + this.padding + this.bold;
        this.charHeight = (int)Math.ceil((float)(maxY - minY) * this.pointScale) + this.padding + this.bold;
        HorizontalHeaderTable hhea = (HorizontalHeaderTable)font.getTable(Tag.hhea);
        this.ascender = Math.round((float)hhea.ascender() * this.pointScale) + outline + Math.round((float)this.bold / 2.0f);
        this.descender = Math.round((float)(-hhea.descender()) * this.pointScale) + Math.round((float)outline / 2.0f + (float)this.bold / 2.0f);
        this.lineGap = Math.round((float)hhea.lineGap() * this.pointScale);
        this.lineHeight = this.ascender + this.descender + this.lineGap;
        Table t = font.getTable(Tag.intValue((byte[])new byte[]{97, 110, 107, 114}));
        this.ankr = t != null ? new AnchorTable(t) : new NullAnchorTable();
        this.getGlyphs(new StringBuilder().appendCodePoint(this.defaultCodePoint).append(" ").append(preload2));
    }

    public Font getFont() {
        return this.font;
    }

    private Image droidBitmapToImage(Bitmap bitmap2) {
        ByteBuffer buf = BufferUtils.createByteBuffer(bitmap2.getWidth() * bitmap2.getHeight() * 3);
        for (int y2 = 0; y2 < bitmap2.getHeight(); ++y2) {
            for (int x2 = 0; x2 < bitmap2.getWidth(); ++x2) {
                int rgb = bitmap2.getPixel(x2, y2);
                byte r = (byte)((rgb & 0xFF0000) >> 16);
                byte g = (byte)((rgb & 0xFF00) >> 8);
                byte b = (byte)(rgb & 0xFF);
                buf.put(r).put(g).put(b);
            }
        }
        buf.flip();
        return new Image(Image.Format.RGB8, bitmap2.getWidth(), bitmap2.getHeight(), buf, null, ColorSpace.sRGB);
    }

    @Override
    public boolean canDisplay(int codePoint) {
        return this.characterMap.glyphId(codePoint) != 0;
    }

    public int getGlyphID(int codePoint) {
        return this.characterMap.glyphId(codePoint);
    }

    public Glyph getGlyph(int glyphID) {
        return this.glyphs.glyph(this.loca.glyphOffset(glyphID), this.loca.glyphLength(glyphID));
    }

    @Override
    protected void createGlyphs(List<TrueTypeFont.CharToCreate> characters) {
        if (this.atlas == null) {
            this.resizeAtlas();
        }
        boolean added = false;
        HashMap<Integer, Glyf> backLog = new HashMap<Integer, Glyf>();
        do {
            int line = 0;
            for (TrueTypeBMP.AtlasLine al : this.atlasLines) {
                Iterator<TrueTypeFont.CharToCreate> it = characters.iterator();
                while (it.hasNext()) {
                    int w;
                    TrueTypeFont.CharToCreate ctc = it.next();
                    if (this.cache.containsKey(ctc.codePoint)) {
                        it.remove();
                        continue;
                    }
                    int gid = this.getGlyphID(ctc.codePoint);
                    Glyf glyf = (Glyf)backLog.get(ctc.codePoint);
                    if (glyf == null) {
                        glyf = this.getContours(this.getGlyph(gid));
                    }
                    if (al.canFit(w = (int)Math.ceil(glyf.maxX - glyf.minX) + this.padding + this.bold)) {
                        float xAdvance = (float)this.hmtx.advanceWidth(gid) * this.pointScale + (float)this.outline + (float)this.bold + (float)Math.round((float)this.outline / 2.0f);
                        GlyphSfntly gs = new GlyphSfntly(this, al.getX(), line * this.charHeight, ctc.codePoint, glyf, xAdvance, 0.0f);
                        this.cache.put(ctc.codePoint, gs);
                        added = true;
                        al.addChar(w);
                        it.remove();
                        continue;
                    }
                    backLog.put(ctc.codePoint, glyf);
                }
                ++line;
            }
            if (characters.isEmpty()) continue;
            if (this.atlasWidth + this.resizeWidth > this.maxTexRes && this.atlasHeight + this.charHeight > this.maxTexRes) {
                Iterator<TrueTypeFont.CharToCreate> it = characters.iterator();
                while (it.hasNext()) {
                    it.next().codePoint = this.defaultCodePoint;
                    it.remove();
                }
                break;
            }
            this.resizeAtlas();
        } while (!characters.isEmpty());
        if (this.atlasResized || added) {
            int oldHeight;
            int oldWidth = this.atlas != null ? this.atlas.getImage().getWidth() : 0;
            int n = oldHeight = this.atlas != null ? this.atlas.getImage().getHeight() : 0;
            if (this.outline > 0) {
                this.createAtlasOutlined();
            } else {
                this.createAtlas();
            }
            for (AtlasListener listener : this.onAtlas) {
                listener.mod(this.assetManager, oldWidth, oldHeight, this.atlasWidth, this.atlasHeight, this);
            }
        }
    }

    @Override
    protected void createAtlas() {
        Bitmap bitmap2 = Bitmap.createBitmap((int)this.atlasWidth, (int)this.atlasHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawRGB(0, 0, 0);
        Paint paint = new Paint(1);
        paint.setARGB(255, 255, 255, 255);
        if (this.bold > 0) {
            paint.setStyle(Paint.Style.FILL_AND_STROKE);
            paint.setStrokeWidth((float)this.bold);
            paint.setStrokeCap(Paint.Cap.BUTT);
            paint.setStrokeJoin(Paint.Join.ROUND);
        } else {
            paint.setStyle(Paint.Style.FILL);
        }
        for (GlyphSfntly glyph : this.cache.values()) {
            if (glyph.codePoint == 32) continue;
            int x2 = glyph.x + this.padding / 2 - glyph.getXOffset();
            int y2 = glyph.y + this.padding / 2 - glyph.getYOffset();
            canvas.translate((float)x2, (float)y2);
            if (glyph.contours != null) {
                canvas.drawPath(glyph.contours, paint);
                glyph.contours = null;
            } else {
                canvas.drawPath(this.getContours((Glyph)this.getGlyph((int)this.getGlyphID((int)glyph.codePoint))).contours, paint);
            }
            canvas.translate((float)(-x2), (float)(-y2));
        }
        if (this.atlas != null) {
            this.atlas.getImage().dispose();
            if (!NativeObjectManager.UNSAFE) {
                for (ByteBuffer buf : this.atlas.getImage().getData()) {
                    BufferUtils.destroyDirectBuffer(buf);
                }
            }
            this.atlas.setImage(this.droidBitmapToImage(bitmap2));
        } else {
            this.atlas = new Texture2D(this.droidBitmapToImage(bitmap2));
        }
        bitmap2.recycle();
        this.atlasResized = false;
    }

    @Override
    protected void createAtlasOutlined() {
        Bitmap bitmap2 = Bitmap.createBitmap((int)this.atlasWidth, (int)this.atlasHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawRGB(0, 0, 0);
        Paint paint = new Paint(1);
        paint.setStrokeCap(Paint.Cap.BUTT);
        paint.setStrokeJoin(Paint.Join.ROUND);
        for (GlyphSfntly glyph : this.cache.values()) {
            if (glyph.codePoint == 32) continue;
            paint.setARGB(255, 255, 0, 0);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)(this.outline + this.bold));
            int x2 = glyph.x + this.padding / 2 - glyph.getXOffset();
            int y2 = glyph.y + this.padding / 2 - glyph.getYOffset();
            canvas.translate((float)x2, (float)y2);
            Path contours = glyph.contours;
            if (contours != null) {
                canvas.drawPath(contours, paint);
                glyph.contours = null;
            } else {
                contours = this.getContours((Glyph)this.getGlyph((int)this.getGlyphID((int)glyph.codePoint))).contours;
                canvas.drawPath(contours, paint);
            }
            if (this.bold > 0) {
                paint.setStyle(Paint.Style.FILL_AND_STROKE);
                paint.setStrokeWidth((float)this.bold);
            } else {
                paint.setStyle(Paint.Style.FILL);
            }
            paint.setARGB(255, 255, 0, 255);
            canvas.drawPath(contours, paint);
            canvas.translate((float)(-x2), (float)(-y2));
        }
        if (this.atlas != null) {
            this.atlas.getImage().dispose();
            if (!NativeObjectManager.UNSAFE) {
                for (ByteBuffer buf : this.atlas.getImage().getData()) {
                    BufferUtils.destroyDirectBuffer(buf);
                }
            }
            this.atlas.setImage(this.droidBitmapToImage(bitmap2));
        } else {
            this.atlas = new Texture2D(this.droidBitmapToImage(bitmap2));
        }
        bitmap2.recycle();
        this.atlasResized = false;
    }

    private float f2dot14(byte[] value) {
        return (float)ByteBuffer.wrap(value).getShort() * (float)Math.pow(2.0, -14.0);
    }

    private Glyf getContours(Glyph glyf) {
        if (glyf.glyphType() == Glyph.GlyphType.Composite) {
            byte[] transform2;
            CompositeGlyph g = (CompositeGlyph)glyf;
            Glyf[] glyfs = new Glyf[g.numGlyphs()];
            int flags = g.flags(0);
            float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            if ((flags & 8) == 8) {
                matrix[0] = this.f2dot14(g.transformation(0));
                matrix[3] = matrix[0];
            } else if ((flags & 0x40) == 64) {
                transform2 = g.transformation(0);
                matrix[0] = this.f2dot14(new byte[]{transform2[0], transform2[1]});
                matrix[3] = this.f2dot14(new byte[]{transform2[2], transform2[3]});
            } else if ((flags & 0x80) == 128) {
                transform2 = g.transformation(0);
                matrix[0] = this.f2dot14(new byte[]{transform2[0], transform2[1]});
                matrix[1] = this.f2dot14(new byte[]{transform2[2], transform2[3]});
                matrix[2] = this.f2dot14(new byte[]{transform2[4], transform2[5]});
                matrix[3] = this.f2dot14(new byte[]{transform2[6], transform2[7]});
            }
            if ((flags & 2) == 2) {
                matrix[4] = (short)g.argument1(0);
                matrix[5] = (short)g.argument2(0);
            }
            Path path = new Path();
            glyfs[0] = this.getSimpleContours((SimpleGlyph)this.getGlyph(g.glyphIndex(0)), matrix, path);
            float[] lastMatrix = new float[]{matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]};
            for (int i = 1; i < glyfs.length; ++i) {
                byte[] transform3;
                matrix[0] = 1.0f;
                matrix[1] = 0.0f;
                matrix[2] = 0.0f;
                matrix[3] = 1.0f;
                matrix[4] = 0.0f;
                matrix[5] = 0.0f;
                SimpleGlyph glyph = (SimpleGlyph)this.getGlyph(g.glyphIndex(i));
                flags = g.flags(i);
                if ((flags & 8) == 8) {
                    matrix[0] = this.f2dot14(g.transformation(i));
                    matrix[3] = matrix[0];
                } else if ((flags & 0x40) == 64) {
                    transform3 = g.transformation(i);
                    matrix[0] = this.f2dot14(new byte[]{transform3[0], transform3[1]});
                    matrix[3] = this.f2dot14(new byte[]{transform3[2], transform3[3]});
                } else if ((flags & 0x80) == 128) {
                    transform3 = g.transformation(i);
                    matrix[0] = this.f2dot14(new byte[]{transform3[0], transform3[1]});
                    matrix[1] = this.f2dot14(new byte[]{transform3[2], transform3[3]});
                    matrix[2] = this.f2dot14(new byte[]{transform3[4], transform3[5]});
                    matrix[3] = this.f2dot14(new byte[]{transform3[6], transform3[7]});
                }
                if ((flags & 2) == 2) {
                    matrix[4] = (short)g.argument1(i);
                    matrix[5] = (short)g.argument2(i);
                } else if ((flags & 1) == 1) {
                    int[] p1 = this.ankr.getAnchor(g.glyphIndex(i - 1), g.argument1(i));
                    int[] p2 = this.ankr.getAnchor(g.glyphIndex(i), g.argument2(i));
                    float x2 = (float)p1[0] * lastMatrix[0] + (float)p1[1] * lastMatrix[2] + lastMatrix[4];
                    float y2 = (float)p1[0] * lastMatrix[1] + (float)p1[1] * lastMatrix[3] + lastMatrix[5];
                    float x22 = (float)p2[0] * matrix[0] + (float)p2[1] * matrix[2];
                    float y22 = (float)p2[0] * matrix[1] + (float)p2[1] * matrix[3];
                    matrix[4] = x2 - x22;
                    matrix[5] = y2 - y22;
                }
                glyfs[i] = this.getSimpleContours(glyph, matrix, path);
                lastMatrix[0] = matrix[0];
                lastMatrix[1] = matrix[1];
                lastMatrix[2] = matrix[2];
                lastMatrix[3] = matrix[3];
                lastMatrix[4] = matrix[4];
                lastMatrix[5] = matrix[5];
            }
            RectF bounds2 = new RectF();
            path.computeBounds(bounds2, true);
            float maxX = bounds2.right;
            float minX = bounds2.left;
            float maxY = bounds2.bottom;
            float minY = bounds2.top;
            return new Glyf(path, maxX, minX, maxY, minY);
        }
        return this.getSimpleContours((SimpleGlyph)glyf);
    }

    private Glyf getSimpleContours(SimpleGlyph glyf) {
        float maxX = Float.MIN_VALUE;
        float minX = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        int numContours = glyf.numberOfContours();
        Path paths = new Path();
        for (int contour = 0; contour < numContours; ++contour) {
            Path path = new Path();
            int numPoints = glyf.numberOfPoints(contour);
            float last1X = (float)glyf.xCoordinate(contour, 0) * this.pointScale;
            float last1Y = (float)glyf.yCoordinate(contour, 0) * this.pointScale;
            float firstOnCurveX = last1X += last1Y / this.italicRef * this.italic;
            float firstOnCurveY = last1Y;
            boolean last1OnCurve = glyf.onCurve(contour, 0);
            if (last1OnCurve) {
                path.moveTo(last1X, last1Y);
            }
            if (last1X > maxX) {
                maxX = last1X;
            }
            if (last1X < minX) {
                minX = last1X;
            }
            if (last1Y > maxY) {
                maxY = last1Y;
            }
            if (last1Y < minY) {
                minY = last1Y;
            }
            float firstX = last1X;
            float firstY = last1Y;
            boolean firstOnCurve = last1OnCurve;
            for (int point = 1; point < numPoints; ++point) {
                boolean onCurve = glyf.onCurve(contour, point);
                float x2 = (float)glyf.xCoordinate(contour, point) * this.pointScale;
                float y2 = (float)glyf.yCoordinate(contour, point) * this.pointScale;
                if ((x2 += y2 / this.italicRef * this.italic) > maxX) {
                    maxX = x2;
                }
                if (x2 < minX) {
                    minX = x2;
                }
                if (y2 > maxY) {
                    maxY = y2;
                }
                if (y2 < minY) {
                    minY = y2;
                }
                if (!onCurve && !last1OnCurve) {
                    if (point == 1) {
                        last1X = x2;
                        last1Y = y2;
                        x2 = last1X + (x2 - last1X) / 2.0f;
                        y2 = last1Y + (y2 - last1Y) / 2.0f;
                        firstOnCurveX = x2;
                        firstOnCurveY = y2;
                        path.moveTo(x2, y2);
                        last1OnCurve = false;
                        continue;
                    }
                    x2 = last1X + (x2 - last1X) / 2.0f;
                    y2 = last1Y + (y2 - last1Y) / 2.0f;
                    onCurve = true;
                    --point;
                } else if (!last1OnCurve && point == 1) {
                    firstOnCurveX = x2;
                    firstOnCurveY = y2;
                    path.moveTo(x2, y2);
                    last1X = x2;
                    last1Y = y2;
                    last1OnCurve = true;
                    continue;
                }
                if (onCurve && !last1OnCurve) {
                    path.quadTo(last1X, last1Y, x2, y2);
                } else if (onCurve) {
                    path.lineTo(x2, y2);
                }
                last1X = x2;
                last1Y = y2;
                last1OnCurve = onCurve;
            }
            if (last1OnCurve) {
                if (firstOnCurve) {
                    path.close();
                } else {
                    path.quadTo(firstX, firstY, firstOnCurveX, firstOnCurveY);
                    path.close();
                }
            } else if (firstOnCurve) {
                path.quadTo(last1X, last1Y, firstX, firstY);
                path.close();
            } else {
                float x3 = last1X + (firstX - last1X) / 2.0f;
                float y3 = last1Y + (firstY - last1Y) / 2.0f;
                path.quadTo(last1X, last1Y, x3, y3);
                path.quadTo(firstX, firstY, firstOnCurveX, firstOnCurveY);
                path.close();
            }
            paths.addPath(path);
        }
        if (maxX == Float.MIN_VALUE) {
            maxX = 0.0f;
            minX = 0.0f;
        }
        if (maxY == Float.MIN_VALUE) {
            maxY = 0.0f;
            minY = 0.0f;
        }
        Glyf g = new Glyf(paths, maxX, minX, maxY, minY);
        return g;
    }

    private Glyf getSimpleContours(SimpleGlyph glyf, float[] matrix, Path path) {
        float maxX = Float.MIN_VALUE;
        float minX = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        int numContours = glyf.numberOfContours();
        for (int contour = 0; contour < numContours; ++contour) {
            int numPoints = glyf.numberOfPoints(contour);
            float ox = glyf.xCoordinate(contour, 0);
            float last1Y = glyf.yCoordinate(contour, 0);
            float last1X = (ox * matrix[0] + last1Y * matrix[2] + matrix[4]) * this.pointScale;
            last1Y = (ox * matrix[1] + last1Y * matrix[3] + matrix[5]) * this.pointScale;
            float firstOnCurveX = last1X += last1Y / this.italicRef * this.italic;
            float firstOnCurveY = last1Y;
            boolean last1OnCurve = glyf.onCurve(contour, 0);
            if (last1OnCurve) {
                path.moveTo(last1X, last1Y);
            }
            if (last1X > maxX) {
                maxX = last1X;
            }
            if (last1X < minX) {
                minX = last1X;
            }
            if (last1Y > maxY) {
                maxY = last1Y;
            }
            if (last1Y < minY) {
                minY = last1Y;
            }
            float firstX = last1X;
            float firstY = last1Y;
            boolean firstOnCurve = last1OnCurve;
            for (int point = 1; point < numPoints; ++point) {
                boolean onCurve = glyf.onCurve(contour, point);
                ox = glyf.xCoordinate(contour, point);
                float y2 = glyf.yCoordinate(contour, point);
                float x2 = (ox * matrix[0] + y2 * matrix[2] + matrix[4]) * this.pointScale;
                if ((x2 += (y2 = (ox * matrix[1] + y2 * matrix[3] + matrix[5]) * this.pointScale) / this.italicRef * this.italic) > maxX) {
                    maxX = x2;
                }
                if (x2 < minX) {
                    minX = x2;
                }
                if (y2 > maxY) {
                    maxY = y2;
                }
                if (y2 < minY) {
                    minY = y2;
                }
                if (!onCurve && !last1OnCurve) {
                    if (point == 1) {
                        last1X = x2;
                        last1Y = y2;
                        x2 = last1X + (x2 - last1X) / 2.0f;
                        y2 = last1Y + (y2 - last1Y) / 2.0f;
                        firstOnCurveX = x2;
                        firstOnCurveY = y2;
                        path.moveTo(x2, y2);
                        last1OnCurve = false;
                        continue;
                    }
                    x2 = last1X + (x2 - last1X) / 2.0f;
                    y2 = last1Y + (y2 - last1Y) / 2.0f;
                    onCurve = true;
                    --point;
                } else if (!last1OnCurve && point == 1) {
                    firstOnCurveX = x2;
                    firstOnCurveY = y2;
                    path.moveTo(x2, y2);
                    last1X = x2;
                    last1Y = y2;
                    last1OnCurve = true;
                    continue;
                }
                if (onCurve && !last1OnCurve) {
                    path.quadTo(last1X, last1Y, x2, y2);
                } else if (onCurve) {
                    path.lineTo(x2, y2);
                }
                last1X = x2;
                last1Y = y2;
                last1OnCurve = onCurve;
            }
            if (last1OnCurve) {
                if (firstOnCurve) {
                    path.close();
                    continue;
                }
                path.quadTo(firstX, firstY, firstOnCurveX, firstOnCurveY);
                path.close();
                continue;
            }
            if (firstOnCurve) {
                path.quadTo(last1X, last1Y, firstX, firstY);
                path.close();
                continue;
            }
            float x3 = last1X + (firstX - last1X) / 2.0f;
            float y3 = last1Y + (firstY - last1Y) / 2.0f;
            path.quadTo(last1X, last1Y, x3, y3);
            path.quadTo(firstX, firstY, firstOnCurveX, firstOnCurveY);
            path.close();
        }
        if (maxX == Float.MIN_VALUE) {
            maxX = 0.0f;
            minX = 0.0f;
        }
        if (maxY == Float.MIN_VALUE) {
            maxY = 0.0f;
            minY = 0.0f;
        }
        Glyf g = new Glyf(path, maxX, minX, maxY, minY);
        return g;
    }
}

