/*
 * Decompiled with CFR 0.152.
 */
package com.atr.jme.font;

import com.atr.jme.font.TrueTypeFont;
import com.atr.jme.font.glyph.GlyphMesh;
import com.atr.jme.font.sfntly.AnchorTable;
import com.atr.jme.font.sfntly.NullAnchorTable;
import com.atr.jme.font.shape.MeshGlyf;
import com.atr.jme.font.shape.TrueTypeContainer;
import com.atr.jme.font.shape.TrueTypeMeshContainer;
import com.atr.jme.font.shape.TrueTypeMeshText;
import com.atr.jme.font.util.StringContainer;
import com.atr.jme.font.util.Style;
import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import java.util.LinkedList;
import java.util.List;

public class TrueTypeMesh
extends TrueTypeFont<GlyphMesh, TrueTypeMeshText> {
    private final Font font;
    private final CMap characterMap;
    private final LocaTable loca;
    private final GlyphTable glyphs;
    private final HorizontalMetricsTable hmtx;
    private final AnchorTable ankr;
    private final float pointScale;
    private final float italic;
    private float italicRef;
    private final float maxCharX;
    private final float maxCharY;
    private final float minCharX;
    private final float minCharY;
    private boolean aa = true;

    public TrueTypeMesh(AssetManager assetManager2, Font font, Style style, int pointSize, int screenDensity, String preload2) {
        super(assetManager2, style, pointSize, screenDensity);
        this.font = font;
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        CMap cmap = cmapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS4.value());
        this.characterMap = cmap == null ? cmapTable.cmap(Font.PlatformId.Windows.value(), Font.WindowsEncodingId.UnicodeUCS2.value()) : cmap;
        this.loca = (LocaTable)font.getTable(Tag.loca);
        this.glyphs = (GlyphTable)font.getTable(Tag.glyf);
        this.hmtx = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        FontHeaderTable head = (FontHeaderTable)font.getTable(Tag.head);
        int maxX = head.xMax();
        int minX = head.xMin();
        int maxY = head.yMax();
        int minY = head.yMin();
        this.pointScale = (float)(pointSize * this.dpi) / (72.0f * (float)head.unitsPerEm());
        this.italicRef = (float)maxY * this.pointScale;
        switch (style) {
            case Italic: {
                this.italic = -((float)Math.sin(-0.25)) * this.italicRef;
                this.italicRef = (float)Math.cos(-0.25) * this.italicRef;
                break;
            }
            case Bold: {
                this.italic = 0.0f;
                break;
            }
            case BoldItalic: {
                this.italic = -((float)Math.sin(-0.25)) * this.italicRef;
                this.italicRef = (float)Math.cos(-0.25) * this.italicRef;
                break;
            }
            default: {
                this.italic = 0.0f;
            }
        }
        int w = maxX - minX;
        int h = maxY - minY;
        this.maxCharX = (int)Math.ceil(((float)maxX + (float)w * 0.1f) * this.pointScale);
        this.maxCharY = (float)((int)Math.ceil(((float)maxY + (float)h * 0.1f) * this.pointScale)) + 10.0f;
        this.minCharX = (float)((int)Math.floor(((float)minX - (float)w * 0.1f) * this.pointScale)) - 10.0f;
        this.minCharY = (float)((int)Math.floor(((float)minY - (float)h * 0.1f) * this.pointScale)) - 10.0f;
        HorizontalHeaderTable hhea = (HorizontalHeaderTable)font.getTable(Tag.hhea);
        this.ascender = Math.round((float)hhea.ascender() * this.pointScale);
        this.descender = Math.round((float)(-hhea.descender()) * this.pointScale);
        this.lineGap = Math.round((float)hhea.lineGap() * this.pointScale);
        this.lineHeight = this.ascender + this.descender + this.lineGap;
        Table t = font.getTable(Tag.intValue((byte[])new byte[]{97, 110, 107, 114}));
        this.ankr = t != null ? new AnchorTable(t) : new NullAnchorTable();
        this.getGlyphs(new StringBuilder().appendCodePoint(this.defaultCodePoint).append(" ").append(preload2));
    }

    public void setAA(boolean aa) {
        this.aa = aa;
    }

    public boolean isAA() {
        return this.aa;
    }

    public Font getFont() {
        return this.font;
    }

    public float getMaxCharX() {
        return this.maxCharX;
    }

    public float getMaxCharY() {
        return this.maxCharY;
    }

    public float getMinCharX() {
        return this.minCharX;
    }

    public float getMinCharY() {
        return this.minCharY;
    }

    public float getPointScale() {
        return this.pointScale;
    }

    public float getItalicRef() {
        return this.italicRef;
    }

    public float getItalicAngle() {
        return this.italic;
    }

    @Override
    public boolean canDisplay(int codePoint) {
        return this.characterMap.glyphId(codePoint) != 0;
    }

    public int getGlyphID(int codePoint) {
        return this.characterMap.glyphId(codePoint);
    }

    public Glyph getGlyph(int glyphID) {
        return this.glyphs.glyph(this.loca.glyphOffset(glyphID), this.loca.glyphLength(glyphID));
    }

    public TrueTypeMeshText getText(GlyphMesh[][] glyphs, int kerning, ColorRGBA color2, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        Material mat = new Material(this.assetManager, "Common/MatDefs/TTF/TTF.j3md");
        mat.setColor("Color", color2);
        TrueTypeMeshText ttmt = this.getText(glyphs, kerning, mat, hAlign, vAlign);
        ttmt.setAA(this.aa);
        return ttmt;
    }

    public TrueTypeMeshText getText(GlyphMesh[][] glyphs, int kerning, Material material, StringContainer.Align hAlign, StringContainer.VAlign vAlign) {
        TrueTypeMeshText ttmt = new TrueTypeMeshText(this, glyphs, kerning, hAlign, vAlign, material);
        return ttmt;
    }

    @Override
    public TrueTypeContainer getFormattedText(StringContainer stringContainer, ColorRGBA color2) {
        Material mat = new Material(this.assetManager, "Common/MatDefs/TTF/TTF.j3md");
        mat.setColor("Color", color2);
        TrueTypeMeshContainer ttmc = (TrueTypeMeshContainer)this.getFormattedText(stringContainer, mat);
        ttmc.setAA(this.aa);
        return ttmc;
    }

    @Override
    public TrueTypeContainer getFormattedText(StringContainer stringContainer, Material material) {
        TrueTypeMeshContainer ttmc = new TrueTypeMeshContainer(stringContainer, material);
        ttmc.setLocalTranslation(stringContainer.getTextBox().x, stringContainer.getTextBox().y, 0.0f);
        return ttmc;
    }

    public GlyphMesh[] getGlyphs(StringBuilder text2) {
        GlyphMesh[] glyphs = new GlyphMesh[text2.length()];
        LinkedList<TrueTypeFont.CharToCreate> unCached = new LinkedList<TrueTypeFont.CharToCreate>();
        for (int i = 0; i < text2.length(); ++i) {
            int codePoint = text2.codePointAt(i);
            if (!this.canDisplay(codePoint) || this.invalidCharacters.contains(codePoint)) {
                codePoint = this.defaultCodePoint;
            }
            glyphs[i] = (GlyphMesh)this.cache.get(codePoint);
            if (glyphs[i] != null) continue;
            if (this.cacheLock) {
                glyphs[i] = (GlyphMesh)this.cache.get(this.defaultCodePoint);
                continue;
            }
            unCached.add(new TrueTypeFont.CharToCreate(this, i, codePoint));
        }
        if (!unCached.isEmpty()) {
            this.createGlyphs((LinkedList)unCached.clone());
            for (TrueTypeFont.CharToCreate ctc : unCached) {
                glyphs[ctc.index] = (GlyphMesh)this.cache.get(ctc.codePoint);
            }
        }
        return glyphs;
    }

    public GlyphMesh[][] getGlyphMatrix(String text2) {
        GlyphMesh[][] lines;
        String[] strings = text2.split("\n");
        if (text2.startsWith("\n")) {
            if (text2.endsWith("\n")) {
                lines = new GlyphMesh[strings.length + 2][];
                lines[0] = new GlyphMesh[0];
                lines[lines.length - 1] = new GlyphMesh[0];
                for (int i = 1; i < lines.length - 1; ++i) {
                    lines[i] = (GlyphMesh[])this.getGlyphs(strings[i - 1]);
                }
            } else {
                lines = new GlyphMesh[strings.length + 1][];
                lines[0] = new GlyphMesh[0];
                for (int i = 1; i < lines.length; ++i) {
                    lines[i] = (GlyphMesh[])this.getGlyphs(strings[i - 1]);
                }
            }
        } else {
            lines = new GlyphMesh[strings.length][];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = (GlyphMesh[])this.getGlyphs(strings[i]);
            }
        }
        return lines;
    }

    @Override
    protected void createGlyphs(List<TrueTypeFont.CharToCreate> characters) {
        for (TrueTypeFont.CharToCreate ctc : characters) {
            if (this.cache.containsKey(ctc.codePoint)) continue;
            int gid = this.getGlyphID(ctc.codePoint);
            MeshGlyf mg = new MeshGlyf(this, this.ankr, this.getGlyph(gid));
            GlyphMesh gm = new GlyphMesh(ctc.codePoint, mg, (float)this.hmtx.advanceWidth(gid) * this.pointScale, 0.0f);
            this.cache.put(ctc.codePoint, gm);
        }
    }
}

