/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
final class ClassesInfoCache {
    static ClassesInfoCache sInstance = new ClassesInfoCache();
    private static final int CALL_TYPE_NO_ARG = 0;
    private static final int CALL_TYPE_PROVIDER = 1;
    private static final int CALL_TYPE_PROVIDER_WITH_EVENT = 2;
    private final Map<Class<?>, CallbackInfo> mCallbackMap = new HashMap();
    private final Map<Class<?>, Boolean> mHasLifecycleMethods = new HashMap();

    ClassesInfoCache() {
    }

    boolean hasLifecycleMethods(Class<?> klass) {
        Method[] methods2;
        Boolean hasLifecycleMethods = this.mHasLifecycleMethods.get(klass);
        if (hasLifecycleMethods != null) {
            return hasLifecycleMethods;
        }
        for (Method method : methods2 = this.getDeclaredMethods(klass)) {
            OnLifecycleEvent annotation = method.getAnnotation(OnLifecycleEvent.class);
            if (annotation == null) continue;
            this.createInfo(klass, methods2);
            return true;
        }
        this.mHasLifecycleMethods.put(klass, false);
        return false;
    }

    private Method[] getDeclaredMethods(Class<?> klass) {
        try {
            return klass.getDeclaredMethods();
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("The observer class has some methods that use newer APIs which are not available in the current OS version. Lifecycles cannot access even other methods so you should make sure that your observer classes only access framework classes that are available in your min API level OR use lifecycle:compiler annotation processor.", e);
        }
    }

    CallbackInfo getInfo(Class<?> klass) {
        CallbackInfo existing = this.mCallbackMap.get(klass);
        if (existing != null) {
            return existing;
        }
        existing = this.createInfo(klass, null);
        return existing;
    }

    private void verifyAndPutHandler(Map<MethodReference, Lifecycle.Event> handlers, MethodReference newHandler, Lifecycle.Event newEvent, Class<?> klass) {
        Lifecycle.Event event = handlers.get(newHandler);
        if (event != null && newEvent != event) {
            Method method = newHandler.mMethod;
            throw new IllegalArgumentException("Method " + method.getName() + " in " + klass.getName() + " already declared with different @OnLifecycleEvent value: previous value " + (Object)((Object)event) + ", new value " + (Object)((Object)newEvent));
        }
        if (event == null) {
            handlers.put(newHandler, newEvent);
        }
    }

    private CallbackInfo createInfo(Class<?> klass, @Nullable Method[] declaredMethods) {
        Class<?>[] interfaces;
        CallbackInfo superInfo;
        Class<?> superclass = klass.getSuperclass();
        HashMap<MethodReference, Lifecycle.Event> handlerToEvent = new HashMap<MethodReference, Lifecycle.Event>();
        if (superclass != null && (superInfo = this.getInfo(superclass)) != null) {
            handlerToEvent.putAll(superInfo.mHandlerToEvent);
        }
        for (Class<?> intrfc : interfaces = klass.getInterfaces()) {
            for (Map.Entry<MethodReference, Lifecycle.Event> entry : this.getInfo(intrfc).mHandlerToEvent.entrySet()) {
                this.verifyAndPutHandler(handlerToEvent, entry.getKey(), entry.getValue(), klass);
            }
        }
        Method[] methods2 = declaredMethods != null ? declaredMethods : this.getDeclaredMethods(klass);
        boolean hasLifecycleMethods = false;
        for (Method method : methods2) {
            OnLifecycleEvent annotation = method.getAnnotation(OnLifecycleEvent.class);
            if (annotation == null) continue;
            hasLifecycleMethods = true;
            Class<?>[] params = method.getParameterTypes();
            int callType = 0;
            if (params.length > 0) {
                callType = 1;
                if (!LifecycleOwner.class.isAssignableFrom(params[0])) {
                    throw new IllegalArgumentException("invalid parameter type. Must be one and instanceof LifecycleOwner");
                }
            }
            Lifecycle.Event event = annotation.value();
            if (params.length > 1) {
                callType = 2;
                if (!Lifecycle.Event.class.isAssignableFrom(params[1])) {
                    throw new IllegalArgumentException("invalid parameter type. second arg must be an event");
                }
                if (event != Lifecycle.Event.ON_ANY) {
                    throw new IllegalArgumentException("Second arg is supported only for ON_ANY value");
                }
            }
            if (params.length > 2) {
                throw new IllegalArgumentException("cannot have more than 2 params");
            }
            MethodReference methodReference = new MethodReference(callType, method);
            this.verifyAndPutHandler(handlerToEvent, methodReference, event, klass);
        }
        CallbackInfo info2 = new CallbackInfo(handlerToEvent);
        this.mCallbackMap.put(klass, info2);
        this.mHasLifecycleMethods.put(klass, hasLifecycleMethods);
        return info2;
    }

    @Deprecated
    static class CallbackInfo {
        final Map<Lifecycle.Event, List<MethodReference>> mEventToHandlers;
        final Map<MethodReference, Lifecycle.Event> mHandlerToEvent;

        CallbackInfo(Map<MethodReference, Lifecycle.Event> handlerToEvent) {
            this.mHandlerToEvent = handlerToEvent;
            this.mEventToHandlers = new HashMap<Lifecycle.Event, List<MethodReference>>();
            for (Map.Entry<MethodReference, Lifecycle.Event> entry : handlerToEvent.entrySet()) {
                Lifecycle.Event event = entry.getValue();
                List<MethodReference> methodReferences = this.mEventToHandlers.get((Object)event);
                if (methodReferences == null) {
                    methodReferences = new ArrayList<MethodReference>();
                    this.mEventToHandlers.put(event, methodReferences);
                }
                methodReferences.add(entry.getKey());
            }
        }

        void invokeCallbacks(LifecycleOwner source, Lifecycle.Event event, Object target) {
            CallbackInfo.invokeMethodsForEvent(this.mEventToHandlers.get((Object)event), source, event, target);
            CallbackInfo.invokeMethodsForEvent(this.mEventToHandlers.get((Object)Lifecycle.Event.ON_ANY), source, event, target);
        }

        private static void invokeMethodsForEvent(List<MethodReference> handlers, LifecycleOwner source, Lifecycle.Event event, Object mWrapped) {
            if (handlers != null) {
                for (int i = handlers.size() - 1; i >= 0; --i) {
                    handlers.get(i).invokeCallback(source, event, mWrapped);
                }
            }
        }
    }

    @Deprecated
    static final class MethodReference {
        final int mCallType;
        final Method mMethod;

        MethodReference(int callType, Method method) {
            this.mCallType = callType;
            this.mMethod = method;
            this.mMethod.setAccessible(true);
        }

        void invokeCallback(LifecycleOwner source, Lifecycle.Event event, Object target) {
            try {
                switch (this.mCallType) {
                    case 0: {
                        this.mMethod.invoke(target, new Object[0]);
                        break;
                    }
                    case 1: {
                        this.mMethod.invoke(target, source);
                        break;
                    }
                    case 2: {
                        this.mMethod.invoke(target, new Object[]{source, event});
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to call observer method", e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodReference)) {
                return false;
            }
            MethodReference that = (MethodReference)o;
            return this.mCallType == that.mCallType && this.mMethod.getName().equals(that.mMethod.getName());
        }

        public int hashCode() {
            return 31 * this.mCallType + this.mMethod.getName().hashCode();
        }
    }
}

