/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.tooling.data;

import androidx.compose.runtime.tooling.CompositionGroup;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.tooling.data.ParameterInformation;
import androidx.compose.ui.tooling.data.SlotTreeKt;
import androidx.compose.ui.tooling.data.SourceContext;
import androidx.compose.ui.tooling.data.SourceInformationContext;
import androidx.compose.ui.tooling.data.SourceLocation;
import androidx.compose.ui.tooling.data.UiToolingDataApi;
import androidx.compose.ui.unit.IntRect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BC\u0012&\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\tH\u0002J$\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00152\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u000000J\u0010\u00101\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u00103\u001a\u00020\u0015H\u0002J\b\u00104\u001a\u00020\u0005H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020\u0005H\u0002R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Landroidx/compose/ui/tooling/data/CompositionCallStack;", "T", "Landroidx/compose/ui/tooling/data/SourceContext;", "factory", "Lkotlin/Function3;", "Landroidx/compose/runtime/tooling/CompositionGroup;", "", "contexts", "", "", "", "(Lkotlin/jvm/functions/Function3;Ljava/util/Map;)V", "<set-?>", "Landroidx/compose/ui/unit/IntRect;", "bounds", "getBounds", "()Landroidx/compose/ui/unit/IntRect;", "current", "getCurrent", "()Landroidx/compose/runtime/tooling/CompositionGroup;", "currentCallIndex", "", "depth", "getDepth", "()I", "isInline", "", "()Z", "location", "Landroidx/compose/ui/tooling/data/SourceLocation;", "getLocation", "()Landroidx/compose/ui/tooling/data/SourceLocation;", "name", "getName", "()Ljava/lang/String;", "parameters", "Landroidx/compose/ui/tooling/data/ParameterInformation;", "getParameters", "()Ljava/util/List;", "stack", "Lkotlin/collections/ArrayDeque;", "contextOf", "Landroidx/compose/ui/tooling/data/SourceInformationContext;", "information", "convert", "group", "callIndex", "out", "", "isCall", "parentGroup", "parentDepth", "pop", "push", "", "ui-tooling-data"})
@UiToolingDataApi
@SourceDebugExtension(value={"SMAP\nSlotTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTree.kt\nandroidx/compose/ui/tooling/data/CompositionCallStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,875:1\n1855#2,2:876\n1#3:878\n361#4,7:879\n*S KotlinDebug\n*F\n+ 1 SlotTree.kt\nandroidx/compose/ui/tooling/data/CompositionCallStack\n*L\n588#1:876,2\n656#1:879,7\n*E\n"})
final class CompositionCallStack<T>
implements SourceContext {
    @NotNull
    private final Function3<CompositionGroup, SourceContext, List<? extends T>, T> factory;
    @NotNull
    private final Map<String, Object> contexts;
    @NotNull
    private final ArrayDeque<CompositionGroup> stack;
    private int currentCallIndex;
    @NotNull
    private IntRect bounds;

    public CompositionCallStack(@NotNull Function3<? super CompositionGroup, ? super SourceContext, ? super List<? extends T>, ? extends T> factory, @NotNull Map<String, Object> contexts) {
        Intrinsics.checkNotNullParameter(factory, "factory");
        Intrinsics.checkNotNullParameter(contexts, "contexts");
        this.factory = factory;
        this.contexts = contexts;
        this.stack = new ArrayDeque();
        this.bounds = SlotTreeKt.getEmptyBox();
    }

    @NotNull
    public final IntRect convert(@NotNull CompositionGroup group, int callIndex, @NotNull List<T> out) {
        Object object;
        Object box;
        List children2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(group, "group");
                Intrinsics.checkNotNullParameter(out, "out");
                children2 = new ArrayList();
                box = null;
                box = SlotTreeKt.getEmptyBox();
                this.push(group);
                int childCallIndex = 0;
                Iterable<CompositionGroup> $this$forEach$iv = group.getCompositionGroups();
                boolean $i$f$forEach = false;
                Iterator<CompositionGroup> iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    CompositionGroup element$iv;
                    CompositionGroup child2 = element$iv = iterator2.next();
                    boolean bl = false;
                    box = SlotTreeKt.union((IntRect)box, this.convert(child2, childCallIndex, children2));
                    if (!this.isCall(child2)) continue;
                    ++childCallIndex;
                }
                Object object2 = group.getNode();
                object = object2 instanceof LayoutInfo ? (LayoutInfo)object2 : null;
                if (object == null) break block5;
                LayoutInfo it = object;
                boolean bl = false;
                IntRect intRect = SlotTreeKt.access$boundsOfLayoutNode(it);
                object = intRect;
                if (intRect != null) break block6;
            }
            object = box;
        }
        box = object;
        this.currentCallIndex = callIndex;
        this.bounds = box;
        T t = this.factory.invoke(group, this, children2);
        if (t != null) {
            T it = t;
            boolean bl = false;
            out.add(it);
        }
        this.pop();
        return box;
    }

    @Override
    @Nullable
    public String getName() {
        String string;
        int n;
        String string2 = this.getCurrent().getSourceInfo();
        if (string2 == null) {
            return null;
        }
        String info2 = string2;
        if (StringsKt.startsWith$default(info2, "CC(", false, 2, null)) {
            n = 3;
        } else if (StringsKt.startsWith$default(info2, "C(", false, 2, null)) {
            n = 2;
        } else {
            return null;
        }
        int startIndex = n;
        int endIndex = StringsKt.indexOf$default((CharSequence)info2, ')', 0, false, 6, null);
        if (endIndex > 2) {
            String string3 = info2.substring(startIndex, endIndex);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public boolean isInline() {
        String string = this.getCurrent().getSourceInfo();
        return string != null ? StringsKt.startsWith$default(string, "CC", false, 2, null) : false;
    }

    @Override
    @NotNull
    public IntRect getBounds() {
        return this.bounds;
    }

    @Override
    @Nullable
    public SourceLocation getLocation() {
        Object context2;
        Object object;
        block7: {
            block6: {
                object = this.parentGroup(1);
                if (object == null || (object = object.getSourceInfo()) == null) break block6;
                Object it = object;
                boolean bl = false;
                SourceInformationContext sourceInformationContext = this.contextOf((String)it);
                object = sourceInformationContext;
                if (sourceInformationContext != null) break block7;
            }
            return null;
        }
        Object parentContext = context2 = object;
        int index2 = 2;
        while (index2 < this.stack.size()) {
            SourceInformationContext sourceInformationContext;
            Object object2;
            Object object3 = parentContext;
            if ((object3 != null ? ((SourceInformationContext)object3).getSourceFile() : null) != null) break;
            if ((object2 = this.parentGroup(index2++)) != null && (object2 = object2.getSourceInfo()) != null) {
                Object it = object2;
                boolean bl = false;
                sourceInformationContext = this.contextOf((String)it);
            } else {
                sourceInformationContext = null;
            }
            parentContext = sourceInformationContext;
        }
        return ((SourceInformationContext)context2).sourceLocation(this.currentCallIndex, (SourceInformationContext)parentContext);
    }

    @Override
    @NotNull
    public List<ParameterInformation> getParameters() {
        Object object;
        CompositionGroup group;
        block3: {
            block2: {
                group = this.getCurrent();
                object = group.getSourceInfo();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                SourceInformationContext sourceInformationContext = this.contextOf(it);
                object = sourceInformationContext;
                if (sourceInformationContext != null) break block3;
            }
            return CollectionsKt.emptyList();
        }
        Object context2 = object;
        List data2 = new ArrayList();
        CollectionsKt.addAll((Collection)data2, group.getData());
        return SlotTreeKt.access$extractParameterInfo(data2, (SourceInformationContext)context2);
    }

    @Override
    public int getDepth() {
        return this.stack.size();
    }

    private final void push(CompositionGroup group) {
        this.stack.addLast(group);
    }

    private final CompositionGroup pop() {
        return this.stack.removeLast();
    }

    private final CompositionGroup getCurrent() {
        return this.stack.last();
    }

    private final CompositionGroup parentGroup(int parentDepth) {
        return this.stack.size() > parentDepth ? this.stack.get(this.stack.size() - parentDepth - 1) : null;
    }

    private final SourceInformationContext contextOf(String information) {
        Object object;
        Object object2;
        Map<String, Object> $this$getOrPut$iv = this.contexts;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(information);
        if (value$iv == null) {
            boolean bl = false;
            SourceInformationContext answer$iv = SlotTreeKt.sourceInformationContextOf$default(information, null, 2, null);
            $this$getOrPut$iv.put(information, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        return (object = object2) instanceof SourceInformationContext ? (SourceInformationContext)object : null;
    }

    private final boolean isCall(CompositionGroup group) {
        String string = group.getSourceInfo();
        return string != null ? StringsKt.startsWith$default(string, "C", false, 2, null) : false;
    }
}

