/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathOperation;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0000\u001a4\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a4\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002\u001a:\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u001bH\u0002\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"isInOutline", "", "outline", "Landroidx/compose/ui/graphics/Outline;", "x", "", "y", "tmpTouchPointPath", "Landroidx/compose/ui/graphics/Path;", "tmpOpPath", "isInPath", "path", "isInRectangle", "rect", "Landroidx/compose/ui/geometry/Rect;", "isInRoundedRect", "Landroidx/compose/ui/graphics/Outline$Rounded;", "touchPointPath", "opPath", "isWithinEllipse", "cornerRadius", "Landroidx/compose/ui/geometry/CornerRadius;", "centerX", "centerY", "isWithinEllipse-VE1yxkc", "(FFJFF)Z", "cornersFit", "Landroidx/compose/ui/geometry/RoundRect;", "ui"})
public final class ShapeContainingUtilKt {
    public static final boolean isInOutline(@NotNull Outline outline, float x2, float y2, @Nullable Path tmpTouchPointPath, @Nullable Path tmpOpPath) {
        boolean bl;
        Intrinsics.checkNotNullParameter(outline, "outline");
        Outline outline2 = outline;
        if (outline2 instanceof Outline.Rectangle) {
            bl = ShapeContainingUtilKt.isInRectangle(((Outline.Rectangle)outline).getRect(), x2, y2);
        } else if (outline2 instanceof Outline.Rounded) {
            bl = ShapeContainingUtilKt.isInRoundedRect((Outline.Rounded)outline, x2, y2, tmpTouchPointPath, tmpOpPath);
        } else if (outline2 instanceof Outline.Generic) {
            bl = ShapeContainingUtilKt.isInPath(((Outline.Generic)outline).getPath(), x2, y2, tmpTouchPointPath, tmpOpPath);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static /* synthetic */ boolean isInOutline$default(Outline outline, float f, float f2, Path path, Path path2, int n, Object object) {
        if ((n & 8) != 0) {
            path = null;
        }
        if ((n & 0x10) != 0) {
            path2 = null;
        }
        return ShapeContainingUtilKt.isInOutline(outline, f, f2, path, path2);
    }

    private static final boolean isInRectangle(Rect rect2, float x2, float y2) {
        return rect2.getLeft() <= x2 && x2 < rect2.getRight() && rect2.getTop() <= y2 && y2 < rect2.getBottom();
    }

    private static final boolean isInRoundedRect(Outline.Rounded outline, float x2, float y2, Path touchPointPath, Path opPath) {
        RoundRect rrect = outline.getRoundRect();
        if (x2 < rrect.getLeft() || x2 >= rrect.getRight() || y2 < rrect.getTop() || y2 >= rrect.getBottom()) {
            return false;
        }
        if (!ShapeContainingUtilKt.cornersFit(rrect)) {
            Path path = opPath;
            if (path == null) {
                path = SkiaBackedPath_skikoKt.Path();
            }
            Path path2 = path;
            path2.addRoundRect(rrect);
            return ShapeContainingUtilKt.isInPath(path2, x2, y2, touchPointPath, opPath);
        }
        float topLeftX = rrect.getLeft() + CornerRadius.getX-impl(rrect.getTopLeftCornerRadius-kKHJgLs());
        float topLeftY = rrect.getTop() + CornerRadius.getY-impl(rrect.getTopLeftCornerRadius-kKHJgLs());
        float topRightX = rrect.getRight() - CornerRadius.getX-impl(rrect.getTopRightCornerRadius-kKHJgLs());
        float topRightY = rrect.getTop() + CornerRadius.getY-impl(rrect.getTopRightCornerRadius-kKHJgLs());
        float bottomRightX = rrect.getRight() - CornerRadius.getX-impl(rrect.getBottomRightCornerRadius-kKHJgLs());
        float bottomRightY = rrect.getBottom() - CornerRadius.getY-impl(rrect.getBottomRightCornerRadius-kKHJgLs());
        float bottomLeftX = rrect.getBottom() - CornerRadius.getY-impl(rrect.getBottomLeftCornerRadius-kKHJgLs());
        float bottomLeftY = rrect.getLeft() + CornerRadius.getX-impl(rrect.getBottomLeftCornerRadius-kKHJgLs());
        return x2 < topLeftX && y2 < topLeftY ? ShapeContainingUtilKt.isWithinEllipse-VE1yxkc(x2, y2, rrect.getTopLeftCornerRadius-kKHJgLs(), topLeftX, topLeftY) : (x2 < bottomLeftY && y2 > bottomLeftX ? ShapeContainingUtilKt.isWithinEllipse-VE1yxkc(x2, y2, rrect.getBottomLeftCornerRadius-kKHJgLs(), bottomLeftY, bottomLeftX) : (x2 > topRightX && y2 < topRightY ? ShapeContainingUtilKt.isWithinEllipse-VE1yxkc(x2, y2, rrect.getTopRightCornerRadius-kKHJgLs(), topRightX, topRightY) : (x2 > bottomRightX && y2 > bottomRightY ? ShapeContainingUtilKt.isWithinEllipse-VE1yxkc(x2, y2, rrect.getBottomRightCornerRadius-kKHJgLs(), bottomRightX, bottomRightY) : true)));
    }

    private static final boolean cornersFit(RoundRect $this$cornersFit) {
        return CornerRadius.getX-impl($this$cornersFit.getTopLeftCornerRadius-kKHJgLs()) + CornerRadius.getX-impl($this$cornersFit.getTopRightCornerRadius-kKHJgLs()) <= $this$cornersFit.getWidth() && CornerRadius.getX-impl($this$cornersFit.getBottomLeftCornerRadius-kKHJgLs()) + CornerRadius.getX-impl($this$cornersFit.getBottomRightCornerRadius-kKHJgLs()) <= $this$cornersFit.getWidth() && CornerRadius.getY-impl($this$cornersFit.getTopLeftCornerRadius-kKHJgLs()) + CornerRadius.getY-impl($this$cornersFit.getBottomLeftCornerRadius-kKHJgLs()) <= $this$cornersFit.getHeight() && CornerRadius.getY-impl($this$cornersFit.getTopRightCornerRadius-kKHJgLs()) + CornerRadius.getY-impl($this$cornersFit.getBottomRightCornerRadius-kKHJgLs()) <= $this$cornersFit.getHeight();
    }

    private static final boolean isWithinEllipse-VE1yxkc(float x2, float y2, long cornerRadius, float centerX, float centerY) {
        float radiusY;
        float px = x2 - centerX;
        float py = y2 - centerY;
        float radiusX = CornerRadius.getX-impl(cornerRadius);
        return px * px / (radiusX * radiusX) + py * py / ((radiusY = CornerRadius.getY-impl(cornerRadius)) * radiusY) <= 1.0f;
    }

    private static final boolean isInPath(Path path, float x2, float y2, Path tmpTouchPointPath, Path tmpOpPath) {
        Rect rect2 = new Rect(x2 - 0.005f, y2 - 0.005f, x2 + 0.005f, y2 + 0.005f);
        Path path2 = tmpTouchPointPath;
        if (path2 == null) {
            path2 = SkiaBackedPath_skikoKt.Path();
        }
        Path touchPointPath = path2;
        touchPointPath.addRect(rect2);
        Path path3 = tmpOpPath;
        if (path3 == null) {
            path3 = SkiaBackedPath_skikoKt.Path();
        }
        Path opPath = path3;
        opPath.op-N5in7k0(path, touchPointPath, PathOperation.Companion.getIntersect-b3I0S0c());
        boolean isClipped = opPath.isEmpty();
        opPath.reset();
        touchPointPath.reset();
        return !isClipped;
    }
}

