/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.geometry;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.CornerRadiusKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0019\u001a \u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a@\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u001c2\b\b\u0002\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\u001c2\b\b\u0002\u0010\"\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$\u001a\u001e\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012\u001a8\u0010\u0019\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,\u001a6\u0010\u0019\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012\u001a\u001e\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0012\u001a\u001c\u00101\u001a\u00020\u0002*\u00020\u00022\u0006\u00102\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00104\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0015\u0010\f\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0015\u0010\u000e\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\"\u0015\u0010\u000f\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\"\u0015\u0010\u0010\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0012*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\"\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00065"}, d2={"boundingRect", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/geometry/RoundRect;", "getBoundingRect", "(Landroidx/compose/ui/geometry/RoundRect;)Landroidx/compose/ui/geometry/Rect;", "center", "Landroidx/compose/ui/geometry/Offset;", "getCenter", "(Landroidx/compose/ui/geometry/RoundRect;)J", "isCircle", "", "(Landroidx/compose/ui/geometry/RoundRect;)Z", "isEllipse", "isEmpty", "isFinite", "isRect", "isSimple", "maxDimension", "", "getMaxDimension", "(Landroidx/compose/ui/geometry/RoundRect;)F", "minDimension", "getMinDimension", "safeInnerRect", "getSafeInnerRect", "RoundRect", "rect", "cornerRadius", "Landroidx/compose/ui/geometry/CornerRadius;", "RoundRect-sniSvfs", "(Landroidx/compose/ui/geometry/Rect;J)Landroidx/compose/ui/geometry/RoundRect;", "topLeft", "topRight", "bottomRight", "bottomLeft", "RoundRect-ZAM2FJo", "(Landroidx/compose/ui/geometry/Rect;JJJJ)Landroidx/compose/ui/geometry/RoundRect;", "radiusX", "radiusY", "left", "top", "right", "bottom", "RoundRect-gG7oq9Y", "(FFFFJ)Landroidx/compose/ui/geometry/RoundRect;", "lerp", "start", "stop", "fraction", "translate", "offset", "translate-Uv8p0NA", "(Landroidx/compose/ui/geometry/RoundRect;J)Landroidx/compose/ui/geometry/RoundRect;", "ui-geometry"})
public final class RoundRectKt {
    @NotNull
    public static final RoundRect RoundRect(float left, float top, float right, float bottom, float radiusX, float radiusY) {
        long radius = CornerRadiusKt.CornerRadius(radiusX, radiusY);
        return new RoundRect(left, top, right, bottom, radius, radius, radius, radius, null);
    }

    @NotNull
    public static final RoundRect RoundRect-gG7oq9Y(float left, float top, float right, float bottom, long cornerRadius) {
        return RoundRectKt.RoundRect(left, top, right, bottom, CornerRadius.getX-impl(cornerRadius), CornerRadius.getY-impl(cornerRadius));
    }

    @NotNull
    public static final RoundRect RoundRect(@NotNull Rect rect2, float radiusX, float radiusY) {
        Intrinsics.checkNotNullParameter(rect2, "rect");
        return RoundRectKt.RoundRect(rect2.getLeft(), rect2.getTop(), rect2.getRight(), rect2.getBottom(), radiusX, radiusY);
    }

    @NotNull
    public static final RoundRect RoundRect-sniSvfs(@NotNull Rect rect2, long cornerRadius) {
        Intrinsics.checkNotNullParameter(rect2, "rect");
        return RoundRectKt.RoundRect(rect2, CornerRadius.getX-impl(cornerRadius), CornerRadius.getY-impl(cornerRadius));
    }

    @NotNull
    public static final RoundRect RoundRect-ZAM2FJo(@NotNull Rect rect2, long topLeft, long topRight, long bottomRight, long bottomLeft) {
        Intrinsics.checkNotNullParameter(rect2, "rect");
        return new RoundRect(rect2.getLeft(), rect2.getTop(), rect2.getRight(), rect2.getBottom(), topLeft, topRight, bottomRight, bottomLeft, null);
    }

    public static /* synthetic */ RoundRect RoundRect-ZAM2FJo$default(Rect rect2, long l, long l2, long l3, long l4, int n, Object object) {
        if ((n & 2) != 0) {
            l = CornerRadius.Companion.getZero-kKHJgLs();
        }
        if ((n & 4) != 0) {
            l2 = CornerRadius.Companion.getZero-kKHJgLs();
        }
        if ((n & 8) != 0) {
            l3 = CornerRadius.Companion.getZero-kKHJgLs();
        }
        if ((n & 0x10) != 0) {
            l4 = CornerRadius.Companion.getZero-kKHJgLs();
        }
        return RoundRectKt.RoundRect-ZAM2FJo(rect2, l, l2, l3, l4);
    }

    @NotNull
    public static final RoundRect translate-Uv8p0NA(@NotNull RoundRect $this$translate_u2dUv8p0NA, long offset2) {
        Intrinsics.checkNotNullParameter($this$translate_u2dUv8p0NA, "$this$translate");
        return new RoundRect($this$translate_u2dUv8p0NA.getLeft() + Offset.getX-impl(offset2), $this$translate_u2dUv8p0NA.getTop() + Offset.getY-impl(offset2), $this$translate_u2dUv8p0NA.getRight() + Offset.getX-impl(offset2), $this$translate_u2dUv8p0NA.getBottom() + Offset.getY-impl(offset2), $this$translate_u2dUv8p0NA.getTopLeftCornerRadius-kKHJgLs(), $this$translate_u2dUv8p0NA.getTopRightCornerRadius-kKHJgLs(), $this$translate_u2dUv8p0NA.getBottomRightCornerRadius-kKHJgLs(), $this$translate_u2dUv8p0NA.getBottomLeftCornerRadius-kKHJgLs(), null);
    }

    @NotNull
    public static final Rect getBoundingRect(@NotNull RoundRect $this$boundingRect) {
        Intrinsics.checkNotNullParameter($this$boundingRect, "<this>");
        return new Rect($this$boundingRect.getLeft(), $this$boundingRect.getTop(), $this$boundingRect.getRight(), $this$boundingRect.getBottom());
    }

    @NotNull
    public static final Rect getSafeInnerRect(@NotNull RoundRect $this$safeInnerRect) {
        Intrinsics.checkNotNullParameter($this$safeInnerRect, "<this>");
        float insetFactor = 0.29289323f;
        float leftRadius = Math.max(CornerRadius.getX-impl($this$safeInnerRect.getBottomLeftCornerRadius-kKHJgLs()), CornerRadius.getX-impl($this$safeInnerRect.getTopLeftCornerRadius-kKHJgLs()));
        float topRadius = Math.max(CornerRadius.getY-impl($this$safeInnerRect.getTopLeftCornerRadius-kKHJgLs()), CornerRadius.getY-impl($this$safeInnerRect.getTopRightCornerRadius-kKHJgLs()));
        float rightRadius = Math.max(CornerRadius.getX-impl($this$safeInnerRect.getTopRightCornerRadius-kKHJgLs()), CornerRadius.getX-impl($this$safeInnerRect.getBottomRightCornerRadius-kKHJgLs()));
        float bottomRadius = Math.max(CornerRadius.getY-impl($this$safeInnerRect.getBottomRightCornerRadius-kKHJgLs()), CornerRadius.getY-impl($this$safeInnerRect.getBottomLeftCornerRadius-kKHJgLs()));
        return new Rect($this$safeInnerRect.getLeft() + leftRadius * insetFactor, $this$safeInnerRect.getTop() + topRadius * insetFactor, $this$safeInnerRect.getRight() - rightRadius * insetFactor, $this$safeInnerRect.getBottom() - bottomRadius * insetFactor);
    }

    public static final boolean isEmpty(@NotNull RoundRect $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, "<this>");
        return $this$isEmpty.getLeft() >= $this$isEmpty.getRight() || $this$isEmpty.getTop() >= $this$isEmpty.getBottom();
    }

    public static final boolean isFinite(@NotNull RoundRect $this$isFinite) {
        Intrinsics.checkNotNullParameter($this$isFinite, "<this>");
        float f = $this$isFinite.getLeft();
        return !Float.isInfinite(f) && !Float.isNaN(f) && !Float.isInfinite(f = $this$isFinite.getTop()) && !Float.isNaN(f) && !Float.isInfinite(f = $this$isFinite.getRight()) && !Float.isNaN(f) && !Float.isInfinite(f = $this$isFinite.getBottom()) && !Float.isNaN(f);
    }

    public static final boolean isRect(@NotNull RoundRect $this$isRect) {
        Intrinsics.checkNotNullParameter($this$isRect, "<this>");
        return !(!(CornerRadius.getX-impl($this$isRect.getTopLeftCornerRadius-kKHJgLs()) == 0.0f) && !(CornerRadius.getY-impl($this$isRect.getTopLeftCornerRadius-kKHJgLs()) == 0.0f) || !(CornerRadius.getX-impl($this$isRect.getTopRightCornerRadius-kKHJgLs()) == 0.0f) && !(CornerRadius.getY-impl($this$isRect.getTopRightCornerRadius-kKHJgLs()) == 0.0f) || !(CornerRadius.getX-impl($this$isRect.getBottomLeftCornerRadius-kKHJgLs()) == 0.0f) && !(CornerRadius.getY-impl($this$isRect.getBottomLeftCornerRadius-kKHJgLs()) == 0.0f) || !(CornerRadius.getX-impl($this$isRect.getBottomRightCornerRadius-kKHJgLs()) == 0.0f) && !(CornerRadius.getY-impl($this$isRect.getBottomRightCornerRadius-kKHJgLs()) == 0.0f));
    }

    public static final boolean isEllipse(@NotNull RoundRect $this$isEllipse) {
        Intrinsics.checkNotNullParameter($this$isEllipse, "<this>");
        return CornerRadius.getX-impl($this$isEllipse.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getX-impl($this$isEllipse.getTopRightCornerRadius-kKHJgLs()) && CornerRadius.getY-impl($this$isEllipse.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isEllipse.getTopRightCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isEllipse.getTopRightCornerRadius-kKHJgLs()) == CornerRadius.getX-impl($this$isEllipse.getBottomRightCornerRadius-kKHJgLs()) && CornerRadius.getY-impl($this$isEllipse.getTopRightCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isEllipse.getBottomRightCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isEllipse.getBottomRightCornerRadius-kKHJgLs()) == CornerRadius.getX-impl($this$isEllipse.getBottomLeftCornerRadius-kKHJgLs()) && CornerRadius.getY-impl($this$isEllipse.getBottomRightCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isEllipse.getBottomLeftCornerRadius-kKHJgLs()) && (double)$this$isEllipse.getWidth() <= 2.0 * (double)CornerRadius.getX-impl($this$isEllipse.getTopLeftCornerRadius-kKHJgLs()) && (double)$this$isEllipse.getHeight() <= 2.0 * (double)CornerRadius.getY-impl($this$isEllipse.getTopLeftCornerRadius-kKHJgLs());
    }

    public static final boolean isCircle(@NotNull RoundRect $this$isCircle) {
        Intrinsics.checkNotNullParameter($this$isCircle, "<this>");
        return $this$isCircle.getWidth() == $this$isCircle.getHeight() && RoundRectKt.isEllipse($this$isCircle);
    }

    public static final float getMinDimension(@NotNull RoundRect $this$minDimension) {
        Intrinsics.checkNotNullParameter($this$minDimension, "<this>");
        return Math.min(Math.abs($this$minDimension.getWidth()), Math.abs($this$minDimension.getHeight()));
    }

    public static final float getMaxDimension(@NotNull RoundRect $this$maxDimension) {
        Intrinsics.checkNotNullParameter($this$maxDimension, "<this>");
        return Math.max(Math.abs($this$maxDimension.getWidth()), Math.abs($this$maxDimension.getHeight()));
    }

    public static final long getCenter(@NotNull RoundRect $this$center) {
        Intrinsics.checkNotNullParameter($this$center, "<this>");
        return OffsetKt.Offset($this$center.getLeft() + $this$center.getWidth() / 2.0f, $this$center.getTop() + $this$center.getHeight() / 2.0f);
    }

    public static final boolean isSimple(@NotNull RoundRect $this$isSimple) {
        Intrinsics.checkNotNullParameter($this$isSimple, "<this>");
        return CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getX-impl($this$isSimple.getTopRightCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isSimple.getTopRightCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getX-impl($this$isSimple.getBottomRightCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isSimple.getBottomRightCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getX-impl($this$isSimple.getBottomLeftCornerRadius-kKHJgLs()) && CornerRadius.getX-impl($this$isSimple.getTopLeftCornerRadius-kKHJgLs()) == CornerRadius.getY-impl($this$isSimple.getBottomLeftCornerRadius-kKHJgLs());
    }

    @NotNull
    public static final RoundRect lerp(@NotNull RoundRect start2, @NotNull RoundRect stop2, float fraction) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(stop2, "stop");
        return new RoundRect(MathHelpersKt.lerp(start2.getLeft(), stop2.getLeft(), fraction), MathHelpersKt.lerp(start2.getTop(), stop2.getTop(), fraction), MathHelpersKt.lerp(start2.getRight(), stop2.getRight(), fraction), MathHelpersKt.lerp(start2.getBottom(), stop2.getBottom(), fraction), CornerRadiusKt.lerp-3Ry4LBc(start2.getTopLeftCornerRadius-kKHJgLs(), stop2.getTopLeftCornerRadius-kKHJgLs(), fraction), CornerRadiusKt.lerp-3Ry4LBc(start2.getTopRightCornerRadius-kKHJgLs(), stop2.getTopRightCornerRadius-kKHJgLs(), fraction), CornerRadiusKt.lerp-3Ry4LBc(start2.getBottomRightCornerRadius-kKHJgLs(), stop2.getBottomRightCornerRadius-kKHJgLs(), fraction), CornerRadiusKt.lerp-3Ry4LBc(start2.getBottomLeftCornerRadius-kKHJgLs(), stop2.getBottomLeftCornerRadius-kKHJgLs(), fraction), null);
    }
}

