/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.collection.IdentityArraySet;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J+\u0010\u001e\u001a\u00020\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100 H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010!\u001a\u00020\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140 H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0012\u0010\"\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0016\u0010&\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0010H\u0016J\u0006\u0010)\u001a\u00020\u0010J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0002J\u0013\u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J \u0010-\u001a\u00020\u00142\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100 H\u0086\b\u00f8\u0001\u0000J\b\u0010/\u001a\u000200H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR0\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n2\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Landroidx/compose/runtime/collection/IdentityArraySet;", "T", "", "", "()V", "<set-?>", "", "size", "getSize", "()I", "", "values", "getValues", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "add", "", "value", "(Ljava/lang/Object;)Z", "addAll", "", "collection", "", "checkIndexBounds", "index", "clear", "contains", "element", "containsAll", "elements", "fastAny", "block", "Lkotlin/Function1;", "fastForEach", "find", "findExactIndex", "midIndex", "valueHash", "get", "(I)Ljava/lang/Object;", "isEmpty", "isNotEmpty", "iterator", "", "remove", "removeValueIf", "predicate", "toString", "", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIdentityArraySet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n1726#2,3:407\n*S KotlinDebug\n*F\n+ 1 IdentityArraySet.kt\nandroidx/compose/runtime/collection/IdentityArraySet\n*L\n382#1:407,3\n*E\n"})
public final class IdentityArraySet<T>
implements Set<T>,
KMappedMarker {
    private int size;
    @NotNull
    private Object[] values = new Object[16];
    public static final int $stable = 8;

    public int getSize() {
        return this.size;
    }

    @NotNull
    public final Object[] getValues() {
        return this.values;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.find(element) >= 0;
    }

    @NotNull
    public final T get(int index2) {
        this.checkIndexBounds(index2);
        Object object = this.values[index2];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
        return (T)object;
    }

    @Override
    public final boolean add(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, "value");
        int index2 = 0;
        int size2 = this.size();
        Object[] values2 = this.values;
        if (size2 > 0) {
            index2 = this.find(value);
            if (index2 >= 0) {
                return false;
            }
        } else {
            index2 = -1;
        }
        int insertIndex = -(index2 + 1);
        if (size2 == values2.length) {
            Object[] newSorted = new Object[values2.length * 2];
            ArraysKt.copyInto(values2, newSorted, insertIndex + 1, insertIndex, size2);
            ArraysKt.copyInto$default(values2, newSorted, 0, 0, insertIndex, 6, null);
            this.values = newSorted;
        } else {
            ArraysKt.copyInto(values2, values2, insertIndex + 1, insertIndex, size2);
        }
        this.values[insertIndex] = value;
        int n = this.size();
        this.size = n + 1;
        return true;
    }

    @Override
    public final void clear() {
        ArraysKt.fill$default(this.values, null, 0, 0, 6, null);
        this.size = 0;
    }

    public final void fastForEach(@NotNull Function1<? super T, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$fastForEach = false;
        Object[] values2 = this.getValues();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object = values2[i];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            block2.invoke(object);
        }
    }

    public final boolean fastAny(@NotNull Function1<? super T, Boolean> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$fastAny = false;
        int size2 = this.size();
        if (size2 == 0) {
            return false;
        }
        Object[] values2 = this.getValues();
        for (int i = 0; i < size2; ++i) {
            Object object = values2[i];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            if (!block2.invoke(object).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final void addAll(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        if (collection.isEmpty()) {
            return;
        }
        if (!(collection instanceof IdentityArraySet)) {
            for (T value : collection) {
                this.add(value);
            }
        } else {
            boolean elementsInOrder;
            int otherSize;
            Object[] thisValues = this.values;
            Object[] otherValues = ((IdentityArraySet)collection).values;
            int thisSize = this.size();
            int combinedSize = thisSize + (otherSize = ((IdentityArraySet)collection).size());
            boolean needsResize = this.values.length < combinedSize;
            boolean bl = elementsInOrder = thisSize == 0 || ActualJvm_jvmKt.identityHashCode(thisValues[thisSize - 1]) < ActualJvm_jvmKt.identityHashCode(otherValues[0]);
            if (!needsResize && elementsInOrder) {
                ArraysKt.copyInto(otherValues, thisValues, thisSize, 0, otherSize);
                this.size = this.size() + otherSize;
            } else {
                Object[] newArray = needsResize ? new Object[thisSize > otherSize ? thisSize * 2 : otherSize * 2] : thisValues;
                int thisIndex = thisSize - 1;
                int otherIndex = otherSize - 1;
                int nextInsertIndex = combinedSize - 1;
                while (true) {
                    Object object;
                    if (thisIndex < 0) {
                        if (otherIndex < 0) break;
                    }
                    if (thisIndex < 0) {
                        object = otherValues[otherIndex--];
                    } else if (otherIndex < 0) {
                        object = thisValues[thisIndex--];
                    } else {
                        Object thisValue = thisValues[thisIndex];
                        Object otherValue = otherValues[otherIndex];
                        int thisHash = ActualJvm_jvmKt.identityHashCode(thisValue);
                        int otherHash = ActualJvm_jvmKt.identityHashCode(otherValue);
                        if (thisHash > otherHash) {
                            --thisIndex;
                            object = thisValue;
                        } else if (thisHash < otherHash) {
                            --otherIndex;
                            object = otherValue;
                        } else if (thisValue == otherValue) {
                            --thisIndex;
                            --otherIndex;
                            object = thisValue;
                        } else {
                            Object value;
                            int i = thisIndex - 1;
                            boolean foundDuplicate = false;
                            while (i >= 0 && ActualJvm_jvmKt.identityHashCode(value = thisValues[i--]) == otherHash) {
                                if (otherValue != value) continue;
                                foundDuplicate = true;
                                break;
                            }
                            if (foundDuplicate) {
                                --otherIndex;
                                continue;
                            }
                            --otherIndex;
                            object = otherValue;
                        }
                    }
                    Object nextValue = object;
                    newArray[nextInsertIndex--] = nextValue;
                }
                if (nextInsertIndex >= 0) {
                    ArraysKt.copyInto(newArray, newArray, 0, nextInsertIndex + 1, combinedSize);
                }
                int newSize = combinedSize - (nextInsertIndex + 1);
                ArraysKt.fill(newArray, null, newSize, combinedSize);
                this.values = newArray;
                this.size = newSize;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isNotEmpty() {
        return this.size() > 0;
    }

    @Override
    public final boolean remove(@Nullable T value) {
        if (value == null) {
            return false;
        }
        int index2 = this.find(value);
        Object[] values2 = this.values;
        int size2 = this.size();
        if (index2 >= 0) {
            if (index2 < size2 - 1) {
                ArraysKt.copyInto(values2, values2, index2, index2 + 1, size2);
            }
            values2[size2 - 1] = null;
            int n = this.size();
            this.size = n + -1;
            return true;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function1<? super T, Boolean> predicate) {
        int i;
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$removeValueIf = false;
        Object[] values2 = this.getValues();
        int size2 = this.size();
        int destinationIndex = 0;
        for (i = 0; i < size2; ++i) {
            Object item2;
            Intrinsics.checkNotNull(values2[i], "null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
            if (predicate.invoke(item2).booleanValue()) continue;
            if (destinationIndex != i) {
                values2[destinationIndex] = item2;
            }
            ++destinationIndex;
        }
        for (i = destinationIndex; i < size2; ++i) {
            values2[i] = null;
        }
        this.size = destinationIndex;
    }

    private final int find(Object value) {
        int low = 0;
        int high = this.size() - 1;
        int valueIdentity = ActualJvm_jvmKt.identityHashCode(value);
        Object[] values2 = this.values;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = values2[mid];
            int midIdentity = ActualJvm_jvmKt.identityHashCode(midVal);
            if (midIdentity < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midIdentity > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (midVal == value) {
                return mid;
            }
            return this.findExactIndex(mid, value, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        Object v;
        int i;
        Object[] values2 = this.values;
        int size2 = this.size();
        for (i = midIndex - 1; -1 < i; --i) {
            v = values2[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) != valueHash) break;
        }
        for (i = midIndex + 1; i < size2; ++i) {
            v = values2[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(size2 + 1);
    }

    private final void checkIndexBounds(int index2) {
        if (!(0 <= index2 ? index2 < this.size() : false)) {
            throw new IndexOutOfBoundsException("Index " + index2 + ", size " + this.size());
        }
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, "elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int index;
            final /* synthetic */ IdentityArraySet<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            public boolean hasNext() {
                return this.index < this.this$0.size();
            }

            @NotNull
            public T next() {
                int n = this.index;
                this.index = n + 1;
                Object object = this.this$0.getValues()[n];
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of androidx.compose.runtime.collection.IdentityArraySet");
                return (T)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this, null, "[", "]", 0, null, toString.1.INSTANCE, 25, null);
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

