/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.IntStack;
import androidx.compose.runtime.PrioritySet;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\bA\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00af\u00012\u00020\u0001:\u0002\u00af\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\nJ\u0010\u00109\u001a\u00020\u00072\b\b\u0002\u0010:\u001a\u00020\nJ\u000e\u0010;\u001a\u00020\n2\u0006\u00109\u001a\u00020\u0007J\u0006\u0010<\u001a\u000207J\u0006\u0010=\u001a\u000207J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\nH\u0002J\b\u0010@\u001a\u000207H\u0002J\u0006\u0010A\u001a\u000207J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\nH\u0002J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\nH\u0002J \u0010D\u001a\u00020\n2\u0006\u00109\u001a\u00020\n2\u0006\u0010E\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010F\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0002J\u0010\u0010G\u001a\u00020\n2\u0006\u0010F\u001a\u00020\nH\u0002J(\u0010H\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010I\u001a\u00020\n2\u0006\u0010E\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010J\u001a\u00020\nJ\u0006\u0010K\u001a\u000207J\u000e\u0010L\u001a\u0002072\u0006\u00109\u001a\u00020\u0007J\u000e\u0010L\u001a\u0002072\u0006\u0010:\u001a\u00020\nJ \u0010M\u001a\u0002072\u0006\u0010#\u001a\u00020\n2\u0006\u0010J\u001a\u00020\n2\u0006\u0010N\u001a\u00020\nH\u0002JN\u0010O\u001a\u0002072\u0006\u0010?\u001a\u00020\n28\u0010P\u001a4\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(:\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(T\u0012\u0004\u0012\u0002070QH\u0086\b\u00f8\u0001\u0000J\u0010\u0010U\u001a\u0004\u0018\u00010\u00012\u0006\u0010:\u001a\u00020\nJ\u0010\u0010V\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0002J\u000e\u0010W\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\u0010\u0010X\u001a\u0004\u0018\u00010\u00012\u0006\u0010:\u001a\u00020\nJ\u000e\u0010Y\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010[J\u001a\u0010\\\u001a\u0002012\u0006\u0010#\u001a\u00020\n2\b\u0010]\u001a\u0004\u0018\u00010^H\u0002J\u0006\u0010_\u001a\u00020^J\u000e\u0010`\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\nJ\u0016\u0010a\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nJ\u000e\u0010b\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\nJ\u0010\u0010c\u001a\u0002072\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u0010\u0010e\u001a\u0002072\u0006\u0010'\u001a\u00020\nH\u0002J\u0018\u0010f\u001a\u0002072\u0006\u0010'\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nH\u0002J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\nJ\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020\n0hH\u0002J\u0010\u0010i\u001a\u0002072\b\b\u0002\u0010?\u001a\u00020\nJ \u0010j\u001a\u0002072\u0006\u0010k\u001a\u00020\n2\u0006\u0010l\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002J&\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00070h2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\n2\b\b\u0002\u0010n\u001a\u00020\u000eJ\u000e\u0010o\u001a\u0002072\u0006\u0010p\u001a\u00020\nJ\u0010\u0010q\u001a\u0002072\u0006\u0010:\u001a\u00020\nH\u0002J$\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00070h2\u0006\u0010p\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\nJ\u0018\u0010s\u001a\u0002072\u0006\u0010:\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nH\u0002J$\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00070h2\u0006\u00109\u001a\u00020\u00072\u0006\u0010p\u001a\u00020\n2\u0006\u0010u\u001a\u00020\u0000J\u0010\u0010v\u001a\u0004\u0018\u00010\u00012\u0006\u00109\u001a\u00020\u0007J\u0010\u0010v\u001a\u0004\u0018\u00010\u00012\u0006\u0010:\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\n2\u0006\u00109\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\u0010\u0010w\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0002J\u0018\u0010x\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nH\u0002J\b\u0010y\u001a\u000207H\u0002J\u000e\u0010z\u001a\u0002072\u0006\u0010]\u001a\u00020^J\u0006\u0010{\u001a\u000207J\u0016\u0010|\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\u0006\u0010d\u001a\u00020^J@\u0010~\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n2&\u0010/\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u000201\u0018\u000100j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u000201\u0018\u0001`2H\u0002J\u0006\u0010\u007f\u001a\u00020\u000eJ\u001b\u0010\u0080\u0001\u001a\u00020\u000e2\u0007\u0010\u0081\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\nH\u0002J#\u0010\u0083\u0001\u001a\u0002072\u0007\u0010\u0081\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nH\u0002J\u0007\u0010\u0084\u0001\u001a\u000207J\t\u0010\u0085\u0001\u001a\u00020\nH\u0002J\t\u0010\u0086\u0001\u001a\u000207H\u0002J\u000f\u0010\u0087\u0001\u001a\u0002072\u0006\u00109\u001a\u00020\u0007J\u0011\u0010\u0088\u0001\u001a\u0002072\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010:\u001a\u00020\n2\b\u0010d\u001a\u0004\u0018\u00010\u0001J#\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010?\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\b\u0010d\u001a\u0004\u0018\u00010\u0001J\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0001J\u0007\u0010\u008a\u0001\u001a\u00020\nJ\u0007\u0010\u008b\u0001\u001a\u000207J\u0019\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\nJ\u001a\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00012\u0007\u0010\u008d\u0001\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\u0013\u0010\u008e\u0001\u001a\u0004\u0018\u0001012\u0006\u0010?\u001a\u00020\nH\u0002J\u001a\u0010\u008f\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0001J%\u0010\u008f\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0001J\u0007\u0010\u0092\u0001\u001a\u000207J\u000f\u0010\u0092\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\nJ\u001a\u0010\u0092\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\t\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u0001J/\u0010\u0092\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u000e2\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0001H\u0002J\u001a\u0010\u0094\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u0001J$\u0010\u0094\u0001\u001a\u0002072\u0006\u0010}\u001a\u00020\n2\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010v\u001a\u0004\u0018\u00010\u0001J\t\u0010\u0095\u0001\u001a\u00020^H\u0016J\u0019\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u00072\u0006\u0010?\u001a\u00020\nH\u0000\u00a2\u0006\u0003\b\u0097\u0001J\u0013\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u0099\u0001\u001a\u0002072\u0007\u0010\u009a\u0001\u001a\u00020\n2\u0007\u0010\u009b\u0001\u001a\u00020\nH\u0002J\u0011\u0010\u009c\u0001\u001a\u0002072\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u0011\u0010\u009d\u0001\u001a\u0002072\u0006\u0010?\u001a\u00020\nH\u0002J\u001a\u0010\u009e\u0001\u001a\u0002072\u0006\u0010?\u001a\u00020\n2\u0007\u0010\u0088\u0001\u001a\u00020&H\u0002J\u0019\u0010\u009f\u0001\u001a\u0002072\u0006\u00109\u001a\u00020\u00072\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u0011\u0010\u009f\u0001\u001a\u0002072\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u00a0\u0001\u001a\u0002072\u0006\u0010:\u001a\u00020\n2\b\u0010d\u001a\u0004\u0018\u00010\u0001H\u0002J\u0011\u0010\u00a1\u0001\u001a\u0002072\b\u0010d\u001a\u0004\u0018\u00010\u0001J\u000f\u0010\u00a2\u0001\u001a\u000207H\u0000\u00a2\u0006\u0003\b\u00a3\u0001J\u000f\u0010\u00a4\u0001\u001a\u000207H\u0000\u00a2\u0006\u0003\b\u00a5\u0001J\u0016\u0010\u00a6\u0001\u001a\u00020\n*\u00020\u001d2\u0007\u0010\u00a7\u0001\u001a\u00020\nH\u0002J\u0015\u0010F\u001a\u00020\n*\u00020\u001d2\u0007\u0010\u00a7\u0001\u001a\u00020\nH\u0002J\u0013\u0010\u00a8\u0001\u001a\b\u0012\u0004\u0012\u00020\n0h*\u00020\u001dH\u0002J\u001b\u0010\u00a9\u0001\u001a\u000207*\b0\u00aa\u0001j\u0003`\u00ab\u00012\u0006\u0010:\u001a\u00020\nH\u0002J\u0016\u0010\u00ac\u0001\u001a\u00020\n*\u00020\u001d2\u0007\u0010\u00a7\u0001\u001a\u00020\nH\u0002J\u0014\u0010#\u001a\u00020\n*\u00020\u001d2\u0006\u0010:\u001a\u00020\nH\u0002J\u0016\u0010\u00ad\u0001\u001a\u00020\n*\u00020\u001d2\u0007\u0010\u00a7\u0001\u001a\u00020\nH\u0002J\u001e\u0010\u00ae\u0001\u001a\u000207*\u00020\u001d2\u0007\u0010\u00a7\u0001\u001a\u00020\n2\u0006\u0010F\u001a\u00020\nH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0011R\u000e\u0010!\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\fR\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\fR\u0018\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010*X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010/\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u000201\u0018\u000100j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u000201\u0018\u0001`2X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00b0\u0001"}, d2={"Landroidx/compose/runtime/SlotWriter;", "", "table", "Landroidx/compose/runtime/SlotTable;", "(Landroidx/compose/runtime/SlotTable;)V", "anchors", "Ljava/util/ArrayList;", "Landroidx/compose/runtime/Anchor;", "Lkotlin/collections/ArrayList;", "capacity", "", "getCapacity", "()I", "<set-?>", "", "closed", "getClosed", "()Z", "currentGroup", "getCurrentGroup", "currentGroupEnd", "getCurrentGroupEnd", "currentSlot", "currentSlotEnd", "endStack", "Landroidx/compose/runtime/IntStack;", "groupGapLen", "groupGapStart", "groups", "", "insertCount", "isGroupEnd", "isNode", "nodeCount", "nodeCountStack", "parent", "getParent", "pendingRecalculateMarks", "Landroidx/compose/runtime/PrioritySet;", "size", "getSize$runtime", "slots", "", "[Ljava/lang/Object;", "slotsGapLen", "slotsGapOwner", "slotsGapStart", "sourceInformationMap", "Ljava/util/HashMap;", "Landroidx/compose/runtime/GroupSourceInformation;", "Lkotlin/collections/HashMap;", "startStack", "getTable$runtime", "()Landroidx/compose/runtime/SlotTable;", "advanceBy", "", "amount", "anchor", "index", "anchorIndex", "bashCurrentGroup", "beginInsert", "childContainsAnyMarks", "group", "clearSlotGap", "close", "containsAnyGroupMarks", "containsGroupMark", "dataAnchorToDataIndex", "gapLen", "dataIndex", "dataIndexToDataAddress", "dataIndexToDataAnchor", "gapStart", "endGroup", "endInsert", "ensureStarted", "fixParentAnchorsFor", "firstChild", "forEachData", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "data", "groupAux", "groupIndexToAddress", "groupKey", "groupObjectKey", "groupSize", "groupSlots", "", "groupSourceInformationFor", "sourceInformation", "", "groupsAsString", "indexInCurrentGroup", "indexInGroup", "indexInParent", "insertAux", "value", "insertGroups", "insertSlots", "keys", "", "markGroup", "moveAnchors", "originalLocation", "newLocation", "moveFrom", "removeSourceGroup", "moveGroup", "offset", "moveGroupGapTo", "moveIntoGroupFrom", "moveSlotGapTo", "moveTo", "writer", "node", "parentAnchorToIndex", "parentIndexToAnchor", "recalculateMarks", "recordGroupSourceInformation", "recordGrouplessCallSourceInformationEnd", "recordGrouplessCallSourceInformationStart", "key", "removeAnchors", "removeGroup", "removeGroups", "start", "len", "removeSlots", "reset", "restoreCurrentGroupEnd", "saveCurrentGroupEnd", "seek", "set", "skip", "skipGroup", "skipToGroupEnd", "slot", "groupIndex", "sourceInformationOf", "startData", "aux", "objectKey", "startGroup", "dataKey", "startNode", "toString", "tryAnchor", "tryAnchor$runtime", "update", "updateAnchors", "previousGapStart", "newGapStart", "updateAux", "updateContainsMark", "updateContainsMarkNow", "updateNode", "updateNodeOfGroup", "updateParentNode", "verifyDataAnchors", "verifyDataAnchors$runtime", "verifyParentAnchors", "verifyParentAnchors$runtime", "auxIndex", "address", "dataIndexes", "groupAsString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nodeIndex", "slotIndex", "updateDataIndex", "Companion", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n+ 6 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 7 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,3747:1\n4179#2,5:3748\n4179#2,5:3753\n4179#2,5:3758\n4179#2,5:3763\n4179#2,5:3776\n4179#2,5:3781\n4179#2,5:3786\n4179#2,5:3791\n4179#2,5:3796\n4179#2,5:3801\n4179#2,5:3806\n4179#2,5:3811\n4179#2,5:3816\n4179#2,5:3821\n4179#2,5:3826\n4179#2,5:3831\n4179#2,5:3836\n4179#2,5:3841\n4179#2,5:3868\n4179#2,5:3873\n4179#2,5:3878\n1#3:3768\n372#4,7:3769\n168#5,8:3846\n168#5,8:3854\n3618#6,6:3862\n33#7,6:3883\n82#7,3:3889\n33#7,4:3892\n85#7,2:3896\n38#7:3898\n87#7:3899\n231#7,3:3900\n64#7,4:3903\n234#7,2:3907\n69#7:3909\n236#7:3910\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter\n*L\n1528#1:3748,5\n1552#1:3753,5\n1565#1:3758,5\n1568#1:3763,5\n1651#1:3776,5\n1672#1:3781,5\n1719#1:3786,5\n1724#1:3791,5\n1764#1:3796,5\n1775#1:3801,5\n1905#1:3806,5\n1969#1:3811,5\n1974#1:3816,5\n2006#1:3821,5\n2066#1:3826,5\n2067#1:3831,5\n2080#1:3836,5\n2174#1:3841,5\n2737#1:3868,5\n2749#1:3873,5\n2959#1:3878,5\n1613#1:3769,7\n2481#1:3846,8\n2522#1:3854,8\n2542#1:3862,6\n3060#1:3883,6\n3230#1:3889,3\n3230#1:3892,4\n3230#1:3896,2\n3230#1:3898\n3230#1:3899\n3233#1:3900,3\n3233#1:3903,4\n3233#1:3907,2\n3233#1:3909\n3233#1:3910\n*E\n"})
public final class SlotWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SlotTable table;
    @NotNull
    private int[] groups;
    @NotNull
    private Object[] slots;
    @NotNull
    private ArrayList<Anchor> anchors;
    @Nullable
    private HashMap<Anchor, GroupSourceInformation> sourceInformationMap;
    private int groupGapStart;
    private int groupGapLen;
    private int currentSlot;
    private int currentSlotEnd;
    private int slotsGapStart;
    private int slotsGapLen;
    private int slotsGapOwner;
    private int insertCount;
    private int nodeCount;
    @NotNull
    private final IntStack startStack;
    @NotNull
    private final IntStack endStack;
    @NotNull
    private final IntStack nodeCountStack;
    private int currentGroup;
    private int currentGroupEnd;
    private int parent;
    private boolean closed;
    @Nullable
    private PrioritySet pendingRecalculateMarks;
    public static final int $stable = 8;

    public SlotWriter(@NotNull SlotTable table) {
        Intrinsics.checkNotNullParameter(table, "table");
        this.table = table;
        this.groups = this.table.getGroups();
        this.slots = this.table.getSlots();
        this.anchors = this.table.getAnchors$runtime();
        this.sourceInformationMap = this.table.getSourceInformationMap$runtime();
        this.groupGapStart = this.table.getGroupsSize();
        this.groupGapLen = this.groups.length / 5 - this.table.getGroupsSize();
        this.slotsGapStart = this.table.getSlotsSize();
        this.slotsGapLen = this.slots.length - this.table.getSlotsSize();
        this.slotsGapOwner = this.table.getGroupsSize();
        this.startStack = new IntStack();
        this.endStack = new IntStack();
        this.nodeCountStack = new IntStack();
        this.currentGroupEnd = this.table.getGroupsSize();
        this.parent = -1;
    }

    @NotNull
    public final SlotTable getTable$runtime() {
        return this.table;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getCurrentGroupEnd() {
        return this.currentGroupEnd;
    }

    public final boolean isGroupEnd() {
        return this.currentGroup == this.currentGroupEnd;
    }

    public final boolean isNode() {
        return this.currentGroup < this.currentGroupEnd && SlotTableKt.access$isNode(this.groups, this.groupIndexToAddress(this.currentGroup));
    }

    public final boolean isNode(int index2) {
        return SlotTableKt.access$isNode(this.groups, this.groupIndexToAddress(index2));
    }

    public final int nodeCount(int index2) {
        return SlotTableKt.access$nodeCount(this.groups, this.groupIndexToAddress(index2));
    }

    public final int groupKey(int index2) {
        return SlotTableKt.access$key(this.groups, this.groupIndexToAddress(index2));
    }

    @Nullable
    public final Object groupObjectKey(int index2) {
        int address = this.groupIndexToAddress(index2);
        return SlotTableKt.access$hasObjectKey(this.groups, address) ? this.slots[SlotTableKt.access$objectKeyIndex(this.groups, address)] : null;
    }

    public final int groupSize(int index2) {
        return SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(index2));
    }

    @Nullable
    public final Object groupAux(int index2) {
        int address = this.groupIndexToAddress(index2);
        return SlotTableKt.access$hasAux(this.groups, address) ? this.slots[this.auxIndex(this.groups, address)] : Composer.Companion.getEmpty();
    }

    public final boolean indexInParent(int index2) {
        return index2 > this.parent && index2 < this.currentGroupEnd || this.parent == 0 && index2 == 0;
    }

    public final boolean indexInCurrentGroup(int index2) {
        return this.indexInGroup(index2, this.currentGroup);
    }

    public final boolean indexInGroup(int index2, int group) {
        int n;
        if (group == this.parent) {
            n = this.currentGroupEnd;
        } else if (group > this.startStack.peekOr(0)) {
            n = group + this.groupSize(group);
        } else {
            int openIndex = this.startStack.indexOf(group);
            n = openIndex < 0 ? group + this.groupSize(group) : this.getCapacity() - this.groupGapLen - this.endStack.peek(openIndex);
        }
        int end2 = n;
        return index2 > group && index2 < end2;
    }

    @Nullable
    public final Object node(int index2) {
        int address = this.groupIndexToAddress(index2);
        return SlotTableKt.access$isNode(this.groups, address) ? this.slots[this.dataIndexToDataAddress(this.nodeIndex(this.groups, address))] : null;
    }

    @Nullable
    public final Object node(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        return this.node(anchor.toIndexFor(this));
    }

    public final int getParent() {
        return this.parent;
    }

    public final int parent(int index2) {
        return this.parent(this.groups, index2);
    }

    public final int parent(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        return anchor.getValid() ? this.parent(this.groups, this.anchorIndex(anchor)) : -1;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void close() {
        this.closed = true;
        if (this.startStack.isEmpty()) {
            this.moveGroupGapTo(this.getSize$runtime());
            this.moveSlotGapTo(this.slots.length - this.slotsGapLen, this.groupGapStart);
            this.clearSlotGap();
            this.recalculateMarks();
        }
        this.table.close$runtime(this, this.groups, this.groupGapStart, this.slots, this.slotsGapStart, this.anchors, this.sourceInformationMap);
    }

    public final void reset() {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot reset when inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.recalculateMarks();
        this.currentGroup = 0;
        this.currentGroupEnd = this.getCapacity() - this.groupGapLen;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
        this.nodeCount = 0;
    }

    @Nullable
    public final Object update(@Nullable Object value) {
        Object result2 = this.skip();
        this.set(value);
        return result2;
    }

    public final void updateAux(@Nullable Object value) {
        int address = this.groupIndexToAddress(this.currentGroup);
        boolean value$iv = SlotTableKt.access$hasAux(this.groups, address);
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Updating the data of a group that was not created with a data slot";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.slots[this.dataIndexToDataAddress((int)this.auxIndex((int[])this.groups, (int)address))] = value;
    }

    public final void insertAux(@Nullable Object value) {
        boolean value$iv = this.insertCount >= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot insert auxiliary data when not inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int parent2 = this.parent;
        int parentGroupAddress = this.groupIndexToAddress(parent2);
        boolean value$iv2 = !SlotTableKt.access$hasAux(this.groups, parentGroupAddress);
        boolean $i$f$runtimeCheck2 = false;
        if (!value$iv2) {
            boolean bl = false;
            String message$iv = "Group already has auxiliary data";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.insertSlots(1, parent2);
        int auxIndex = this.auxIndex(this.groups, parentGroupAddress);
        int auxAddress = this.dataIndexToDataAddress(auxIndex);
        if (this.currentSlot > auxIndex) {
            int slotsToMove = this.currentSlot - auxIndex;
            if (!(slotsToMove < 3)) {
                boolean bl = false;
                String string = "Moving more than two slot not supported";
                throw new IllegalStateException(string.toString());
            }
            if (slotsToMove > 1) {
                this.slots[auxAddress + 2] = this.slots[auxAddress + 1];
            }
            this.slots[auxAddress + 1] = this.slots[auxAddress];
        }
        SlotTableKt.access$addAux(this.groups, parentGroupAddress);
        this.slots[auxAddress] = value;
        int n = this.currentSlot;
        this.currentSlot = n + 1;
    }

    public final void recordGroupSourceInformation(@NotNull String sourceInformation) {
        Intrinsics.checkNotNullParameter(sourceInformation, "sourceInformation");
        if (this.insertCount > 0) {
            this.groupSourceInformationFor(this.parent, sourceInformation);
        }
    }

    public final void recordGrouplessCallSourceInformationStart(int key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.insertCount > 0) {
            this.groupSourceInformationFor(this.parent, null).startGrouplessCall(key, value);
        }
    }

    public final void recordGrouplessCallSourceInformationEnd() {
        if (this.insertCount > 0) {
            this.groupSourceInformationFor(this.parent, null).endGrouplessCall();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final GroupSourceInformation groupSourceInformationFor(int parent2, String sourceInformation) {
        Object object;
        void $this$getOrPut$iv;
        HashMap hashMap = this.sourceInformationMap;
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HashMap map2 = hashMap;
        this.sourceInformationMap = map2;
        Map map3 = map2;
        Anchor key$iv = this.anchor(parent2);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            GroupSourceInformation result2 = new GroupSourceInformation(0, sourceInformation);
            if (sourceInformation == null) {
                int end2 = this.currentGroup;
                for (int child2 = parent2 + 1; child2 < end2; child2 += SlotTableKt.access$groupSize(this.groups, child2)) {
                    result2.reportGroup(this, child2);
                }
            }
            GroupSourceInformation answer$iv = result2;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (GroupSourceInformation)object;
    }

    public final void updateNode(@Nullable Object value) {
        this.updateNodeOfGroup(this.currentGroup, value);
    }

    public final void updateNode(@NotNull Anchor anchor, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.updateNodeOfGroup(anchor.toIndexFor(this), value);
    }

    public final void updateParentNode(@Nullable Object value) {
        this.updateNodeOfGroup(this.parent, value);
    }

    public final void set(@Nullable Object value) {
        boolean value$iv = this.currentSlot <= this.currentSlotEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Writing to an invalid slot";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.slots[this.dataIndexToDataAddress((int)(this.currentSlot - 1))] = value;
    }

    @Nullable
    public final Object set(int index2, @Nullable Object value) {
        return this.set(this.currentGroup, index2, value);
    }

    @Nullable
    public final Object set(int group, int index2, @Nullable Object value) {
        int address = this.groupIndexToAddress(group);
        int slotsStart = this.slotIndex(this.groups, address);
        int slotsEnd = this.dataIndex(this.groups, this.groupIndexToAddress(group + 1));
        int slotsIndex = slotsStart + index2;
        boolean value$iv = slotsIndex >= slotsStart && slotsIndex < slotsEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Write to an invalid slot index " + index2 + " for group " + group;
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int slotAddress = this.dataIndexToDataAddress(slotsIndex);
        Object result2 = this.slots[slotAddress];
        this.slots[slotAddress] = value;
        return result2;
    }

    @Nullable
    public final Object skip() {
        if (this.insertCount > 0) {
            this.insertSlots(1, this.parent);
        }
        int n = this.currentSlot;
        this.currentSlot = n + 1;
        return this.slots[this.dataIndexToDataAddress(n)];
    }

    @Nullable
    public final Object slot(@NotNull Anchor anchor, int index2) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        return this.slot(this.anchorIndex(anchor), index2);
    }

    @Nullable
    public final Object slot(int groupIndex, int index2) {
        int address = this.groupIndexToAddress(groupIndex);
        int slotsStart = this.slotIndex(this.groups, address);
        int slotsEnd = this.dataIndex(this.groups, this.groupIndexToAddress(groupIndex + 1));
        int slotsIndex = slotsStart + index2;
        if (!(slotsStart <= slotsIndex ? slotsIndex < slotsEnd : false)) {
            return Composer.Companion.getEmpty();
        }
        int slotAddress = this.dataIndexToDataAddress(slotsIndex);
        return this.slots[slotAddress];
    }

    public final void advanceBy(int amount) {
        int newSlot;
        boolean value$iv = amount >= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot seek backwards";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (!(this.insertCount <= 0)) {
            boolean $i$a$-check-SlotWriter$advanceBy$32 = false;
            String $i$a$-check-SlotWriter$advanceBy$32 = "Cannot call seek() while inserting";
            throw new IllegalStateException($i$a$-check-SlotWriter$advanceBy$32.toString());
        }
        if (amount == 0) {
            return;
        }
        int index2 = this.currentGroup + amount;
        boolean value$iv2 = index2 >= this.parent && index2 <= this.currentGroupEnd;
        boolean $i$f$runtimeCheck2 = false;
        if (!value$iv2) {
            boolean bl = false;
            String message$iv = "Cannot seek outside the current group (" + this.parent + '-' + this.currentGroupEnd + ')';
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.currentGroup = index2;
        this.currentSlot = newSlot = this.dataIndex(this.groups, this.groupIndexToAddress(index2));
        this.currentSlotEnd = newSlot;
    }

    public final void seek(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.advanceBy(anchor.toIndexFor(this) - this.currentGroup);
    }

    public final void skipToGroupEnd() {
        int newGroup;
        this.currentGroup = newGroup = this.currentGroupEnd;
        this.currentSlot = this.dataIndex(this.groups, this.groupIndexToAddress(newGroup));
    }

    public final void beginInsert() {
        int n = this.insertCount;
        this.insertCount = n + 1;
        if (n == 0) {
            this.saveCurrentGroupEnd();
        }
    }

    public final void endInsert() {
        if (!(this.insertCount > 0)) {
            boolean $i$a$-check-SlotWriter$endInsert$22 = false;
            String $i$a$-check-SlotWriter$endInsert$22 = "Unbalanced begin/end insert";
            throw new IllegalStateException($i$a$-check-SlotWriter$endInsert$22.toString());
        }
        this.insertCount += -1;
        if (this.insertCount == 0) {
            boolean value$iv = this.nodeCountStack.getSize() == this.startStack.getSize();
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "startGroup/endGroup mismatch while inserting";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            this.restoreCurrentGroupEnd();
        }
    }

    public final void startGroup() {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Key must be supplied when inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.startGroup(0, Composer.Companion.getEmpty(), false, Composer.Companion.getEmpty());
    }

    public final void startGroup(int key) {
        this.startGroup(key, Composer.Companion.getEmpty(), false, Composer.Companion.getEmpty());
    }

    public final void startGroup(int key, @Nullable Object dataKey) {
        this.startGroup(key, dataKey, false, Composer.Companion.getEmpty());
    }

    public final void startNode(int key, @Nullable Object objectKey) {
        this.startGroup(key, objectKey, true, Composer.Companion.getEmpty());
    }

    public final void startNode(int key, @Nullable Object objectKey, @Nullable Object node2) {
        this.startGroup(key, objectKey, true, node2);
    }

    public final void startData(int key, @Nullable Object objectKey, @Nullable Object aux) {
        this.startGroup(key, objectKey, false, aux);
    }

    public final void startData(int key, @Nullable Object aux) {
        this.startGroup(key, Composer.Companion.getEmpty(), false, aux);
    }

    private final void startGroup(int key, Object objectKey, boolean isNode, Object aux) {
        int n;
        int previousParent = this.parent;
        boolean inserting = this.insertCount > 0;
        this.nodeCountStack.push(this.nodeCount);
        if (inserting) {
            this.insertGroups(1);
            int current = this.currentGroup;
            int currentAddress = this.groupIndexToAddress(current);
            boolean hasObjectKey = objectKey != Composer.Companion.getEmpty();
            boolean hasAux = !isNode && aux != Composer.Companion.getEmpty();
            SlotTableKt.access$initGroup(this.groups, currentAddress, key, isNode, hasObjectKey, hasAux, this.parent, this.currentSlot);
            this.currentSlotEnd = this.currentSlot;
            int dataSlotsNeeded = (isNode ? 1 : 0) + (hasObjectKey ? 1 : 0) + (hasAux ? 1 : 0);
            if (dataSlotsNeeded > 0) {
                this.insertSlots(dataSlotsNeeded, current);
                Object[] slots = this.slots;
                int currentSlot = this.currentSlot;
                if (isNode) {
                    slots[currentSlot++] = aux;
                }
                if (hasObjectKey) {
                    slots[currentSlot++] = objectKey;
                }
                if (hasAux) {
                    slots[currentSlot++] = aux;
                }
                this.currentSlot = currentSlot;
            }
            this.nodeCount = 0;
            int newCurrent = current + 1;
            this.parent = current;
            this.currentGroup = newCurrent;
            if (previousParent >= 0) {
                GroupSourceInformation groupSourceInformation = this.sourceInformationOf(previousParent);
                if (groupSourceInformation != null) {
                    groupSourceInformation.reportGroup(this, current);
                }
            }
            n = newCurrent;
        } else {
            this.startStack.push(previousParent);
            this.saveCurrentGroupEnd();
            int currentGroup = this.currentGroup;
            int currentGroupAddress = this.groupIndexToAddress(currentGroup);
            if (!Intrinsics.areEqual(aux, Composer.Companion.getEmpty())) {
                if (isNode) {
                    this.updateNode(aux);
                } else {
                    this.updateAux(aux);
                }
            }
            this.currentSlot = this.slotIndex(this.groups, currentGroupAddress);
            this.currentSlotEnd = this.dataIndex(this.groups, this.groupIndexToAddress(this.currentGroup + 1));
            this.nodeCount = SlotTableKt.access$nodeCount(this.groups, currentGroupAddress);
            this.parent = currentGroup;
            this.currentGroup = currentGroup + 1;
            n = currentGroup + SlotTableKt.access$groupSize(this.groups, currentGroupAddress);
        }
        this.currentGroupEnd = n;
    }

    public final int endGroup() {
        boolean inserting = this.insertCount > 0;
        int currentGroup = this.currentGroup;
        int currentGroupEnd = this.currentGroupEnd;
        int groupIndex = this.parent;
        int groupAddress = this.groupIndexToAddress(groupIndex);
        int newNodes = this.nodeCount;
        int newGroupSize = currentGroup - groupIndex;
        boolean isNode = SlotTableKt.access$isNode(this.groups, groupAddress);
        if (inserting) {
            SlotTableKt.access$updateGroupSize(this.groups, groupAddress, newGroupSize);
            SlotTableKt.access$updateNodeCount(this.groups, groupAddress, newNodes);
            this.nodeCount = this.nodeCountStack.pop() + (isNode ? 1 : newNodes);
            this.parent = this.parent(this.groups, groupIndex);
        } else {
            boolean value$iv = currentGroup == currentGroupEnd;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "Expected to be at the end of a group";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            int oldGroupSize = SlotTableKt.access$groupSize(this.groups, groupAddress);
            int oldNodes = SlotTableKt.access$nodeCount(this.groups, groupAddress);
            SlotTableKt.access$updateGroupSize(this.groups, groupAddress, newGroupSize);
            SlotTableKt.access$updateNodeCount(this.groups, groupAddress, newNodes);
            int newParent = this.startStack.pop();
            this.restoreCurrentGroupEnd();
            this.parent = newParent;
            int groupParent = this.parent(this.groups, groupIndex);
            this.nodeCount = this.nodeCountStack.pop();
            if (groupParent == newParent) {
                this.nodeCount += isNode ? 0 : newNodes - oldNodes;
            } else {
                int nodesDelta;
                int groupSizeDelta = newGroupSize - oldGroupSize;
                int n = nodesDelta = isNode ? 0 : newNodes - oldNodes;
                if (groupSizeDelta != 0 || nodesDelta != 0) {
                    int current = groupParent;
                    while (current != 0 && current != newParent && (nodesDelta != 0 || groupSizeDelta != 0)) {
                        int currentAddress = this.groupIndexToAddress(current);
                        if (groupSizeDelta != 0) {
                            int newSize = SlotTableKt.access$groupSize(this.groups, currentAddress) + groupSizeDelta;
                            SlotTableKt.access$updateGroupSize(this.groups, currentAddress, newSize);
                        }
                        if (nodesDelta != 0) {
                            SlotTableKt.access$updateNodeCount(this.groups, currentAddress, SlotTableKt.access$nodeCount(this.groups, currentAddress) + nodesDelta);
                        }
                        if (SlotTableKt.access$isNode(this.groups, currentAddress)) {
                            nodesDelta = 0;
                        }
                        current = this.parent(this.groups, current);
                    }
                }
                this.nodeCount += nodesDelta;
            }
        }
        return newNodes;
    }

    public final void ensureStarted(int index2) {
        boolean value$iv = this.insertCount <= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot call ensureStarted() while inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int parent2 = this.parent;
        if (parent2 != index2) {
            boolean value$iv2 = index2 >= parent2 && index2 < this.currentGroupEnd;
            boolean $i$f$runtimeCheck2 = false;
            if (!value$iv2) {
                boolean bl = false;
                String message$iv = "Started group at " + index2 + " must be a subgroup of the group at " + parent2;
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            int oldCurrent = this.currentGroup;
            int oldCurrentSlot = this.currentSlot;
            int oldCurrentSlotEnd = this.currentSlotEnd;
            this.currentGroup = index2;
            this.startGroup();
            this.currentGroup = oldCurrent;
            this.currentSlot = oldCurrentSlot;
            this.currentSlotEnd = oldCurrentSlotEnd;
        }
    }

    public final void ensureStarted(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        this.ensureStarted(anchor.toIndexFor(this));
    }

    public final int skipGroup() {
        int newGroup;
        int groupAddress = this.groupIndexToAddress(this.currentGroup);
        this.currentGroup = newGroup = this.currentGroup + SlotTableKt.access$groupSize(this.groups, groupAddress);
        this.currentSlot = this.dataIndex(this.groups, this.groupIndexToAddress(newGroup));
        return SlotTableKt.access$isNode(this.groups, groupAddress) ? 1 : SlotTableKt.access$nodeCount(this.groups, groupAddress);
    }

    public final boolean removeGroup() {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot remove group while inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int oldGroup = this.currentGroup;
        int oldSlot = this.currentSlot;
        int count2 = this.skipGroup();
        GroupSourceInformation groupSourceInformation = this.sourceInformationOf(this.parent);
        if (groupSourceInformation != null) {
            GroupSourceInformation sourceInformation = groupSourceInformation;
            boolean bl = false;
            Anchor anchor = this.tryAnchor$runtime(oldGroup);
            if (anchor != null) {
                Anchor anchor2 = anchor;
                boolean bl2 = false;
                sourceInformation.removeAnchor(anchor2);
            }
        }
        PrioritySet prioritySet = this.pendingRecalculateMarks;
        if (prioritySet != null) {
            PrioritySet it = prioritySet;
            boolean bl = false;
            while (it.isNotEmpty() && it.peek() >= oldGroup) {
                it.takeMax();
            }
        }
        boolean anchorsRemoved = this.removeGroups(oldGroup, this.currentGroup - oldGroup);
        this.removeSlots(oldSlot, this.currentSlot - oldSlot, oldGroup - 1);
        this.currentGroup = oldGroup;
        this.currentSlot = oldSlot;
        this.nodeCount -= count2;
        return anchorsRemoved;
    }

    @NotNull
    public final Iterator<Object> groupSlots() {
        int start2 = this.dataIndex(this.groups, this.groupIndexToAddress(this.currentGroup));
        int end2 = this.dataIndex(this.groups, this.groupIndexToAddress(this.currentGroup + this.groupSize(this.currentGroup)));
        return new Iterator<Object>(start2, end2, this){
            private int current;
            final /* synthetic */ int $end;
            final /* synthetic */ SlotWriter this$0;
            {
                this.$end = $end;
                this.this$0 = $receiver;
                this.current = $start;
            }

            public final int getCurrent() {
                return this.current;
            }

            public final void setCurrent(int n) {
                this.current = n;
            }

            public boolean hasNext() {
                return this.current < this.$end;
            }

            @Nullable
            public Object next() {
                Object object;
                if (this.hasNext()) {
                    int n = this.current;
                    this.current = n + 1;
                    object = SlotWriter.access$getSlots$p(this.this$0)[SlotWriter.access$dataIndexToDataAddress(this.this$0, n)];
                } else {
                    object = null;
                }
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void forEachData(int group, @NotNull Function2<? super Integer, Object, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachData = false;
        int address = this.groupIndexToAddress(group);
        int slotsStart = this.slotIndex(this.groups, address);
        int slotsEnd = this.dataIndex(this.groups, this.groupIndexToAddress(group + 1));
        for (int slot = slotsStart; slot < slotsEnd; ++slot) {
            block2.invoke((Integer)(slot - slotsStart), this.slots[this.dataIndexToDataAddress(slot)]);
        }
    }

    public final void moveGroup(int offset2) {
        boolean value$iv = this.insertCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot move a group while inserting";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        value$iv = offset2 >= 0;
        $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Parameter offset is out of bounds";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        if (offset2 == 0) {
            return;
        }
        int current = this.currentGroup;
        int parent2 = this.parent;
        int parentEnd = this.currentGroupEnd;
        int groupToMove = current;
        for (int count2 = offset2; count2 > 0; --count2) {
            boolean value$iv2 = (groupToMove += SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(groupToMove))) <= parentEnd;
            boolean $i$f$runtimeCheck2 = false;
            if (value$iv2) continue;
            boolean bl = false;
            String message$iv = "Parameter offset is out of bounds";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        int moveLen = SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(groupToMove));
        int currentSlot = this.currentSlot;
        int dataStart = this.dataIndex(this.groups, this.groupIndexToAddress(groupToMove));
        int dataEnd = this.dataIndex(this.groups, this.groupIndexToAddress(groupToMove + moveLen));
        int moveDataLen = dataEnd - dataStart;
        this.insertSlots(moveDataLen, Math.max(this.currentGroup - 1, 0));
        this.insertGroups(moveLen);
        int[] groups2 = this.groups;
        int moveLocationAddress = this.groupIndexToAddress(groupToMove + moveLen);
        int moveLocationOffset = moveLocationAddress * 5;
        int currentAddress = this.groupIndexToAddress(current);
        ArraysKt.copyInto(groups2, groups2, currentAddress * 5, moveLocationOffset, moveLocationOffset + moveLen * 5);
        if (moveDataLen > 0) {
            Object[] slots = this.slots;
            ArraysKt.copyInto(slots, slots, currentSlot, this.dataIndexToDataAddress(dataStart + moveDataLen), this.dataIndexToDataAddress(dataEnd + moveDataLen));
        }
        int dataMoveDistance = dataStart + moveDataLen - currentSlot;
        int slotsGapStart = this.slotsGapStart;
        int slotsGapLen = this.slotsGapLen;
        int slotsCapacity = this.slots.length;
        int slotsGapOwner = this.slotsGapOwner;
        int n = current + moveLen;
        for (int group = current; group < n; ++group) {
            int groupAddress = this.groupIndexToAddress(group);
            int oldIndex = this.dataIndex(groups2, groupAddress);
            int newIndex = oldIndex - dataMoveDistance;
            int newAnchor = this.dataIndexToDataAnchor(newIndex, slotsGapOwner < groupAddress ? 0 : slotsGapStart, slotsGapLen, slotsCapacity);
            this.updateDataIndex(groups2, groupAddress, newAnchor);
        }
        this.moveAnchors(groupToMove + moveLen, current, moveLen);
        boolean anchorsRemoved = this.removeGroups(groupToMove + moveLen, moveLen);
        boolean value$iv3 = !anchorsRemoved;
        boolean $i$f$runtimeCheck3 = false;
        if (!value$iv3) {
            boolean bl = false;
            String message$iv = "Unexpectedly removed anchors";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.fixParentAnchorsFor(parent2, this.currentGroupEnd, current);
        if (moveDataLen > 0) {
            this.removeSlots(dataStart + moveDataLen, moveDataLen, groupToMove + moveLen - 1);
        }
    }

    @NotNull
    public final List<Anchor> moveTo(@NotNull Anchor anchor, int offset2, @NotNull SlotWriter writer) {
        boolean updatingNodes;
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        Intrinsics.checkNotNullParameter(writer, "writer");
        ComposerKt.runtimeCheck(writer.insertCount > 0);
        ComposerKt.runtimeCheck(this.insertCount == 0);
        ComposerKt.runtimeCheck(anchor.getValid());
        int location = this.anchorIndex(anchor) + offset2;
        int currentGroup = this.currentGroup;
        ComposerKt.runtimeCheck(currentGroup <= location ? location < this.currentGroupEnd : false);
        int parent2 = this.parent(location);
        int size2 = this.groupSize(location);
        int nodes = this.isNode(location) ? 1 : this.nodeCount(location);
        List result2 = androidx.compose.runtime.SlotWriter$Companion.moveGroup$default(Companion, this, location, writer, false, false, false, 32, null);
        this.updateContainsMark(parent2);
        int current = parent2;
        boolean bl = updatingNodes = nodes > 0;
        while (current >= currentGroup) {
            int currentAddress = this.groupIndexToAddress(current);
            SlotTableKt.access$updateGroupSize(this.groups, currentAddress, SlotTableKt.access$groupSize(this.groups, currentAddress) - size2);
            if (updatingNodes) {
                if (SlotTableKt.access$isNode(this.groups, currentAddress)) {
                    updatingNodes = false;
                } else {
                    SlotTableKt.access$updateNodeCount(this.groups, currentAddress, SlotTableKt.access$nodeCount(this.groups, currentAddress) - nodes);
                }
            }
            current = this.parent(current);
        }
        if (updatingNodes) {
            ComposerKt.runtimeCheck(this.nodeCount >= nodes);
            this.nodeCount -= nodes;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Anchor> moveFrom(@NotNull SlotTable table, int index2, boolean removeSourceGroup) {
        List list2;
        Intrinsics.checkNotNullParameter(table, "table");
        ComposerKt.runtimeCheck(this.insertCount > 0);
        if (index2 == 0 && this.currentGroup == 0 && this.table.getGroupsSize() == 0 && SlotTableKt.access$groupSize(table.getGroups(), index2) == table.getGroupsSize()) {
            int[] myGroups = this.groups;
            Object[] mySlots = this.slots;
            ArrayList<Anchor> myAnchors = this.anchors;
            HashMap<Anchor, GroupSourceInformation> mySourceInformation = this.sourceInformationMap;
            int[] groups2 = table.getGroups();
            int groupsSize = table.getGroupsSize();
            Object[] slots = table.getSlots();
            int slotsSize = table.getSlotsSize();
            HashMap<Anchor, GroupSourceInformation> sourceInformation = table.getSourceInformationMap$runtime();
            this.groups = groups2;
            this.slots = slots;
            this.anchors = table.getAnchors$runtime();
            this.groupGapStart = groupsSize;
            this.groupGapLen = groups2.length / 5 - groupsSize;
            this.slotsGapStart = slotsSize;
            this.slotsGapLen = slots.length - slotsSize;
            this.slotsGapOwner = groupsSize;
            this.sourceInformationMap = sourceInformation;
            table.setTo$runtime(myGroups, 0, mySlots, 0, myAnchors, mySourceInformation);
            return this.anchors;
        }
        SlotTable this_$iv = table;
        boolean $i$f$write = false;
        boolean bl = false;
        try (SlotWriter writer$iv = this_$iv.openWriter();){
            SlotWriter tableWriter = writer$iv;
            boolean bl2 = false;
            list2 = SlotWriter.Companion.moveGroup(tableWriter, index2, this, true, true, removeSourceGroup);
        }
        return list2;
    }

    public static /* synthetic */ List moveFrom$default(SlotWriter slotWriter, SlotTable slotTable, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return slotWriter.moveFrom(slotTable, n, bl);
    }

    public final void bashCurrentGroup() {
        SlotTableKt.access$updateGroupKey(this.groups, this.currentGroup, -3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Anchor> moveIntoGroupFrom(int offset2, @NotNull SlotTable table, int index2) {
        List list2;
        Intrinsics.checkNotNullParameter(table, "table");
        ComposerKt.runtimeCheck(this.insertCount <= 0 && this.groupSize(this.currentGroup + offset2) == 1);
        int previousCurrentGroup = this.currentGroup;
        int previousCurrentSlot = this.currentSlot;
        int previousCurrentSlotEnd = this.currentSlotEnd;
        this.advanceBy(offset2);
        this.startGroup();
        this.beginInsert();
        SlotTable this_$iv = table;
        boolean $i$f$write = false;
        boolean bl = false;
        try (SlotWriter writer$iv = this_$iv.openWriter();){
            SlotWriter tableWriter = writer$iv;
            boolean bl2 = false;
            list2 = androidx.compose.runtime.SlotWriter$Companion.moveGroup$default(Companion, tableWriter, index2, this, false, true, false, 32, null);
        }
        List anchors2 = list2;
        this.endInsert();
        this.endGroup();
        this.currentGroup = previousCurrentGroup;
        this.currentSlot = previousCurrentSlot;
        this.currentSlotEnd = previousCurrentSlotEnd;
        return anchors2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index2) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        ArrayList<Anchor> arrayList = this.anchors;
        int effectiveSize$iv = this.getSize$runtime();
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index2, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index2 <= this.groupGapStart ? index2 : -(this.getSize$runtime() - index2));
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            Object e = $this$getOrAdd$iv.get(location$iv);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    public static /* synthetic */ Anchor anchor$default(SlotWriter slotWriter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotWriter.currentGroup;
        }
        return slotWriter.anchor(n);
    }

    public final void markGroup(int group) {
        int groupAddress = this.groupIndexToAddress(group);
        if (!SlotTableKt.access$hasMark(this.groups, groupAddress)) {
            SlotTableKt.access$updateMark(this.groups, groupAddress, true);
            if (!SlotTableKt.access$containsMark(this.groups, groupAddress)) {
                this.updateContainsMark(this.parent(group));
            }
        }
    }

    public static /* synthetic */ void markGroup$default(SlotWriter slotWriter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotWriter.parent;
        }
        slotWriter.markGroup(n);
    }

    private final boolean containsGroupMark(int group) {
        return group >= 0 && SlotTableKt.access$containsMark(this.groups, this.groupIndexToAddress(group));
    }

    private final boolean containsAnyGroupMarks(int group) {
        return group >= 0 && SlotTableKt.access$containsAnyMark(this.groups, this.groupIndexToAddress(group));
    }

    private final void recalculateMarks() {
        block1: {
            PrioritySet prioritySet = this.pendingRecalculateMarks;
            if (prioritySet == null) break block1;
            PrioritySet set = prioritySet;
            boolean bl = false;
            while (set.isNotEmpty()) {
                this.updateContainsMarkNow(set.takeMax(), set);
            }
        }
    }

    private final void updateContainsMark(int group) {
        if (group >= 0) {
            PrioritySet prioritySet = this.pendingRecalculateMarks;
            if (prioritySet == null) {
                PrioritySet prioritySet2;
                PrioritySet it = prioritySet2 = new PrioritySet(null, 1, null);
                boolean bl = false;
                this.pendingRecalculateMarks = it;
                prioritySet = prioritySet2;
            }
            prioritySet.add(group);
        }
    }

    private final void updateContainsMarkNow(int group, PrioritySet set) {
        boolean markChanges;
        int groupAddress = this.groupIndexToAddress(group);
        boolean containsAnyMarks = this.childContainsAnyMarks(group);
        boolean bl = markChanges = SlotTableKt.access$containsMark(this.groups, groupAddress) != containsAnyMarks;
        if (markChanges) {
            SlotTableKt.access$updateContainsMark(this.groups, groupAddress, containsAnyMarks);
            int parent2 = this.parent(group);
            if (parent2 >= 0) {
                set.add(parent2);
            }
        }
    }

    private final boolean childContainsAnyMarks(int group) {
        int end2 = group + this.groupSize(group);
        for (int child2 = group + 1; child2 < end2; child2 += this.groupSize(child2)) {
            if (!SlotTableKt.access$containsAnyMark(this.groups, this.groupIndexToAddress(child2))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int anchorIndex(@NotNull Anchor anchor) {
        void var2_2;
        Intrinsics.checkNotNullParameter(anchor, "anchor");
        int it = anchor.getLocation$runtime();
        boolean bl = false;
        return it < 0 ? this.getSize$runtime() + it : var2_2;
    }

    @NotNull
    public String toString() {
        return "SlotWriter(current = " + this.currentGroup + " end=" + this.currentGroupEnd + " size = " + this.getSize$runtime() + " gap=" + this.groupGapStart + '-' + (this.groupGapStart + this.groupGapLen) + ')';
    }

    private final void saveCurrentGroupEnd() {
        this.endStack.push(this.getCapacity() - this.groupGapLen - this.currentGroupEnd);
    }

    private final int restoreCurrentGroupEnd() {
        int newGroupEnd;
        this.currentGroupEnd = newGroupEnd = this.getCapacity() - this.groupGapLen - this.endStack.pop();
        return newGroupEnd;
    }

    private final void fixParentAnchorsFor(int parent2, int endGroup, int firstChild) {
        int parentAnchor = this.parentIndexToAnchor(parent2, this.groupGapStart);
        int child2 = firstChild;
        while (child2 < endGroup) {
            SlotTableKt.access$updateParentAnchor(this.groups, this.groupIndexToAddress(child2), parentAnchor);
            int childEnd = child2 + SlotTableKt.access$groupSize(this.groups, this.groupIndexToAddress(child2));
            this.fixParentAnchorsFor(child2, childEnd, child2 + 1);
            child2 = childEnd;
        }
    }

    private final void moveGroupGapTo(int index2) {
        int gapLen = this.groupGapLen;
        int gapStart = this.groupGapStart;
        if (gapStart != index2) {
            if (!((Collection)this.anchors).isEmpty()) {
                this.updateAnchors(gapStart, index2);
            }
            if (gapLen > 0) {
                int[] groups2 = this.groups;
                int groupPhysicalAddress = index2 * 5;
                int groupPhysicalGapLen = gapLen * 5;
                int groupPhysicalGapStart = gapStart * 5;
                if (index2 < gapStart) {
                    ArraysKt.copyInto(groups2, groups2, groupPhysicalAddress + groupPhysicalGapLen, groupPhysicalAddress, groupPhysicalGapStart);
                } else {
                    ArraysKt.copyInto(groups2, groups2, groupPhysicalGapStart, groupPhysicalGapStart + groupPhysicalGapLen, groupPhysicalAddress + groupPhysicalGapLen);
                }
            }
            int groupAddress = index2 < gapStart ? index2 + gapLen : gapStart;
            int capacity = this.getCapacity();
            ComposerKt.runtimeCheck(groupAddress < capacity);
            while (groupAddress < capacity) {
                int oldAnchor = SlotTableKt.access$parentAnchor(this.groups, groupAddress);
                int oldIndex = this.parentAnchorToIndex(oldAnchor);
                int newAnchor = this.parentIndexToAnchor(oldIndex, index2);
                if (newAnchor != oldAnchor) {
                    SlotTableKt.access$updateParentAnchor(this.groups, groupAddress, newAnchor);
                }
                if (++groupAddress != index2) continue;
                groupAddress += gapLen;
            }
        }
        this.groupGapStart = index2;
    }

    private final void moveSlotGapTo(int index2, int group) {
        int newSlotsGapOwner;
        int gapLen = this.slotsGapLen;
        int gapStart = this.slotsGapStart;
        int slotsGapOwner = this.slotsGapOwner;
        if (gapStart != index2) {
            Object[] slots = this.slots;
            if (index2 < gapStart) {
                ArraysKt.copyInto(slots, slots, index2 + gapLen, index2, gapStart);
            } else {
                ArraysKt.copyInto(slots, slots, gapStart, gapStart + gapLen, index2 + gapLen);
            }
        }
        if (slotsGapOwner != (newSlotsGapOwner = Math.min(group + 1, this.getSize$runtime()))) {
            int slotsSize = this.slots.length - gapLen;
            if (newSlotsGapOwner < slotsGapOwner) {
                int updateAddress = this.groupIndexToAddress(newSlotsGapOwner);
                int stopUpdateAddress = this.groupIndexToAddress(slotsGapOwner);
                int groupGapStart = this.groupGapStart;
                while (updateAddress < stopUpdateAddress) {
                    int anchor = SlotTableKt.access$dataAnchor(this.groups, updateAddress);
                    boolean value$iv = anchor >= 0;
                    boolean $i$f$runtimeCheck = false;
                    if (!value$iv) {
                        boolean bl = false;
                        String message$iv = "Unexpected anchor value, expected a positive anchor";
                        ComposerKt.composeRuntimeError(message$iv.toString());
                        throw new KotlinNothingValueException();
                    }
                    SlotTableKt.access$updateDataAnchor(this.groups, updateAddress, -(slotsSize - anchor + 1));
                    if (++updateAddress != groupGapStart) continue;
                    updateAddress += this.groupGapLen;
                }
            } else {
                int updateAddress = this.groupIndexToAddress(slotsGapOwner);
                int stopUpdateAddress = this.groupIndexToAddress(newSlotsGapOwner);
                while (updateAddress < stopUpdateAddress) {
                    int anchor = SlotTableKt.access$dataAnchor(this.groups, updateAddress);
                    boolean value$iv = anchor < 0;
                    boolean $i$f$runtimeCheck = false;
                    if (!value$iv) {
                        boolean bl = false;
                        String message$iv = "Unexpected anchor value, expected a negative anchor";
                        ComposerKt.composeRuntimeError(message$iv.toString());
                        throw new KotlinNothingValueException();
                    }
                    SlotTableKt.access$updateDataAnchor(this.groups, updateAddress, slotsSize + anchor + 1);
                    if (++updateAddress != this.groupGapStart) continue;
                    updateAddress += this.groupGapLen;
                }
            }
            this.slotsGapOwner = newSlotsGapOwner;
        }
        this.slotsGapStart = index2;
    }

    private final void clearSlotGap() {
        int slotsGapStart = this.slotsGapStart;
        int slotsGapEnd = slotsGapStart + this.slotsGapLen;
        ArraysKt.fill(this.slots, null, slotsGapStart, slotsGapEnd);
    }

    private final void insertGroups(int size2) {
        if (size2 > 0) {
            int currentEnd;
            int currentGroup = this.currentGroup;
            this.moveGroupGapTo(currentGroup);
            int gapStart = this.groupGapStart;
            int gapLen = this.groupGapLen;
            int oldCapacity = this.groups.length / 5;
            int oldSize = oldCapacity - gapLen;
            if (gapLen < size2) {
                int[] groups2 = this.groups;
                int newCapacity = Math.max(Math.max(oldCapacity * 2, oldSize + size2), 32);
                int[] newGroups = new int[newCapacity * 5];
                int newGapLen = newCapacity - oldSize;
                int oldGapEndAddress = gapStart + gapLen;
                int newGapEndAddress = gapStart + newGapLen;
                ArraysKt.copyInto(groups2, newGroups, 0, 0, gapStart * 5);
                ArraysKt.copyInto(groups2, newGroups, newGapEndAddress * 5, oldGapEndAddress * 5, oldCapacity * 5);
                this.groups = newGroups;
                gapLen = newGapLen;
            }
            if ((currentEnd = this.currentGroupEnd) >= gapStart) {
                this.currentGroupEnd = currentEnd + size2;
            }
            this.groupGapStart = gapStart + size2;
            this.groupGapLen = gapLen - size2;
            int index2 = oldSize > 0 ? this.dataIndex(currentGroup + size2) : 0;
            int anchor = this.dataIndexToDataAnchor(index2, this.slotsGapOwner < gapStart ? 0 : this.slotsGapStart, this.slotsGapLen, this.slots.length);
            int n = gapStart + size2;
            for (int groupAddress = gapStart; groupAddress < n; ++groupAddress) {
                SlotTableKt.access$updateDataAnchor(this.groups, groupAddress, anchor);
            }
            int slotsGapOwner = this.slotsGapOwner;
            if (slotsGapOwner >= gapStart) {
                this.slotsGapOwner = slotsGapOwner + size2;
            }
        }
    }

    private final void insertSlots(int size2, int group) {
        if (size2 > 0) {
            int currentDataEnd;
            this.moveSlotGapTo(this.currentSlot, group);
            int gapStart = this.slotsGapStart;
            int gapLen = this.slotsGapLen;
            if (gapLen < size2) {
                Object[] slots = this.slots;
                int oldCapacity = slots.length;
                int oldSize = oldCapacity - gapLen;
                int newCapacity = Math.max(Math.max(oldCapacity * 2, oldSize + size2), 32);
                int n = 0;
                Object[] objectArray = new Object[newCapacity];
                while (n < newCapacity) {
                    int n2 = n++;
                    objectArray[n2] = null;
                }
                Object[] newData = objectArray;
                int newGapLen = newCapacity - oldSize;
                int oldGapEndAddress = gapStart + gapLen;
                int newGapEndAddress = gapStart + newGapLen;
                ArraysKt.copyInto(slots, newData, 0, 0, gapStart);
                ArraysKt.copyInto(slots, newData, newGapEndAddress, oldGapEndAddress, oldCapacity);
                this.slots = newData;
                gapLen = newGapLen;
            }
            if ((currentDataEnd = this.currentSlotEnd) >= gapStart) {
                this.currentSlotEnd = currentDataEnd + size2;
            }
            this.slotsGapStart = gapStart + size2;
            this.slotsGapLen = gapLen - size2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeGroups(int start2, int len) {
        boolean bl;
        if (len > 0) {
            void var3_3;
            int parent2;
            int newGapLen;
            boolean anchorsRemoved = false;
            ArrayList<Anchor> anchors2 = this.anchors;
            this.moveGroupGapTo(start2);
            if (!((Collection)anchors2).isEmpty()) {
                anchorsRemoved = this.removeAnchors(start2, len, this.sourceInformationMap);
            }
            this.groupGapStart = start2;
            int previousGapLen = this.groupGapLen;
            this.groupGapLen = newGapLen = previousGapLen + len;
            int slotsGapOwner = this.slotsGapOwner;
            if (slotsGapOwner > start2) {
                this.slotsGapOwner = Math.max(start2, slotsGapOwner - len);
            }
            if (this.currentGroupEnd >= this.groupGapStart) {
                this.currentGroupEnd -= len;
            }
            if (this.containsGroupMark(parent2 = this.parent)) {
                this.updateContainsMark(parent2);
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    private final GroupSourceInformation sourceInformationOf(int group) {
        GroupSourceInformation groupSourceInformation;
        HashMap<Anchor, GroupSourceInformation> hashMap = this.sourceInformationMap;
        if (hashMap != null) {
            HashMap<Anchor, GroupSourceInformation> map2 = hashMap;
            boolean bl = false;
            Anchor anchor = this.tryAnchor$runtime(group);
            if (anchor != null) {
                Anchor anchor2 = anchor;
                boolean bl2 = false;
                groupSourceInformation = map2.get(anchor2);
            } else {
                groupSourceInformation = null;
            }
        } else {
            groupSourceInformation = null;
        }
        return groupSourceInformation;
    }

    @Nullable
    public final Anchor tryAnchor$runtime(int group) {
        return (0 <= group ? group < this.getSize$runtime() : false) ? SlotTableKt.access$find(this.anchors, group, this.getSize$runtime()) : null;
    }

    private final void removeSlots(int start2, int len, int group) {
        if (len > 0) {
            int gapLen = this.slotsGapLen;
            int removeEnd = start2 + len;
            this.moveSlotGapTo(removeEnd, group);
            this.slotsGapStart = start2;
            this.slotsGapLen = gapLen + len;
            ArraysKt.fill(this.slots, null, start2, start2 + len);
            int currentDataEnd = this.currentSlotEnd;
            if (currentDataEnd >= start2) {
                this.currentSlotEnd = currentDataEnd - len;
            }
        }
    }

    private final void updateNodeOfGroup(int index2, Object value) {
        int address = this.groupIndexToAddress(index2);
        boolean value$iv = address < this.groups.length && SlotTableKt.access$isNode(this.groups, address);
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Updating the node of a group at " + index2 + " that was not created with as a node group";
            ComposerKt.composeRuntimeError(message$iv.toString());
            throw new KotlinNothingValueException();
        }
        this.slots[this.dataIndexToDataAddress((int)this.nodeIndex((int[])this.groups, (int)address))] = value;
    }

    private final void updateAnchors(int previousGapStart, int newGapStart) {
        int gapLen = this.groupGapLen;
        int size2 = this.getCapacity() - gapLen;
        if (previousGapStart < newGapStart) {
            for (int index2 = SlotTableKt.access$locationOf(this.anchors, previousGapStart, size2); index2 < this.anchors.size(); ++index2) {
                int newLocation;
                Anchor anchor;
                Intrinsics.checkNotNullExpressionValue(this.anchors.get(index2), "get(...)");
                int location = anchor.getLocation$runtime();
                if (location < 0 && (newLocation = size2 + location) < newGapStart) {
                    anchor.setLocation$runtime(size2 + location);
                    continue;
                }
                break;
            }
        } else {
            for (int index3 = SlotTableKt.access$locationOf(this.anchors, newGapStart, size2); index3 < this.anchors.size(); ++index3) {
                Anchor anchor;
                Intrinsics.checkNotNullExpressionValue(this.anchors.get(index3), "get(...)");
                int location = anchor.getLocation$runtime();
                if (location >= 0) {
                    anchor.setLocation$runtime(-(size2 - location));
                    continue;
                }
                break;
            }
        }
    }

    private final boolean removeAnchors(int gapStart, int size2, HashMap<Anchor, GroupSourceInformation> sourceInformationMap) {
        boolean bl;
        int index2;
        int gapLen = this.groupGapLen;
        int removeEnd = gapStart + size2;
        int groupsSize = this.getCapacity() - gapLen;
        int it = SlotTableKt.access$locationOf(this.anchors, gapStart + size2, groupsSize);
        boolean bl2 = false;
        int n = it >= this.anchors.size() ? it - 1 : it;
        int removeAnchorEnd = 0;
        int removeAnchorStart = 0;
        removeAnchorStart = index2 + 1;
        for (index2 = v1925040; index2 >= 0; --index2) {
            Anchor anchor;
            Intrinsics.checkNotNullExpressionValue(this.anchors.get(index2), "get(...)");
            int location = this.anchorIndex(anchor);
            if (location < gapStart) break;
            if (location >= removeEnd) continue;
            anchor.setLocation$runtime(Integer.MIN_VALUE);
            HashMap<Anchor, GroupSourceInformation> hashMap = sourceInformationMap;
            if (hashMap != null) {
                hashMap.remove(anchor);
            }
            removeAnchorStart = index2;
            if (removeAnchorEnd != 0) continue;
            removeAnchorEnd = index2 + 1;
        }
        boolean it2 = bl = removeAnchorStart < removeAnchorEnd;
        boolean bl3 = false;
        if (it2) {
            this.anchors.subList(removeAnchorStart, removeAnchorEnd).clear();
        }
        return bl;
    }

    private final void moveAnchors(int originalLocation, int newLocation, int size2) {
        int end2 = originalLocation + size2;
        int groupsSize = this.getSize$runtime();
        int index2 = SlotTableKt.access$locationOf(this.anchors, originalLocation, groupsSize);
        List removedAnchors = new ArrayList();
        if (index2 >= 0) {
            while (index2 < this.anchors.size()) {
                Anchor anchor;
                Intrinsics.checkNotNullExpressionValue(this.anchors.get(index2), "get(...)");
                int location = this.anchorIndex(anchor);
                if (location < originalLocation || location >= end2) break;
                removedAnchors.add(anchor);
                this.anchors.remove(index2);
            }
        }
        int moveDelta = newLocation - originalLocation;
        List $this$fastForEach$iv = removedAnchors;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            Anchor anchor = (Anchor)item$iv;
            boolean bl = false;
            int anchorIndex = this.anchorIndex(anchor);
            int newAnchorIndex = anchorIndex + moveDelta;
            if (newAnchorIndex >= this.groupGapStart) {
                anchor.setLocation$runtime(-(groupsSize - newAnchorIndex));
            } else {
                anchor.setLocation$runtime(newAnchorIndex);
            }
            int insertIndex = SlotTableKt.access$locationOf(this.anchors, newAnchorIndex, groupsSize);
            this.anchors.add(insertIndex, anchor);
        }
    }

    @NotNull
    public final String groupsAsString() {
        StringBuilder stringBuilder;
        StringBuilder $this$groupsAsString_u24lambda_u2439 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.getSize$runtime();
        for (int index2 = 0; index2 < n; ++index2) {
            this.groupAsString($this$groupsAsString_u24lambda_u2439, index2);
            $this$groupsAsString_u24lambda_u2439.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final void groupAsString(StringBuilder $this$groupAsString, int index2) {
        int address = this.groupIndexToAddress(index2);
        $this$groupAsString.append("Group(");
        if (index2 < 10) {
            $this$groupAsString.append(' ');
        }
        if (index2 < 100) {
            $this$groupAsString.append(' ');
        }
        if (index2 < 1000) {
            $this$groupAsString.append(' ');
        }
        $this$groupAsString.append(index2);
        if (address != index2) {
            $this$groupAsString.append("(");
            $this$groupAsString.append(address);
            $this$groupAsString.append(")");
        }
        $this$groupAsString.append('#');
        $this$groupAsString.append(SlotTableKt.access$groupSize(this.groups, address));
        boolean openGroup = SlotWriter.groupAsString$isStarted(this, index2);
        if (openGroup) {
            $this$groupAsString.append('?');
        }
        $this$groupAsString.append('^');
        $this$groupAsString.append(this.parentAnchorToIndex(SlotTableKt.access$parentAnchor(this.groups, address)));
        $this$groupAsString.append(": key=");
        $this$groupAsString.append(SlotTableKt.access$key(this.groups, address));
        $this$groupAsString.append(", nodes=");
        $this$groupAsString.append(SlotTableKt.access$nodeCount(this.groups, address));
        if (openGroup) {
            $this$groupAsString.append('?');
        }
        $this$groupAsString.append(", dataAnchor=");
        $this$groupAsString.append(SlotTableKt.access$dataAnchor(this.groups, address));
        $this$groupAsString.append(", parentAnchor=");
        $this$groupAsString.append(SlotTableKt.access$parentAnchor(this.groups, address));
        if (SlotTableKt.access$isNode(this.groups, address)) {
            $this$groupAsString.append(", node=" + this.slots[this.dataIndexToDataAddress(this.nodeIndex(this.groups, address))]);
        }
        int startData = this.slotIndex(this.groups, address);
        int endData = this.dataIndex(this.groups, address + 1);
        if (endData > startData) {
            $this$groupAsString.append(", [");
            for (int dataIndex = startData; dataIndex < endData; ++dataIndex) {
                if (dataIndex != startData) {
                    $this$groupAsString.append(", ");
                }
                int dataAddress = this.dataIndexToDataAddress(dataIndex);
                $this$groupAsString.append(String.valueOf(this.slots[dataAddress]));
            }
            $this$groupAsString.append(']');
        }
        $this$groupAsString.append(")");
    }

    public final void verifyDataAnchors$runtime() {
        int previousDataIndex = 0;
        int owner2 = this.slotsGapOwner;
        boolean ownerFound = false;
        int slotsSize = this.slots.length - this.slotsGapLen;
        int n = this.getSize$runtime();
        for (int index2 = 0; index2 < n; ++index2) {
            int address = this.groupIndexToAddress(index2);
            int dataAnchor = SlotTableKt.access$dataAnchor(this.groups, address);
            int dataIndex = this.dataIndex(this.groups, address);
            if (!(dataIndex >= previousDataIndex)) {
                boolean $i$a$-check-SlotWriter$verifyDataAnchors$42 = false;
                String $i$a$-check-SlotWriter$verifyDataAnchors$42 = "Data index out of order at " + index2 + ", previous = " + previousDataIndex + ", current = " + dataIndex;
                throw new IllegalStateException($i$a$-check-SlotWriter$verifyDataAnchors$42.toString());
            }
            if (!(dataIndex <= slotsSize)) {
                boolean $i$a$-check-SlotWriter$verifyDataAnchors$52 = false;
                String $i$a$-check-SlotWriter$verifyDataAnchors$52 = "Data index, " + dataIndex + ", out of bound at " + index2;
                throw new IllegalStateException($i$a$-check-SlotWriter$verifyDataAnchors$52.toString());
            }
            if (dataAnchor < 0 && !ownerFound) {
                if (!(owner2 == index2)) {
                    boolean bl = false;
                    String string = "Expected the slot gap owner to be " + owner2 + " found gap at " + index2;
                    throw new IllegalStateException(string.toString());
                }
                ownerFound = true;
            }
            previousDataIndex = dataIndex;
        }
    }

    public final void verifyParentAnchors$runtime() {
        int parentAnchor;
        int groupAddress;
        int gapStart = this.groupGapStart;
        int gapLen = this.groupGapLen;
        int capacity = this.getCapacity();
        for (groupAddress = 0; groupAddress < gapStart; ++groupAddress) {
            parentAnchor = SlotTableKt.access$parentAnchor(this.groups, groupAddress);
            if (parentAnchor > -2) continue;
            boolean bl = false;
            String string = "Expected a start relative anchor at " + groupAddress;
            throw new IllegalStateException(string.toString());
        }
        for (groupAddress = gapStart + gapLen; groupAddress < capacity; ++groupAddress) {
            parentAnchor = SlotTableKt.access$parentAnchor(this.groups, groupAddress);
            int parentIndex = this.parentAnchorToIndex(parentAnchor);
            if (parentIndex < gapStart) {
                if (parentAnchor > -2) continue;
                boolean $i$a$-check-SlotWriter$verifyParentAnchors$42 = false;
                String $i$a$-check-SlotWriter$verifyParentAnchors$42 = "Expected a start relative anchor at " + groupAddress;
                throw new IllegalStateException($i$a$-check-SlotWriter$verifyParentAnchors$42.toString());
            }
            if (parentAnchor <= -2) continue;
            boolean bl = false;
            String string = "Expected an end relative anchor at " + groupAddress;
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getSize$runtime() {
        return this.getCapacity() - this.groupGapLen;
    }

    private final int getCapacity() {
        return this.groups.length / 5;
    }

    private final int groupIndexToAddress(int index2) {
        return index2 < this.groupGapStart ? index2 : index2 + this.groupGapLen;
    }

    private final int dataIndexToDataAddress(int dataIndex) {
        return dataIndex < this.slotsGapStart ? dataIndex : dataIndex + this.slotsGapLen;
    }

    private final int parent(int[] $this$parent, int index2) {
        return this.parentAnchorToIndex(SlotTableKt.access$parentAnchor($this$parent, this.groupIndexToAddress(index2)));
    }

    private final int dataIndex(int index2) {
        return this.dataIndex(this.groups, this.groupIndexToAddress(index2));
    }

    private final int dataIndex(int[] $this$dataIndex, int address) {
        return address >= this.getCapacity() ? this.slots.length - this.slotsGapLen : this.dataAnchorToDataIndex(SlotTableKt.access$dataAnchor($this$dataIndex, address), this.slotsGapLen, this.slots.length);
    }

    private final int slotIndex(int[] $this$slotIndex, int address) {
        return address >= this.getCapacity() ? this.slots.length - this.slotsGapLen : this.dataAnchorToDataIndex(SlotTableKt.access$slotAnchor($this$slotIndex, address), this.slotsGapLen, this.slots.length);
    }

    private final void updateDataIndex(int[] $this$updateDataIndex, int address, int dataIndex) {
        SlotTableKt.access$updateDataAnchor($this$updateDataIndex, address, this.dataIndexToDataAnchor(dataIndex, this.slotsGapStart, this.slotsGapLen, this.slots.length));
    }

    private final int nodeIndex(int[] $this$nodeIndex, int address) {
        return this.dataIndex($this$nodeIndex, address);
    }

    private final int auxIndex(int[] $this$auxIndex, int address) {
        return this.dataIndex($this$auxIndex, address) + SlotTableKt.access$countOneBits(SlotTableKt.access$groupInfo($this$auxIndex, address) >> 29);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> dataIndexes(int[] $this$dataIndexes) {
        List it = SlotTableKt.dataAnchors$default(this.groups, 0, 1, null);
        boolean bl = false;
        List $this$fastMap$iv = CollectionsKt.plus((Collection)CollectionsKt.slice(it, RangesKt.until(0, this.groupGapStart)), (Iterable)CollectionsKt.slice(it, RangesKt.until(this.groupGapStart + this.groupGapLen, $this$dataIndexes.length / 5)));
        boolean $i$f$fastMap = false;
        ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
        List $this$fastForEach$iv$iv = $this$fastMap$iv;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            void anchor;
            Object item$iv$iv;
            Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl2 = false;
            int n2 = ((Number)it$iv).intValue();
            Collection collection = target$iv;
            boolean bl3 = false;
            collection.add(this.dataAnchorToDataIndex((int)anchor, this.slotsGapLen, this.slots.length));
        }
        return target$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> keys() {
        List $this$fastFilterIndexed$iv = SlotTableKt.keys$default(this.groups, 0, 1, null);
        boolean $i$f$fastFilterIndexed = false;
        ArrayList target$iv = new ArrayList($this$fastFilterIndexed$iv.size());
        List $this$fastForEachIndexed$iv$iv = $this$fastFilterIndexed$iv;
        boolean $i$f$fastForEachIndexed = false;
        int n = $this$fastForEachIndexed$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            void e$iv;
            Object item$iv$iv;
            Object e = item$iv$iv = $this$fastForEachIndexed$iv$iv.get(index$iv$iv);
            int index$iv = index$iv$iv;
            boolean bl = false;
            ((Number)e$iv).intValue();
            int index2 = index$iv;
            boolean bl2 = false;
            if (!(index2 < this.groupGapStart || index2 >= this.groupGapStart + this.groupGapLen)) continue;
            ((Collection)target$iv).add(e$iv);
        }
        return target$iv;
    }

    private final int dataIndexToDataAnchor(int index2, int gapStart, int gapLen, int capacity) {
        return index2 > gapStart ? -(capacity - gapLen - index2 + 1) : index2;
    }

    private final int dataAnchorToDataIndex(int anchor, int gapLen, int capacity) {
        return anchor < 0 ? capacity - gapLen + anchor + 1 : anchor;
    }

    private final int parentIndexToAnchor(int index2, int gapStart) {
        return index2 < gapStart ? index2 : -(this.getSize$runtime() - index2 - -2);
    }

    private final int parentAnchorToIndex(int index2) {
        return index2 > -2 ? index2 : this.getSize$runtime() + index2 - -2;
    }

    private static final boolean groupAsString$isStarted(SlotWriter this$0, int index2) {
        return index2 < this$0.currentGroup && (index2 == this$0.parent || this$0.startStack.indexOf(index2) >= 0 || SlotWriter.groupAsString$isStarted(this$0, this$0.parent(index2)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Landroidx/compose/runtime/SlotWriter$Companion;", "", "()V", "moveGroup", "", "Landroidx/compose/runtime/Anchor;", "fromWriter", "Landroidx/compose/runtime/SlotWriter;", "fromIndex", "", "toWriter", "updateFromCursor", "", "updateToCursor", "removeSourceGroup", "runtime"})
    @SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,3747:1\n1#2:3748\n33#3,6:3749\n4179#4,5:3755\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotWriter$Companion\n*L\n2304#1:3749,6\n2369#1:3755,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Anchor> moveGroup(SlotWriter fromWriter, int fromIndex, SlotWriter toWriter, boolean updateFromCursor, boolean updateToCursor, boolean removeSourceGroup) {
            boolean bl;
            HashMap sourceSourceInformationMap;
            List anchors2;
            List list2;
            void $this$moveGroup_u24lambda_u240;
            int groupsToMove = fromWriter.groupSize(fromIndex);
            int sourceGroupsEnd = fromIndex + groupsToMove;
            int sourceSlotsStart = fromWriter.dataIndex(fromIndex);
            int sourceSlotsEnd = fromWriter.dataIndex(sourceGroupsEnd);
            int slotsToMove = sourceSlotsEnd - sourceSlotsStart;
            boolean hasMarks = fromWriter.containsAnyGroupMarks(fromIndex);
            toWriter.insertGroups(groupsToMove);
            toWriter.insertSlots(slotsToMove, toWriter.getCurrentGroup());
            if (fromWriter.groupGapStart < sourceGroupsEnd) {
                fromWriter.moveGroupGapTo(sourceGroupsEnd);
            }
            if (fromWriter.slotsGapStart < sourceSlotsEnd) {
                fromWriter.moveSlotGapTo(sourceSlotsEnd, sourceGroupsEnd);
            }
            int[] groups2 = toWriter.groups;
            int currentGroup = toWriter.getCurrentGroup();
            ArraysKt.copyInto(fromWriter.groups, groups2, currentGroup * 5, fromIndex * 5, sourceGroupsEnd * 5);
            Object[] slots = toWriter.slots;
            int currentSlot = toWriter.currentSlot;
            ArraysKt.copyInto(fromWriter.slots, slots, currentSlot, sourceSlotsStart, sourceSlotsEnd);
            int parent2 = toWriter.getParent();
            SlotTableKt.access$updateParentAnchor(groups2, currentGroup, parent2);
            int parentDelta = currentGroup - fromIndex;
            int moveEnd = currentGroup + groupsToMove;
            SlotWriter slotWriter = toWriter;
            int n = currentSlot;
            boolean bl2 = false;
            int n2 = ((SlotWriter)$this$moveGroup_u24lambda_u240).dataIndex(groups2, currentGroup);
            int dataIndexDelta = n - n2;
            int slotsGapOwner = 0;
            slotsGapOwner = toWriter.slotsGapOwner;
            int slotsGapLen = toWriter.slotsGapLen;
            int slotsCapacity = slots.length;
            for (int groupAddress = currentGroup; groupAddress < moveEnd; ++groupAddress) {
                if (groupAddress != currentGroup) {
                    int previousParent = SlotTableKt.access$parentAnchor(groups2, groupAddress);
                    SlotTableKt.access$updateParentAnchor(groups2, groupAddress, previousParent + parentDelta);
                }
                SlotWriter $this$moveGroup_u24lambda_u241 = toWriter;
                boolean bl3 = false;
                int newDataIndex = $this$moveGroup_u24lambda_u241.dataIndex(groups2, groupAddress) + dataIndexDelta;
                SlotWriter $this$moveGroup_u24lambda_u2432 = toWriter;
                boolean bl4 = false;
                int newDataAnchor = $this$moveGroup_u24lambda_u2432.dataIndexToDataAnchor(newDataIndex, slotsGapOwner < groupAddress ? 0 : $this$moveGroup_u24lambda_u2432.slotsGapStart, slotsGapLen, slotsCapacity);
                SlotTableKt.access$updateDataAnchor(groups2, groupAddress, newDataAnchor);
                if (groupAddress != slotsGapOwner) continue;
                int $this$moveGroup_u24lambda_u2432 = slotsGapOwner;
                slotsGapOwner = $this$moveGroup_u24lambda_u2432 + 1;
            }
            toWriter.slotsGapOwner = slotsGapOwner;
            int startAnchors = SlotTableKt.access$locationOf(fromWriter.anchors, fromIndex, fromWriter.getSize$runtime());
            int endAnchors = SlotTableKt.access$locationOf(fromWriter.anchors, sourceGroupsEnd, fromWriter.getSize$runtime());
            if (startAnchors < endAnchors) {
                ArrayList sourceAnchors = fromWriter.anchors;
                ArrayList<Anchor> anchors3 = new ArrayList<Anchor>(endAnchors - startAnchors);
                int anchorDelta = currentGroup - fromIndex;
                for (int anchorIndex = startAnchors; anchorIndex < endAnchors; ++anchorIndex) {
                    Object e = sourceAnchors.get(anchorIndex);
                    Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                    Anchor sourceAnchor = (Anchor)e;
                    sourceAnchor.setLocation$runtime(sourceAnchor.getLocation$runtime() + anchorDelta);
                    anchors3.add(sourceAnchor);
                }
                int insertLocation = SlotTableKt.access$locationOf(toWriter.anchors, toWriter.getCurrentGroup(), toWriter.getSize$runtime());
                toWriter.anchors.addAll(insertLocation, (Collection)anchors3);
                sourceAnchors.subList(startAnchors, endAnchors).clear();
                list2 = anchors3;
            } else {
                list2 = anchors2 = CollectionsKt.emptyList();
            }
            if (!((Collection)anchors2).isEmpty() && (sourceSourceInformationMap = fromWriter.sourceInformationMap) != null) {
                HashMap destinationSourceInformation = null;
                destinationSourceInformation = toWriter.sourceInformationMap;
                List $this$fastForEach$iv = anchors2;
                boolean $i$f$fastForEach = false;
                int n3 = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                    Object item$iv = $this$fastForEach$iv.get(index$iv);
                    Anchor anchor = (Anchor)item$iv;
                    boolean bl5 = false;
                    GroupSourceInformation information = (GroupSourceInformation)sourceSourceInformationMap.get(anchor);
                    if (information == null) continue;
                    sourceSourceInformationMap.remove(anchor);
                    HashMap hashMap = destinationSourceInformation;
                    if (hashMap == null) {
                        HashMap map2;
                        Companion $this$moveGroup_u24lambda_u244_u24lambda_u243 = Companion;
                        boolean bl6 = false;
                        destinationSourceInformation = map2 = new HashMap();
                        toWriter.sourceInformationMap = destinationSourceInformation;
                        hashMap = map2;
                    }
                    HashMap map3 = hashMap;
                    ((Map)map3).put(anchor, information);
                }
                if (sourceSourceInformationMap.isEmpty()) {
                    fromWriter.sourceInformationMap = null;
                }
            }
            int toWriterParent = toWriter.getParent();
            GroupSourceInformation groupSourceInformation = toWriter.sourceInformationOf(parent2);
            if (groupSourceInformation != null) {
                GroupSourceInformation it = groupSourceInformation;
                boolean bl7 = false;
                int predecessor = -1;
                int endGroup = toWriter.getCurrentGroup();
                for (int child2 = toWriterParent + 1; child2 < endGroup; child2 += SlotTableKt.access$groupSize(toWriter.groups, child2)) {
                    predecessor = child2;
                }
                it.addGroupAfter(toWriter, predecessor, endGroup);
            }
            int parentGroup = fromWriter.parent(fromIndex);
            if (!removeSourceGroup) {
                bl = false;
            } else if (updateFromCursor) {
                boolean needsStartGroups;
                boolean bl8 = needsStartGroups = parentGroup >= 0;
                if (needsStartGroups) {
                    fromWriter.startGroup();
                    fromWriter.advanceBy(parentGroup - fromWriter.getCurrentGroup());
                    fromWriter.startGroup();
                }
                fromWriter.advanceBy(fromIndex - fromWriter.getCurrentGroup());
                boolean anchorsRemoved = fromWriter.removeGroup();
                if (needsStartGroups) {
                    fromWriter.skipToGroupEnd();
                    fromWriter.endGroup();
                    fromWriter.skipToGroupEnd();
                    fromWriter.endGroup();
                }
                bl = anchorsRemoved;
            } else {
                boolean anchorsRemoved = fromWriter.removeGroups(fromIndex, groupsToMove);
                fromWriter.removeSlots(sourceSlotsStart, slotsToMove, fromIndex - 1);
                bl = anchorsRemoved;
            }
            boolean anchorsRemoved = bl;
            boolean value$iv = !anchorsRemoved;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl9 = false;
                String message$iv = "Unexpectedly removed anchors";
                ComposerKt.composeRuntimeError(message$iv.toString());
                throw new KotlinNothingValueException();
            }
            toWriter.nodeCount = toWriter.nodeCount + (SlotTableKt.access$isNode(groups2, currentGroup) ? 1 : SlotTableKt.access$nodeCount(groups2, currentGroup));
            if (updateToCursor) {
                toWriter.currentGroup = currentGroup + groupsToMove;
                toWriter.currentSlot = currentSlot + slotsToMove;
            }
            if (hasMarks) {
                toWriter.updateContainsMark(parent2);
            }
            return anchors2;
        }

        static /* synthetic */ List moveGroup$default(Companion companion, SlotWriter slotWriter, int n, SlotWriter slotWriter2, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                bl3 = true;
            }
            return companion.moveGroup(slotWriter, n, slotWriter2, bl, bl2, bl3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

