/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import androidx.compose.foundation.text2.input.internal.ToCharArray_skikoKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0002J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J2\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/foundation/text2/input/internal/GapBuffer;", "", "initBuffer", "", "initGapStart", "", "initGapEnd", "([CII)V", "buffer", "capacity", "gapEnd", "gapStart", "append", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "delete", "start", "end", "gapLength", "get", "", "index", "length", "makeSureAvailableSpace", "requestSize", "replace", "text", "", "textStart", "textEnd", "toString", "", "foundation"})
@SourceDebugExtension(value={"SMAP\nGapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GapBuffer.kt\nandroidx/compose/foundation/text2/input/internal/GapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1#2:335\n*E\n"})
final class GapBuffer {
    private int capacity;
    @NotNull
    private char[] buffer;
    private int gapStart;
    private int gapEnd;

    public GapBuffer(@NotNull char[] initBuffer, int initGapStart, int initGapEnd) {
        Intrinsics.checkNotNullParameter(initBuffer, "initBuffer");
        this.capacity = initBuffer.length;
        this.buffer = initBuffer;
        this.gapStart = initGapStart;
        this.gapEnd = initGapEnd;
    }

    private final int gapLength() {
        return this.gapEnd - this.gapStart;
    }

    public final char get(int index2) {
        if (index2 < this.gapStart) {
            return this.buffer[index2];
        }
        return this.buffer[index2 - this.gapStart + this.gapEnd];
    }

    private final void makeSureAvailableSpace(int requestSize) {
        if (requestSize <= this.gapLength()) {
            return;
        }
        int necessarySpace = requestSize - this.gapLength();
        int newCapacity = this.capacity * 2;
        while (newCapacity - this.capacity < necessarySpace) {
            newCapacity *= 2;
        }
        char[] newBuffer = new char[newCapacity];
        ArraysKt.copyInto(this.buffer, newBuffer, 0, 0, this.gapStart);
        int tailLength = this.capacity - this.gapEnd;
        int newEnd = newCapacity - tailLength;
        ArraysKt.copyInto(this.buffer, newBuffer, newEnd, this.gapEnd, this.gapEnd + tailLength);
        this.buffer = newBuffer;
        this.capacity = newCapacity;
        this.gapEnd = newEnd;
    }

    private final void delete(int start2, int end2) {
        if (start2 < this.gapStart && end2 <= this.gapStart) {
            int copyLen = this.gapStart - end2;
            ArraysKt.copyInto(this.buffer, this.buffer, this.gapEnd - copyLen, end2, this.gapStart);
            this.gapStart = start2;
            this.gapEnd -= copyLen;
        } else if (start2 < this.gapStart && end2 >= this.gapStart) {
            this.gapEnd = end2 + this.gapLength();
            this.gapStart = start2;
        } else {
            int startInBuffer = start2 + this.gapLength();
            int endInBuffer = end2 + this.gapLength();
            int copyLen = startInBuffer - this.gapEnd;
            ArraysKt.copyInto(this.buffer, this.buffer, this.gapStart, this.gapEnd, startInBuffer);
            this.gapStart += copyLen;
            this.gapEnd = endInBuffer;
        }
    }

    public final void replace(int start2, int end2, @NotNull CharSequence text2, int textStart, int textEnd) {
        Intrinsics.checkNotNullParameter(text2, "text");
        int textLength = textEnd - textStart;
        this.makeSureAvailableSpace(textLength - (end2 - start2));
        this.delete(start2, end2);
        ToCharArray_skikoKt.toCharArray(text2, this.buffer, this.gapStart, textStart, textEnd);
        this.gapStart += textLength;
    }

    public static /* synthetic */ void replace$default(GapBuffer gapBuffer, int n, int n2, CharSequence charSequence, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        gapBuffer.replace(n, n2, charSequence, n3, n4);
    }

    public final void append(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        StringBuilder stringBuilder = builder;
        char[] cArray = this.buffer;
        int n = 0;
        int n2 = this.gapStart;
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append(cArray, n, n2 - n), "append(...)");
        stringBuilder = builder;
        cArray = this.buffer;
        n = this.gapEnd;
        n2 = this.capacity;
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append(cArray, n, n2 - n), "append(...)");
    }

    public final int length() {
        return this.capacity - this.gapLength();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append((CharSequence)$this$toString_u24lambda_u240);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

