/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text2.input.EmptyChangeList;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.internal.ChangeTracker;
import androidx.compose.foundation.text2.input.internal.CodepointHelpers_jvmKt;
import androidx.compose.foundation.text2.input.internal.PartialGapBuffer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001VB%\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0014\u0010!\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010!\u001a\u00060\u0001j\u0002`\u00022\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J&\u0010!\u001a\u00060\u0001j\u0002`\u00022\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0011H\u0016J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0011J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011H\u0002J\u001a\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b.\u0010/J\b\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011H\u0002J\u001a\u00103\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u0010/J \u00105\u001a\u0002012\u0006\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u0011H\u0002J\u000e\u00109\u001a\u0002012\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010:\u001a\u0002012\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010;\u001a\u0002012\u0006\u0010*\u001a\u00020\u0011J\u000e\u0010<\u001a\u0002012\u0006\u0010*\u001a\u00020\u0011J\u001e\u0010=\u001a\u0002012\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%J9\u0010=\u001a\u0002012\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010>\u001a\u00020\u00112\b\b\u0002\u0010?\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b@J(\u0010A\u001a\u0002012\u0006\u0010*\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020\u00152\u0006\u0010D\u001a\u00020\u0015H\u0002J\"\u0010E\u001a\u0002012\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bF\u0010GJ\u0006\u0010H\u001a\u000201J\u0018\u0010I\u001a\u0002012\u0006\u0010-\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\bJ\u0010KJ\u0018\u0010L\u001a\u0002012\u0006\u0010-\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\bM\u0010KJ\u0015\u0010N\u001a\u0002012\u0006\u0010O\u001a\u00020%H\u0000\u00a2\u0006\u0002\bPJ\b\u0010Q\u001a\u00020RH\u0016J\u001c\u0010S\u001a\u00020\u00042\n\b\u0002\u0010T\u001a\u0004\u0018\u00010\u001aH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\bUR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R&\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001a8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001dR\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006W"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldBuffer;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "initialValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "initialChanges", "Landroidx/compose/foundation/text2/input/internal/ChangeTracker;", "sourceValue", "(Landroidx/compose/foundation/text2/input/TextFieldCharSequence;Landroidx/compose/foundation/text2/input/internal/ChangeTracker;Landroidx/compose/foundation/text2/input/TextFieldCharSequence;)V", "buffer", "Landroidx/compose/foundation/text2/input/internal/PartialGapBuffer;", "changeTracker", "changes", "Landroidx/compose/foundation/text2/input/TextFieldBuffer$ChangeList;", "getChanges", "()Landroidx/compose/foundation/text2/input/TextFieldBuffer$ChangeList;", "codepointLength", "", "getCodepointLength", "()I", "hasSelection", "", "()Z", "length", "getLength", "<set-?>", "Landroidx/compose/ui/text/TextRange;", "selectionInChars", "getSelectionInChars-d9O1mEE", "()J", "J", "selectionInCodepoints", "getSelectionInCodepoints-d9O1mEE", "append", "char", "", "text", "", "start", "end", "asCharSequence", "charAt", "index", "charIndexToCodepointIndex", "charsToCodepoints", "range", "charsToCodepoints-GEjPoXI", "(J)J", "clearChangeList", "", "codepointIndexToCharIndex", "codepointsToChars", "codepointsToChars-GEjPoXI", "onTextWillChange", "replaceStart", "replaceEnd", "newLength", "placeCursorAfterCharAt", "placeCursorAfterFCodepointAt", "placeCursorBeforeCharAt", "placeCursorBeforeCodepointAt", "replace", "textStart", "textEnd", "replace$foundation", "requireValidIndex", "startExclusive", "endExclusive", "inCodepoints", "requireValidRange", "requireValidRange-72CqOWE", "(JZ)V", "revertAllChanges", "selectCharsIn", "selectCharsIn-5zc-tL8", "(J)V", "selectCodepointsIn", "selectCodepointsIn-5zc-tL8", "setTextIfChanged", "newText", "setTextIfChanged$foundation", "toString", "", "toTextFieldCharSequence", "composition", "toTextFieldCharSequence-OEnZFl4$foundation", "ChangeList", "foundation"})
@ExperimentalFoundationApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextFieldBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldBuffer.kt\nandroidx/compose/foundation/text2/input/TextFieldBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TextFieldBuffer.kt\nandroidx/compose/foundation/text2/input/TextFieldBufferKt\n*L\n1#1,648:1\n1#2:649\n591#3,43:650\n*S KotlinDebug\n*F\n+ 1 TextFieldBuffer.kt\nandroidx/compose/foundation/text2/input/TextFieldBuffer\n*L\n164#1:650,43\n*E\n"})
public final class TextFieldBuffer
implements Appendable {
    @NotNull
    private final TextFieldCharSequence sourceValue;
    @NotNull
    private final PartialGapBuffer buffer;
    @Nullable
    private ChangeTracker changeTracker;
    private long selectionInChars;
    public static final int $stable = 8;

    public TextFieldBuffer(@NotNull TextFieldCharSequence initialValue, @Nullable ChangeTracker initialChanges, @NotNull TextFieldCharSequence sourceValue) {
        ChangeTracker changeTracker;
        Intrinsics.checkNotNullParameter(initialValue, "initialValue");
        Intrinsics.checkNotNullParameter(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        this.buffer = new PartialGapBuffer(initialValue);
        TextFieldBuffer textFieldBuffer = this;
        ChangeTracker changeTracker2 = initialChanges;
        if (changeTracker2 != null) {
            ChangeTracker changeTracker3 = changeTracker2;
            TextFieldBuffer textFieldBuffer2 = textFieldBuffer;
            boolean bl = false;
            changeTracker = new ChangeTracker(initialChanges);
            textFieldBuffer = textFieldBuffer2;
        } else {
            changeTracker = null;
        }
        textFieldBuffer.changeTracker = changeTracker;
        this.selectionInChars = initialValue.getSelectionInChars-d9O1mEE();
    }

    public /* synthetic */ TextFieldBuffer(TextFieldCharSequence textFieldCharSequence, ChangeTracker changeTracker, TextFieldCharSequence textFieldCharSequence2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            changeTracker = null;
        }
        if ((n & 4) != 0) {
            textFieldCharSequence2 = textFieldCharSequence;
        }
        this(textFieldCharSequence, changeTracker, textFieldCharSequence2);
    }

    public final int getLength() {
        return this.buffer.length();
    }

    public final int getCodepointLength() {
        return CodepointHelpers_jvmKt.codePointCount(this.buffer);
    }

    @NotNull
    public final ChangeList getChanges() {
        ChangeTracker changeTracker = this.changeTracker;
        return changeTracker != null ? (ChangeList)changeTracker : (ChangeList)EmptyChangeList.INSTANCE;
    }

    @JvmName(name="hasSelection")
    public final boolean hasSelection() {
        return !TextRange.getCollapsed-impl(this.selectionInChars);
    }

    public final long getSelectionInChars-d9O1mEE() {
        return this.selectionInChars;
    }

    public final long getSelectionInCodepoints-d9O1mEE() {
        return this.charsToCodepoints-GEjPoXI(this.selectionInChars);
    }

    public final void replace(int start2, int end2, @NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this.replace$foundation(start2, end2, text2, 0, text2.length());
    }

    public final void replace$foundation(int start2, int end2, @NotNull CharSequence text2, int textStart, int textEnd) {
        Intrinsics.checkNotNullParameter(text2, "text");
        if (!(start2 <= end2)) {
            boolean $i$a$-require-TextFieldBuffer$replace$32 = false;
            String $i$a$-require-TextFieldBuffer$replace$32 = "Expected start=" + start2 + " <= end=" + end2;
            throw new IllegalArgumentException($i$a$-require-TextFieldBuffer$replace$32.toString());
        }
        if (!(textStart <= textEnd)) {
            boolean bl = false;
            String string = "Expected textStart=" + textStart + " <= textEnd=" + textEnd;
            throw new IllegalArgumentException(string.toString());
        }
        this.onTextWillChange(start2, end2, textEnd - textStart);
        this.buffer.replace(start2, end2, text2, textStart, textEnd);
    }

    public static /* synthetic */ void replace$foundation$default(TextFieldBuffer textFieldBuffer, int n, int n2, CharSequence charSequence, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        textFieldBuffer.replace$foundation(n, n2, charSequence, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTextIfChanged$foundation(@NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter(newText, "newText");
        CharSequence a$iv = this.buffer;
        boolean $i$f$findCommonPrefixAndSuffix = false;
        int aStart$iv = 0;
        int aEnd$iv = a$iv.length();
        int bStart$iv = 0;
        int bEnd$iv = newText.length();
        if (a$iv.length() > 0 && newText.length() > 0) {
            boolean prefixFound$iv = false;
            boolean suffixFound$iv = false;
            do {
                if (!prefixFound$iv) {
                    if (a$iv.charAt(aStart$iv) == newText.charAt(bStart$iv)) {
                        ++aStart$iv;
                        ++bStart$iv;
                    } else {
                        prefixFound$iv = true;
                    }
                }
                if (suffixFound$iv) continue;
                if (a$iv.charAt(aEnd$iv - 1) == newText.charAt(bEnd$iv - 1)) {
                    --aEnd$iv;
                    --bEnd$iv;
                    continue;
                }
                suffixFound$iv = true;
            } while (aStart$iv < aEnd$iv && bStart$iv < bEnd$iv && (!prefixFound$iv || !suffixFound$iv));
        }
        if (aStart$iv < aEnd$iv || bStart$iv < bEnd$iv) {
            void newEnd;
            void newStart;
            void thisEnd;
            int n = bEnd$iv;
            int n2 = bStart$iv;
            int n3 = aEnd$iv;
            int thisStart = aStart$iv;
            boolean bl = false;
            this.replace$foundation(thisStart, (int)thisEnd, newText, (int)newStart, (int)newEnd);
        }
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence text2) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u244 = textFieldBuffer = this;
        boolean bl = false;
        if (text2 != null) {
            $this$append_u24lambda_u244.onTextWillChange($this$append_u24lambda_u244.getLength(), $this$append_u24lambda_u244.getLength(), text2.length());
            PartialGapBuffer.replace$default($this$append_u24lambda_u244.buffer, $this$append_u24lambda_u244.buffer.length(), $this$append_u24lambda_u244.buffer.length(), text2, 0, 0, 24, null);
        }
        return textFieldBuffer;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence text2, int start2, int end2) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u245 = textFieldBuffer = this;
        boolean bl = false;
        if (text2 != null) {
            $this$append_u24lambda_u245.onTextWillChange($this$append_u24lambda_u245.getLength(), $this$append_u24lambda_u245.getLength(), end2 - start2);
            PartialGapBuffer.replace$default($this$append_u24lambda_u245.buffer, $this$append_u24lambda_u245.buffer.length(), $this$append_u24lambda_u245.buffer.length(), text2.subSequence(start2, end2), 0, 0, 24, null);
        }
        return textFieldBuffer;
    }

    @Override
    @NotNull
    public Appendable append(char c) {
        TextFieldBuffer textFieldBuffer;
        TextFieldBuffer $this$append_u24lambda_u246 = textFieldBuffer = this;
        boolean bl = false;
        $this$append_u24lambda_u246.onTextWillChange($this$append_u24lambda_u246.getLength(), $this$append_u24lambda_u246.getLength(), 1);
        PartialGapBuffer.replace$default($this$append_u24lambda_u246.buffer, $this$append_u24lambda_u246.buffer.length(), $this$append_u24lambda_u246.buffer.length(), String.valueOf(c), 0, 0, 24, null);
        return textFieldBuffer;
    }

    private final void onTextWillChange(int replaceStart, int replaceEnd, int newLength) {
        ChangeTracker changeTracker = this.changeTracker;
        if (changeTracker == null) {
            ChangeTracker changeTracker2;
            ChangeTracker it = changeTracker2 = new ChangeTracker(null, 1, null);
            boolean bl = false;
            this.changeTracker = it;
            changeTracker = changeTracker2;
        }
        changeTracker.trackChange(replaceStart, replaceEnd, newLength);
        int start2 = Math.min(replaceStart, replaceEnd);
        int end2 = Math.max(replaceStart, replaceEnd);
        int selStart = TextRange.getMin-impl(this.selectionInChars);
        int selEnd = TextRange.getMax-impl(this.selectionInChars);
        if (selEnd < start2) {
            return;
        }
        if (selStart <= start2 && end2 <= selEnd) {
            int diff = newLength - (end2 - start2);
            if (selStart == selEnd) {
                selStart += diff;
            }
            selEnd += diff;
        } else if (selStart > start2 && selEnd < end2) {
            selStart = start2 + newLength;
            selEnd = start2 + newLength;
        } else if (selStart >= end2) {
            int diff = newLength - (end2 - start2);
            selStart += diff;
            selEnd += diff;
        } else if (start2 < selStart) {
            selStart = start2 + newLength;
            selEnd += newLength - (end2 - start2);
        } else {
            selEnd = start2;
        }
        this.selectionInChars = TextRangeKt.TextRange(selStart, selEnd);
    }

    public final char charAt(int index2) {
        return this.buffer.charAt(index2);
    }

    @NotNull
    public String toString() {
        return this.buffer.toString();
    }

    @NotNull
    public final CharSequence asCharSequence() {
        return this.buffer;
    }

    private final void clearChangeList() {
        block0: {
            ChangeTracker changeTracker = this.changeTracker;
            if (changeTracker == null) break block0;
            changeTracker.clearChanges();
        }
    }

    public final void revertAllChanges() {
        this.replace(0, this.getLength(), ((Object)this.sourceValue).toString());
        this.selectionInChars = this.sourceValue.getSelectionInChars-d9O1mEE();
        this.clearChangeList();
    }

    public final void placeCursorBeforeCodepointAt(int index2) {
        this.requireValidIndex(index2, true, false, true);
        int charIndex = this.codepointIndexToCharIndex(index2);
        this.selectionInChars = TextRangeKt.TextRange(charIndex);
    }

    public final void placeCursorBeforeCharAt(int index2) {
        this.requireValidIndex(index2, true, false, false);
        this.selectionInChars = TextRangeKt.TextRange(index2);
    }

    public final void placeCursorAfterFCodepointAt(int index2) {
        this.requireValidIndex(index2, false, true, true);
        int charIndex = this.codepointIndexToCharIndex(RangesKt.coerceAtMost(index2 + 1, this.getCodepointLength()));
        this.selectionInChars = TextRangeKt.TextRange(charIndex);
    }

    public final void placeCursorAfterCharAt(int index2) {
        this.requireValidIndex(index2, false, true, false);
        this.selectionInChars = TextRangeKt.TextRange(RangesKt.coerceAtMost(index2 + 1, this.getLength()));
    }

    public final void selectCodepointsIn-5zc-tL8(long range) {
        this.requireValidRange-72CqOWE(range, true);
        this.selectionInChars = this.codepointsToChars-GEjPoXI(range);
    }

    public final void selectCharsIn-5zc-tL8(long range) {
        this.requireValidRange-72CqOWE(range, false);
        this.selectionInChars = range;
    }

    @NotNull
    public final TextFieldCharSequence toTextFieldCharSequence-OEnZFl4$foundation(@Nullable TextRange composition) {
        return TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.buffer.toString(), this.selectionInChars, composition);
    }

    public static /* synthetic */ TextFieldCharSequence toTextFieldCharSequence-OEnZFl4$foundation$default(TextFieldBuffer textFieldBuffer, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            textRange = null;
        }
        return textFieldBuffer.toTextFieldCharSequence-OEnZFl4$foundation(textRange);
    }

    private final void requireValidIndex(int index2, boolean startExclusive, boolean endExclusive, boolean inCodepoints) {
        int start2 = 0;
        start2 = startExclusive ? 0 : -1;
        int end2 = 0;
        int n = end2 = endExclusive ? this.getLength() : this.getLength() + 1;
        if (inCodepoints) {
            start2 = this.charIndexToCodepointIndex(start2);
            end2 = this.charIndexToCodepointIndex(end2);
        }
        if (!(start2 <= index2 ? index2 < end2 : false)) {
            boolean bl = false;
            String unit = inCodepoints ? "codepoints" : "chars";
            String string = "Expected " + index2 + " to be in [" + start2 + ", " + end2 + ") " + unit;
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void requireValidRange-72CqOWE(long range, boolean inCodepoints) {
        long it = TextRangeKt.TextRange(0, this.getLength());
        boolean bl = false;
        long validRange = inCodepoints ? this.charsToCodepoints-GEjPoXI(it) : it;
        if (!TextRange.contains-5zc-tL8(validRange, range)) {
            boolean bl2 = false;
            String unit = inCodepoints ? "codepoints" : "chars";
            String string = "Expected " + TextRange.toString-impl(range) + " to be in " + TextRange.toString-impl(validRange) + " (" + unit + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final long codepointsToChars-GEjPoXI(long range) {
        return TextRangeKt.TextRange(this.codepointIndexToCharIndex(TextRange.getStart-impl(range)), this.codepointIndexToCharIndex(TextRange.getEnd-impl(range)));
    }

    private final long charsToCodepoints-GEjPoXI(long range) {
        return TextRangeKt.TextRange(this.charIndexToCodepointIndex(TextRange.getStart-impl(range)), this.charIndexToCodepointIndex(TextRange.getEnd-impl(range)));
    }

    private final int codepointIndexToCharIndex(int index2) {
        return index2;
    }

    private final int charIndexToCodepointIndex(int index2) {
        return index2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0002\u0082\u0002\u0011\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldBuffer$ChangeList;", "", "changeCount", "", "getChangeCount", "()I", "getOriginalRange", "Landroidx/compose/ui/text/TextRange;", "changeIndex", "getOriginalRange--jx7JFs", "(I)J", "getRange", "getRange--jx7JFs", "foundation"})
    @ExperimentalFoundationApi
    public static interface ChangeList {
        public int getChangeCount();

        public long getRange--jx7JFs(int var1);

        public long getOriginalRange--jx7JFs(int var1);
    }
}

